/*
 * Decompiled with CFR 0.152.
 */
package checkers.formatter;

import checkers.basetype.BaseTypeChecker;
import checkers.flow.CFStore;
import checkers.flow.CFValue;
import checkers.formatter.FormatUtil;
import checkers.formatter.FormatterAnalysis;
import checkers.formatter.FormatterTransfer;
import checkers.formatter.FormatterTreeUtil;
import checkers.formatter.quals.ConversionCategory;
import checkers.formatter.quals.Format;
import checkers.formatter.quals.FormatBottom;
import checkers.formatter.quals.InvalidFormat;
import checkers.types.AbstractBasicAnnotatedTypeFactory;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TreeAnnotator;
import checkers.util.GraphQualifierHierarchy;
import checkers.util.MultiGraphQualifierHierarchy;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.util.IllegalFormatException;
import javacutils.AnnotationUtils;
import javax.lang.model.element.AnnotationMirror;

public class FormatterAnnotatedTypeFactory
extends AbstractBasicAnnotatedTypeFactory<CFValue, CFStore, FormatterTransfer, FormatterAnalysis> {
    private final AnnotationMirror FORMAT;
    private final AnnotationMirror INVALIDFORMAT;
    private final AnnotationMirror FORMATBOTTOM;
    protected final FormatterTreeUtil treeUtil;

    public FormatterAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.FORMAT = AnnotationUtils.fromClass(this.elements, Format.class);
        this.INVALIDFORMAT = AnnotationUtils.fromClass(this.elements, InvalidFormat.class);
        this.FORMATBOTTOM = AnnotationUtils.fromClass(this.elements, FormatBottom.class);
        this.treeUtil = new FormatterTreeUtil(checker);
        this.postInit();
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new FormatterQualifierHierarchy(factory);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new FormatterTreeAnnotator(this);
    }

    class FormatterQualifierHierarchy
    extends GraphQualifierHierarchy {
        public FormatterQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
            super(f, FormatterAnnotatedTypeFactory.this.FORMATBOTTOM);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(rhs, FormatterAnnotatedTypeFactory.this.FORMAT) && AnnotationUtils.areSameIgnoringValues(lhs, FormatterAnnotatedTypeFactory.this.FORMAT)) {
                ConversionCategory[] lhsArgTypes;
                ConversionCategory[] rhsArgTypes = FormatterAnnotatedTypeFactory.this.treeUtil.formatAnnotationToCategories(rhs);
                if (rhsArgTypes.length != (lhsArgTypes = FormatterAnnotatedTypeFactory.this.treeUtil.formatAnnotationToCategories(lhs)).length) {
                    return false;
                }
                for (int i = 0; i < rhsArgTypes.length; ++i) {
                    if (ConversionCategory.isSubsetOf(lhsArgTypes[i], rhsArgTypes[i])) continue;
                    return false;
                }
                return true;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, FormatterAnnotatedTypeFactory.this.FORMAT)) {
                lhs = FormatterAnnotatedTypeFactory.this.FORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, FormatterAnnotatedTypeFactory.this.FORMAT)) {
                rhs = FormatterAnnotatedTypeFactory.this.FORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, FormatterAnnotatedTypeFactory.this.INVALIDFORMAT)) {
                lhs = FormatterAnnotatedTypeFactory.this.INVALIDFORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, FormatterAnnotatedTypeFactory.this.INVALIDFORMAT)) {
                rhs = FormatterAnnotatedTypeFactory.this.INVALIDFORMAT;
            }
            return super.isSubtype(rhs, lhs);
        }
    }

    private class FormatterTreeAnnotator
    extends TreeAnnotator {
        public FormatterTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitLiteral(LiteralTree tree2, AnnotatedTypeMirror type2) {
            if (!type2.isAnnotatedInHierarchy(FormatterAnnotatedTypeFactory.this.FORMAT)) {
                String format = null;
                if (tree2.getKind() == Tree.Kind.STRING_LITERAL) {
                    format = (String)tree2.getValue();
                } else if (tree2.getKind() == Tree.Kind.CHAR_LITERAL) {
                    format = Character.toString(((Character)tree2.getValue()).charValue());
                }
                if (format != null) {
                    AnnotationMirror anno;
                    try {
                        ConversionCategory[] cs = FormatUtil.formatParameterCategories(format);
                        anno = FormatterAnnotatedTypeFactory.this.treeUtil.categoriesToFormatAnnotation(cs);
                    }
                    catch (IllegalFormatException e) {
                        anno = FormatterAnnotatedTypeFactory.this.treeUtil.exceptionToInvalidFormatAnnotation(e);
                    }
                    type2.addAnnotation(anno);
                }
            }
            return super.visitLiteral(tree2, type2);
        }
    }
}

