/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.flow.CFAbstractStore;
import checkers.initialization.InitializationTransfer;
import checkers.initialization.quals.Initialized;
import checkers.nullness.NullnessAnalysis;
import checkers.nullness.NullnessStore;
import checkers.nullness.NullnessValue;
import checkers.nullness.quals.NonNull;
import checkers.nullness.quals.NonRaw;
import checkers.nullness.quals.Nullable;
import checkers.nullness.quals.PolyNull;
import checkers.quals.PolyAll;
import checkers.types.AnnotatedTypeMirror;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import dataflow.analysis.ConditionalTransferResult;
import dataflow.analysis.FlowExpressions;
import dataflow.analysis.RegularTransferResult;
import dataflow.analysis.TransferInput;
import dataflow.analysis.TransferResult;
import dataflow.cfg.node.ArrayAccessNode;
import dataflow.cfg.node.FieldAccessNode;
import dataflow.cfg.node.MethodAccessNode;
import dataflow.cfg.node.MethodInvocationNode;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NullLiteralNode;
import dataflow.cfg.node.ReturnNode;
import dataflow.cfg.node.ThrowNode;
import java.util.List;
import javacutils.AnnotationUtils;
import javacutils.TreeUtils;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;

public class NullnessTransfer
extends InitializationTransfer<NullnessValue, NullnessTransfer, NullnessStore> {
    protected final NullnessAnalysis analysis;
    protected final AnnotationMirror NONNULL;
    protected final AnnotationMirror NULLABLE;

    public NullnessTransfer(NullnessAnalysis analysis) {
        super(analysis);
        this.analysis = analysis;
        this.NONNULL = AnnotationUtils.fromClass(analysis.getTypeFactory().getElementUtils(), NonNull.class);
        this.NULLABLE = AnnotationUtils.fromClass(analysis.getTypeFactory().getElementUtils(), Nullable.class);
    }

    protected void makeNonNull(NullnessStore store, Node node) {
        FlowExpressions.Receiver internalRepr = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node);
        store.insertValue(internalRepr, this.NONNULL);
    }

    protected void makeNonNull(TransferResult<NullnessValue, NullnessStore> result2, Node node) {
        if (result2.containsTwoStores()) {
            this.makeNonNull(result2.getThenStore(), node);
            this.makeNonNull(result2.getElseStore(), node);
        } else {
            this.makeNonNull(result2.getRegularStore(), node);
        }
    }

    @Override
    protected NullnessValue finishValue(NullnessValue value2, NullnessStore store) {
        if ((value2 = super.finishValue(value2, store)) != null) {
            value2.isPolyNullNull = store.isPolyNullNull();
        }
        return value2;
    }

    @Override
    protected TransferResult<NullnessValue, NullnessStore> strengthenAnnotationOfEqualTo(TransferResult<NullnessValue, NullnessStore> res, Node firstNode, Node secondNode, NullnessValue firstValue, NullnessValue secondValue, boolean notEqualTo) {
        res = super.strengthenAnnotationOfEqualTo(res, firstNode, secondNode, firstValue, secondValue, notEqualTo);
        if (firstNode instanceof NullLiteralNode) {
            NullnessStore thenStore = res.getThenStore();
            NullnessStore elseStore = res.getElseStore();
            List<Node> secondParts = this.splitAssignments(secondNode);
            for (Node secondPart : secondParts) {
                FlowExpressions.Receiver secondInternal = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), secondPart);
                if (!CFAbstractStore.canInsertReceiver(secondInternal)) continue;
                thenStore = thenStore == null ? res.getThenStore() : thenStore;
                NullnessStore nullnessStore = elseStore = elseStore == null ? res.getElseStore() : elseStore;
                if (notEqualTo) {
                    thenStore.insertValue(secondInternal, this.NONNULL);
                    continue;
                }
                elseStore.insertValue(secondInternal, this.NONNULL);
            }
            if (secondValue != null && (secondValue.getType().hasAnnotation(PolyNull.class) || secondValue.getType().hasAnnotation(PolyAll.class))) {
                thenStore = thenStore == null ? res.getThenStore() : thenStore;
                elseStore = elseStore == null ? res.getElseStore() : elseStore;
                thenStore.setPolyNullNull(true);
            }
            if (thenStore != null) {
                return new ConditionalTransferResult<NullnessValue, NullnessStore>(res.getResultValue(), thenStore, elseStore);
            }
        }
        return res;
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitArrayAccess(ArrayAccessNode n, TransferInput<NullnessValue, NullnessStore> p) {
        TransferResult<NullnessValue, NullnessStore> result2 = super.visitArrayAccess(n, p);
        this.makeNonNull(result2, n.getArray());
        return result2;
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitMethodAccess(MethodAccessNode n, TransferInput<NullnessValue, NullnessStore> p) {
        TransferResult result2 = (TransferResult)super.visitMethodAccess(n, p);
        this.makeNonNull(result2, n.getReceiver());
        return result2;
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitFieldAccess(FieldAccessNode n, TransferInput<NullnessValue, NullnessStore> p) {
        TransferResult<NullnessValue, NullnessStore> result2 = super.visitFieldAccess(n, p);
        this.makeNonNull(result2, n.getReceiver());
        return result2;
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitThrow(ThrowNode n, TransferInput<NullnessValue, NullnessStore> p) {
        TransferResult result2 = (TransferResult)super.visitThrow(n, p);
        this.makeNonNull(result2, n.getExpression());
        return result2;
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<NullnessValue, NullnessStore> in) {
        TransferResult<NullnessValue, NullnessStore> result2 = super.visitMethodInvocation(n, in);
        this.makeNonNull(result2, n.getTarget().getReceiver());
        MethodInvocationTree tree2 = n.getTree();
        ExecutableElement method = TreeUtils.elementFromUse(tree2);
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.analysis.getTypeFactory().getAnnotatedType(method);
        List<AnnotatedTypeMirror> methodParams = methodType.getParameterTypes();
        List<? extends ExpressionTree> methodArgs = tree2.getArguments();
        for (int i = 0; i < methodParams.size() && i < methodArgs.size(); ++i) {
            if (!methodParams.get(i).hasAnnotation(this.NONNULL)) continue;
            this.makeNonNull(result2, n.getArgument(i));
        }
        return result2;
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitReturn(ReturnNode n, TransferInput<NullnessValue, NullnessStore> in) {
        NullnessValue value2 = this.createDummyValue();
        if (in.containsTwoStores()) {
            NullnessStore thenStore = in.getThenStore();
            NullnessStore elseStore = in.getElseStore();
            return new ConditionalTransferResult<NullnessValue, NullnessStore>(this.finishValue(value2, thenStore, elseStore), thenStore, elseStore);
        }
        NullnessStore info2 = in.getRegularStore();
        return new RegularTransferResult<NullnessValue, NullnessStore>(this.finishValue(value2, info2), info2);
    }

    private NullnessValue createDummyValue() {
        PrimitiveType dummy2 = this.analysis.getEnv().getTypeUtils().getPrimitiveType(TypeKind.BOOLEAN);
        AnnotatedTypeMirror annotatedDummy = AnnotatedTypeMirror.createType(dummy2, this.analysis.getTypeFactory());
        annotatedDummy.addAnnotation(NonNull.class);
        annotatedDummy.addAnnotation(NonRaw.class);
        annotatedDummy.addAnnotation(Initialized.class);
        NullnessValue value2 = new NullnessValue(this.analysis, annotatedDummy);
        return value2;
    }
}

