/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.nullness.NullnessAnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javacutils.TreeUtils;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;

public class SystemGetPropertyHandler {
    protected final ProcessingEnvironment env;
    protected final NullnessAnnotatedTypeFactory factory;
    protected final ExecutableElement systemGetProperty;
    Collection<String> systemProperties = new HashSet<String>(Arrays.asList("java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir"));

    public SystemGetPropertyHandler(ProcessingEnvironment env, NullnessAnnotatedTypeFactory factory) {
        this.env = env;
        this.factory = factory;
        this.systemGetProperty = TreeUtils.getMethod("java.lang.System", "getProperty", 1, env);
    }

    public void handle(MethodInvocationTree tree2, AnnotatedTypeMirror.AnnotatedExecutableType method) {
        if (TreeUtils.isMethodInvocation(tree2, this.systemGetProperty, this.env)) {
            String literal;
            List<? extends ExpressionTree> args2 = tree2.getArguments();
            assert (args2.size() == 1);
            ExpressionTree arg = args2.get(0);
            if (arg.getKind() == Tree.Kind.STRING_LITERAL && this.systemProperties.contains(literal = (String)((LiteralTree)arg).getValue())) {
                AnnotatedTypeMirror type2 = method.getReturnType();
                type2.replaceAnnotation(this.factory.NONNULL);
            }
        }
    }
}

