/*
 * Decompiled with CFR 0.152.
 */
package checkers.source;

import checkers.source.AggregateVisitor;
import checkers.source.SourceChecker;
import checkers.source.SourceVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;

public abstract class AggregateChecker
extends SourceChecker {
    protected List<SourceChecker> checkers;
    private boolean allCheckersInited = false;
    int errsOnLastExit = 0;

    protected abstract Collection<Class<? extends SourceChecker>> getSupportedCheckers();

    public AggregateChecker() {
        Collection<Class<? extends SourceChecker>> checkerClasses = this.getSupportedCheckers();
        this.checkers = new ArrayList<SourceChecker>(checkerClasses.size());
        for (Class<? extends SourceChecker> checkerClass : checkerClasses) {
            try {
                SourceChecker instance2 = checkerClass.newInstance();
                this.checkers.add(instance2);
            }
            catch (Exception e) {
                System.err.println("Couldn't instantiate an instance of " + checkerClass);
            }
        }
    }

    @Override
    public final void init(ProcessingEnvironment env) {
        super.init(env);
        for (SourceChecker checker : this.checkers) {
            checker.setProcessingEnvironment(env);
        }
    }

    @Override
    public void initChecker() {
        super.initChecker();
        for (SourceChecker checker : this.checkers) {
            checker.initChecker();
        }
        for (SourceChecker checker : this.checkers) {
            checker.addOptions(super.getOptions());
            checker.setSupportedLintOptions(this.getSupportedLintOptions());
        }
        this.allCheckersInited = true;
    }

    @Override
    public final void typeProcess(TypeElement element, TreePath tree2) {
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        Log log = Log.instance(context);
        if (log.nerrors > this.errsOnLastExit) {
            this.errsOnLastExit = log.nerrors;
            return;
        }
        if (!this.allCheckersInited) {
            return;
        }
        for (SourceChecker checker : this.checkers) {
            checker.errsOnLastExit = this.errsOnLastExit;
            checker.typeProcess(element, tree2);
            this.errsOnLastExit = checker.errsOnLastExit;
        }
    }

    @Override
    public void typeProcessingOver() {
        for (SourceChecker checker : this.checkers) {
            checker.typeProcessingOver();
        }
    }

    @Override
    public final Set<String> getSupportedOptions() {
        HashSet<String> options2 = new HashSet<String>();
        for (SourceChecker checker : this.checkers) {
            options2.addAll(checker.getSupportedOptions());
        }
        options2.addAll(this.expandCFOptions(Arrays.asList(this.getClass()), options2.toArray(new String[0])));
        return options2;
    }

    @Override
    public final Map<String, String> getOptions() {
        HashMap<String, String> options2 = new HashMap<String, String>(super.getOptions());
        for (SourceChecker checker : this.checkers) {
            options2.putAll(checker.getOptions());
        }
        return options2;
    }

    @Override
    public final Set<String> getSupportedLintOptions() {
        HashSet<String> lints = new HashSet<String>();
        for (SourceChecker checker : this.checkers) {
            lints.addAll(checker.getSupportedLintOptions());
        }
        return lints;
    }

    @Override
    protected SourceVisitor<?, ?> createSourceVisitor() {
        return new AggregateVisitor(this);
    }
}

