/*
 * Decompiled with CFR 0.152.
 */
package checkers.util.stub;

import cfjapa.parser.ast.CompilationUnit;
import cfjapa.parser.ast.IndexUnit;
import cfjapa.parser.ast.Node;
import cfjapa.parser.ast.body.BodyDeclaration;
import cfjapa.parser.ast.body.ConstructorDeclaration;
import cfjapa.parser.ast.body.FieldDeclaration;
import cfjapa.parser.ast.body.MethodDeclaration;
import cfjapa.parser.ast.body.Parameter;
import cfjapa.parser.ast.body.TypeDeclaration;
import cfjapa.parser.ast.body.VariableDeclarator;
import cfjapa.parser.ast.type.ClassOrInterfaceType;
import cfjapa.parser.ast.type.PrimitiveType;
import cfjapa.parser.ast.type.ReferenceType;
import cfjapa.parser.ast.type.VoidType;
import cfjapa.parser.ast.type.WildcardType;
import cfjapa.parser.ast.visitor.SimpleVoidVisitor;
import checkers.util.stub.FileStubResource;
import checkers.util.stub.JarEntryStubResource;
import checkers.util.stub.StubResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javacutils.ErrorReporter;
import javacutils.Pair;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class StubUtil {
    static TypeDeclaration findDeclaration(String className, IndexUnit indexFile) {
        int indexOfDot = className.lastIndexOf(46);
        if (indexOfDot == -1) {
            assert (!indexFile.getCompilationUnits().isEmpty());
            assert (indexFile.getCompilationUnits().get(0).getPackage() == null);
            return StubUtil.findDeclaration(className, indexFile.getCompilationUnits().get(0));
        }
        String packageName = className.substring(0, indexOfDot);
        String simpleName2 = className.substring(indexOfDot + 1);
        for (CompilationUnit cu : indexFile.getCompilationUnits()) {
            TypeDeclaration type2;
            if (cu.getPackage() == null || !cu.getPackage().getName().getName().equals(packageName) || (type2 = StubUtil.findDeclaration(simpleName2, cu)) == null) continue;
            return type2;
        }
        return null;
    }

    static TypeDeclaration findDeclaration(TypeElement type2, IndexUnit indexFile) {
        return StubUtil.findDeclaration(type2.getQualifiedName().toString(), indexFile);
    }

    static FieldDeclaration findDeclaration(VariableElement field, IndexUnit indexFile) {
        TypeDeclaration type2 = StubUtil.findDeclaration((TypeElement)field.getEnclosingElement(), indexFile);
        if (type2 == null) {
            return null;
        }
        for (BodyDeclaration member : type2.getMembers()) {
            if (!(member instanceof FieldDeclaration)) continue;
            FieldDeclaration decl = (FieldDeclaration)member;
            for (VariableDeclarator var : decl.getVariables()) {
                if (!StubUtil.toString(var).equals(field.getSimpleName().toString())) continue;
                return decl;
            }
        }
        return null;
    }

    static BodyDeclaration findDeclaration(ExecutableElement method, IndexUnit indexFile) {
        TypeDeclaration type2 = StubUtil.findDeclaration((TypeElement)method.getEnclosingElement(), indexFile);
        if (type2 == null) {
            return null;
        }
        String methodRep = StubUtil.toString(method);
        for (BodyDeclaration member : type2.getMembers()) {
            if (!(member instanceof MethodDeclaration ? StubUtil.toString((MethodDeclaration)member).equals(methodRep) : member instanceof ConstructorDeclaration && StubUtil.toString((ConstructorDeclaration)member).equals(methodRep))) continue;
            return member;
        }
        return null;
    }

    static TypeDeclaration findDeclaration(String simpleName2, CompilationUnit cu) {
        for (TypeDeclaration type2 : cu.getTypes()) {
            if (!simpleName2.equals(type2.getName())) continue;
            return type2;
        }
        return null;
    }

    static String toString(MethodDeclaration method) {
        return ElementPrinter.toString(method);
    }

    static String toString(ConstructorDeclaration constructor) {
        return ElementPrinter.toString(constructor);
    }

    static String toString(VariableDeclarator field) {
        return field.getId().getName();
    }

    static String toString(FieldDeclaration field) {
        assert (field.getVariables().size() == 1);
        return StubUtil.toString(field.getVariables().get(0));
    }

    static String toString(ExecutableElement element) {
        StringBuilder sb = new StringBuilder();
        sb.append(element.getSimpleName());
        sb.append("(");
        Iterator<? extends VariableElement> i = element.getParameters().iterator();
        while (i.hasNext()) {
            sb.append(StubUtil.standarizeType(i.next().asType()));
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    static String toString(VariableElement element) {
        assert (element.getKind().isField());
        return element.getSimpleName().toString();
    }

    static String toString(Element element) {
        if (element instanceof ExecutableElement) {
            return StubUtil.toString((ExecutableElement)element);
        }
        if (element instanceof VariableElement) {
            return StubUtil.toString((VariableElement)element);
        }
        return null;
    }

    static Pair<String, String> partitionQualifiedName(String imported) {
        String typeName = imported.substring(0, imported.lastIndexOf("."));
        String name = imported.substring(imported.lastIndexOf(".") + 1);
        Pair<String, String> typeParts = Pair.of(typeName, name);
        return typeParts;
    }

    private static String standarizeType(TypeMirror type2) {
        switch (type2.getKind()) {
            case ARRAY: {
                return StubUtil.standarizeType(((ArrayType)type2).getComponentType()) + "[]";
            }
            case TYPEVAR: {
                return ((TypeVariable)type2).asElement().getSimpleName().toString();
            }
            case DECLARED: {
                return ((DeclaredType)type2).asElement().getSimpleName().toString();
            }
        }
        if (type2.getKind().isPrimitive()) {
            return type2.toString();
        }
        ErrorReporter.errorAbort("StubUtil: unhandled type: " + type2);
        return null;
    }

    public static List<StubResource> allStubFiles(String stub) {
        ArrayList<StubResource> resources = new ArrayList<StubResource>();
        File stubFile = new File(stub);
        StubUtil.allStubFiles(stubFile, resources);
        return resources;
    }

    private static boolean isStub(File f) {
        return f.isFile() && StubUtil.isStub(f.getName());
    }

    private static boolean isStub(String path) {
        return path.endsWith(".astub");
    }

    private static boolean isJar(File f) {
        return f.isFile() && f.getName().endsWith(".jar");
    }

    private static void allStubFiles(File stub, List<StubResource> resources) {
        block5: {
            block6: {
                JarFile file2;
                block4: {
                    if (!StubUtil.isStub(stub)) break block4;
                    resources.add(new FileStubResource(stub));
                    break block5;
                }
                if (!StubUtil.isJar(stub)) break block6;
                try {
                    file2 = new JarFile(stub);
                }
                catch (IOException e) {
                    System.err.println("StubUtil: could not process JAR file: " + stub);
                    return;
                }
                Enumeration<JarEntry> entries2 = file2.entries();
                while (entries2.hasMoreElements()) {
                    JarEntry entry = entries2.nextElement();
                    if (!StubUtil.isStub(entry.getName())) continue;
                    resources.add(new JarEntryStubResource(file2, entry));
                }
                break block5;
            }
            if (!stub.isDirectory()) break block5;
            for (File enclosed : stub.listFiles()) {
                StubUtil.allStubFiles(enclosed, resources);
            }
        }
    }

    private static final class ElementPrinter
    extends SimpleVoidVisitor<Void> {
        private final StringBuilder sb = new StringBuilder();

        private ElementPrinter() {
        }

        public static String toString(Node n) {
            ElementPrinter printer = new ElementPrinter();
            n.accept(printer, null);
            return printer.getOutput();
        }

        public String getOutput() {
            return this.sb.toString();
        }

        @Override
        public void visit(ConstructorDeclaration n, Void arg) {
            this.sb.append("<init>");
            this.sb.append("(");
            if (n.getParameters() != null) {
                Iterator<Parameter> i = n.getParameters().iterator();
                while (i.hasNext()) {
                    Parameter p = i.next();
                    p.accept(this, arg);
                    if (!i.hasNext()) continue;
                    this.sb.append(",");
                }
            }
            this.sb.append(")");
        }

        @Override
        public void visit(MethodDeclaration n, Void arg) {
            this.sb.append(n.getName());
            this.sb.append("(");
            if (n.getParameters() != null) {
                Iterator<Parameter> i = n.getParameters().iterator();
                while (i.hasNext()) {
                    Parameter p = i.next();
                    p.accept(this, arg);
                    if (!i.hasNext()) continue;
                    this.sb.append(",");
                }
            }
            this.sb.append(")");
        }

        @Override
        public void visit(Parameter n, Void arg) {
            if (n.getId().getArrayCount() > 0) {
                ErrorReporter.errorAbort("StubUtil: put array brackets on the type, not the variable: " + n);
            }
            n.getType().accept(this, arg);
            if (n.isVarArgs()) {
                this.sb.append("[]");
            }
        }

        @Override
        public void visit(ClassOrInterfaceType n, Void arg) {
            this.sb.append(n.getName());
        }

        @Override
        public void visit(PrimitiveType n, Void arg) {
            switch (n.getType()) {
                case Boolean: {
                    this.sb.append("boolean");
                    break;
                }
                case Byte: {
                    this.sb.append("byte");
                    break;
                }
                case Char: {
                    this.sb.append("char");
                    break;
                }
                case Double: {
                    this.sb.append("double");
                    break;
                }
                case Float: {
                    this.sb.append("float");
                    break;
                }
                case Int: {
                    this.sb.append("int");
                    break;
                }
                case Long: {
                    this.sb.append("long");
                    break;
                }
                case Short: {
                    this.sb.append("short");
                    break;
                }
                default: {
                    ErrorReporter.errorAbort("StubUtil: unknown type: " + (Object)((Object)n.getType()));
                }
            }
        }

        @Override
        public void visit(ReferenceType n, Void arg) {
            n.getType().accept(this, arg);
            for (int i = 0; i < n.getArrayCount(); ++i) {
                this.sb.append("[]");
            }
        }

        @Override
        public void visit(VoidType n, Void arg) {
            this.sb.append("void");
        }

        @Override
        public void visit(WildcardType n, Void arg) {
            ErrorReporter.errorAbort("StubUtil: don't print type args!");
        }
    }
}

