/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.util.Properties;
import javax.mail.Session;

public class PropUtil {
    private PropUtil() {
    }

    public static int getIntProperty(Properties props, String name, int def) {
        return PropUtil.getInt(PropUtil.getProp(props, name), def);
    }

    public static boolean getBooleanProperty(Properties props, String name, boolean def) {
        return PropUtil.getBoolean(PropUtil.getProp(props, name), def);
    }

    @Deprecated
    public static int getIntSessionProperty(Session session, String name, int def) {
        return PropUtil.getInt(PropUtil.getProp(session.getProperties(), name), def);
    }

    @Deprecated
    public static boolean getBooleanSessionProperty(Session session, String name, boolean def) {
        return PropUtil.getBoolean(PropUtil.getProp(session.getProperties(), name), def);
    }

    public static boolean getBooleanSystemProperty(String name, boolean def) {
        try {
            return PropUtil.getBoolean(PropUtil.getProp(System.getProperties(), name), def);
        }
        catch (SecurityException securityException) {
            try {
                String value2 = System.getProperty(name);
                if (value2 == null) {
                    return def;
                }
                if (def) {
                    return !value2.equalsIgnoreCase("false");
                }
                return value2.equalsIgnoreCase("true");
            }
            catch (SecurityException sex) {
                return def;
            }
        }
    }

    private static Object getProp(Properties props, String name) {
        Object val = props.get(name);
        if (val != null) {
            return val;
        }
        return props.getProperty(name);
    }

    private static int getInt(Object value2, int def) {
        if (value2 == null) {
            return def;
        }
        if (value2 instanceof String) {
            try {
                return Integer.parseInt((String)value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value2 instanceof Integer) {
            return (Integer)value2;
        }
        return def;
    }

    private static boolean getBoolean(Object value2, boolean def) {
        if (value2 == null) {
            return def;
        }
        if (value2 instanceof String) {
            if (def) {
                return !((String)value2).equalsIgnoreCase("false");
            }
            return ((String)value2).equalsIgnoreCase("true");
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        return def;
    }
}

