/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.Collections;
import javacutils.InternalUtils;
import javacutils.TreeUtils;
import javax.lang.model.element.Element;

public class LocalVariableNode
extends Node {
    protected Tree tree;

    public LocalVariableNode(Tree t) {
        super(InternalUtils.typeOf(t));
        assert (t != null);
        assert (t instanceof IdentifierTree || t instanceof VariableTree);
        this.tree = t;
    }

    public Element getElement() {
        Element el;
        if (this.tree instanceof IdentifierTree) {
            el = TreeUtils.elementFromUse((IdentifierTree)this.tree);
        } else {
            assert (this.tree instanceof VariableTree);
            el = TreeUtils.elementFromDeclaration((VariableTree)this.tree);
        }
        return el;
    }

    public String getName() {
        if (this.tree instanceof IdentifierTree) {
            return ((IdentifierTree)this.tree).getName().toString();
        }
        return ((VariableTree)this.tree).getName().toString();
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor2, P p) {
        return visitor2.visitLocalVariable(this, p);
    }

    public String toString() {
        return this.getName().toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LocalVariableNode)) {
            return false;
        }
        LocalVariableNode other = (LocalVariableNode)obj;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return HashCodeUtils.hash((Object)this.getName());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.emptyList();
    }
}

