/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import javacutils.InternalUtils;

public class TernaryExpressionNode
extends Node {
    protected ConditionalExpressionTree tree;
    protected Node condition;
    protected Node thenOperand;
    protected Node elseOperand;

    public TernaryExpressionNode(ConditionalExpressionTree tree2, Node condition, Node thenOperand, Node elseOperand) {
        super(InternalUtils.typeOf(tree2));
        assert (tree2.getKind().equals((Object)Tree.Kind.CONDITIONAL_EXPRESSION));
        this.tree = tree2;
        this.condition = condition;
        this.thenOperand = thenOperand;
        this.elseOperand = elseOperand;
    }

    public Node getConditionOperand() {
        return this.condition;
    }

    public Node getThenOperand() {
        return this.thenOperand;
    }

    public Node getElseOperand() {
        return this.elseOperand;
    }

    @Override
    public ConditionalExpressionTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor2, P p) {
        return visitor2.visitTernaryExpression(this, p);
    }

    public String toString() {
        return "(" + this.getConditionOperand() + " ? " + this.getThenOperand() + " : " + this.getElseOperand() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TernaryExpressionNode)) {
            return false;
        }
        TernaryExpressionNode other = (TernaryExpressionNode)obj;
        return this.getConditionOperand().equals(other.getConditionOperand()) && this.getThenOperand().equals(other.getThenOperand()) && this.getElseOperand().equals(other.getElseOperand());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getConditionOperand(), this.getThenOperand(), this.getElseOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list2 = new LinkedList<Node>();
        list2.add(this.getConditionOperand());
        list2.add(this.getThenOperand());
        list2.add(this.getElseOperand());
        return list2;
    }
}

