/*
 * Decompiled with CFR 0.152.
 */
package javacutils;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javacutils.ErrorReporter;
import javacutils.TreeUtils;
import javacutils.TypesUtils;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;

public class InternalUtils {
    private static final boolean RETURN_INVOKE_CONSTRUCTOR = true;

    private InternalUtils() {
        throw new AssertionError((Object)"Class InternalUtils cannot be instantiated.");
    }

    public static Element symbol(Tree tree2) {
        if (tree2 == null) {
            ErrorReporter.errorAbort("InternalUtils.symbol: tree is null");
            return null;
        }
        if (!(tree2 instanceof JCTree)) {
            ErrorReporter.errorAbort("InternalUtils.symbol: tree is not a valid Javac tree");
            return null;
        }
        if (TreeUtils.isExpressionTree(tree2)) {
            tree2 = TreeUtils.skipParens((ExpressionTree)tree2);
        }
        switch (tree2.getKind()) {
            case VARIABLE: 
            case METHOD: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: 
            case TYPE_PARAMETER: {
                return TreeInfo.symbolFor((JCTree)tree2);
            }
            case METHOD_INVOCATION: {
                return TreeInfo.symbol(((JCTree.JCMethodInvocation)tree2).getMethodSelect());
            }
            case ASSIGNMENT: {
                return TreeInfo.symbol((JCTree)((Object)((AssignmentTree)tree2).getVariable()));
            }
            case ARRAY_ACCESS: {
                return InternalUtils.symbol(((ArrayAccessTree)tree2).getExpression());
            }
            case NEW_CLASS: {
                return ((JCTree.JCNewClass)tree2).constructor;
            }
        }
        return TreeInfo.symbol((JCTree)tree2);
    }

    public static boolean isAnonymousConstructor(MethodTree method) {
        Element e = InternalUtils.symbol(method);
        if (e == null || !(e instanceof Symbol)) {
            return false;
        }
        return (((Symbol)e).flags() & 0x20000000L) != 0L;
    }

    public static ExecutableElement constructor(NewClassTree tree2) {
        if (!(tree2 instanceof JCTree.JCNewClass)) {
            ErrorReporter.errorAbort("InternalUtils.constructor: not a javac internal tree");
            return null;
        }
        JCTree.JCNewClass newClassTree = (JCTree.JCNewClass)tree2;
        if (tree2.getClassBody() != null) {
            JCTree.JCMethodDecl anonConstructor = (JCTree.JCMethodDecl)TreeInfo.declarationFor(newClassTree.constructor, newClassTree);
            assert (anonConstructor != null);
            assert (anonConstructor.body.stats.size() == 1);
            JCTree.JCExpressionStatement stmt = (JCTree.JCExpressionStatement)anonConstructor.body.stats.head;
            JCTree.JCMethodInvocation superInvok = (JCTree.JCMethodInvocation)stmt.expr;
            return (ExecutableElement)((Object)TreeInfo.symbol(superInvok.meth));
        }
        Symbol e = newClassTree.constructor;
        assert (e instanceof ExecutableElement);
        return (ExecutableElement)((Object)e);
    }

    public static final List<AnnotationMirror> annotationsFromTypeAnnotationTrees(List<? extends AnnotationTree> annos) {
        ArrayList<AnnotationMirror> annotations2 = new ArrayList<AnnotationMirror>(annos.size());
        for (AnnotationTree annotationTree : annos) {
            annotations2.add(((JCTree.JCAnnotation)annotationTree).attribute);
        }
        return annotations2;
    }

    public static final List<? extends AnnotationMirror> annotationsFromTree(AnnotatedTypeTree node) {
        return InternalUtils.annotationsFromTypeAnnotationTrees(((JCTree.JCAnnotatedType)node).annotations);
    }

    public static final List<? extends AnnotationMirror> annotationsFromTree(TypeParameterTree node) {
        return InternalUtils.annotationsFromTypeAnnotationTrees(((JCTree.JCTypeParameter)node).annotations);
    }

    public static final List<? extends AnnotationMirror> annotationsFromArrayCreation(NewArrayTree node, int level) {
        assert (node instanceof JCTree.JCNewArray);
        JCTree.JCNewArray newArray = (JCTree.JCNewArray)node;
        if (level == -1) {
            return InternalUtils.annotationsFromTypeAnnotationTrees(newArray.annotations);
        }
        if (newArray.dimAnnotations.length() > 0 && level >= 0 && level < newArray.dimAnnotations.size()) {
            return InternalUtils.annotationsFromTypeAnnotationTrees((List<? extends AnnotationTree>)newArray.dimAnnotations.get(level));
        }
        return Collections.emptyList();
    }

    public static TypeMirror typeOf(Tree tree2) {
        return ((JCTree)tree2).type;
    }

    public static boolean isCaptured(TypeVariable typeVar) {
        return ((Type.TypeVar)typeVar).isCaptured();
    }

    public static boolean isClassType(TypeMirror type2) {
        return type2 instanceof Type.ClassType;
    }

    public static TypeMirror leastUpperBound(ProcessingEnvironment processingEnv, TypeMirror tm1, TypeMirror tm2) {
        Type bound;
        Type t1 = (Type)tm1;
        Type t2 = (Type)tm2;
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)processingEnv;
        Types types = Types.instance(javacEnv.getContext());
        if (types.isSameType(t1, t2)) {
            return t1;
        }
        if (t1.getKind() == TypeKind.NULL) {
            return t2;
        }
        if (t2.getKind() == TypeKind.NULL) {
            return t1;
        }
        if (TypesUtils.isPrimitive(t1) || TypesUtils.isPrimitive(t2)) {
            if (types.isAssignable(t1, t2)) {
                return t2;
            }
            if (types.isAssignable(t2, t1)) {
                return t1;
            }
            return processingEnv.getTypeUtils().getNoType(TypeKind.NONE);
        }
        if (t1.getKind() == TypeKind.WILDCARD) {
            WildcardType wc1 = (WildcardType)((Object)t1);
            bound = (Type)wc1.getExtendsBound();
            if (bound == null) {
                Elements elements = processingEnv.getElementUtils();
                return elements.getTypeElement("java.lang.Object").asType();
            }
            t1 = bound;
        }
        if (t2.getKind() == TypeKind.WILDCARD) {
            WildcardType wc2 = (WildcardType)((Object)t2);
            bound = (Type)wc2.getExtendsBound();
            if (bound == null) {
                Elements elements = processingEnv.getElementUtils();
                return elements.getTypeElement("java.lang.Object").asType();
            }
            t2 = bound;
        }
        return types.lub(t1, t2);
    }

    public static TypeMirror greatestLowerBound(ProcessingEnvironment processingEnv, TypeMirror tm1, TypeMirror tm2) {
        Type t1 = (Type)tm1;
        Type t2 = (Type)tm2;
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)processingEnv;
        Types types = Types.instance(javacEnv.getContext());
        if (types.isSameType(t1, t2)) {
            return t1;
        }
        if (t1.getKind() == TypeKind.NULL) {
            return t1;
        }
        if (t2.getKind() == TypeKind.NULL) {
            return t2;
        }
        if (TypesUtils.isPrimitive(t1) || TypesUtils.isPrimitive(t2)) {
            if (types.isAssignable(t1, t2)) {
                return t1;
            }
            if (types.isAssignable(t2, t1)) {
                return t2;
            }
            return processingEnv.getTypeUtils().getNoType(TypeKind.NONE);
        }
        if (t1.getKind() == TypeKind.WILDCARD) {
            return t2;
        }
        if (t2.getKind() == TypeKind.WILDCARD) {
            return t1;
        }
        return types.glb(t1, t2);
    }

    public static TypeMirror substituteMethodReturnType(TypeMirror methodType, TypeMirror substitutedReceiverType) {
        if (methodType.getKind() != TypeKind.TYPEVAR) {
            return methodType;
        }
        String t = methodType.toString();
        Type finalReceiverType = (Type)substitutedReceiverType;
        int i = 0;
        for (Symbol.TypeSymbol typeSymbol : finalReceiverType.tsym.getTypeParameters()) {
            if (t.equals(typeSymbol.toString())) {
                return finalReceiverType.getTypeArguments().get(i);
            }
            ++i;
        }
        assert (false);
        return null;
    }

    public static Context getJavacContext(ProcessingEnvironment env) {
        return ((JavacProcessingEnvironment)env).getContext();
    }
}

