/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.GetPropertyAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Messages;

class ContextFinder {
    private static final Logger logger = Logger.getLogger("javax.xml.bind");
    private static final String PLATFORM_DEFAULT_FACTORY_CLASS = "com.sun.xml.internal.bind.v2.ContextFactory";

    ContextFinder() {
    }

    private static void handleInvocationTargetException(InvocationTargetException x) throws JAXBException {
        Throwable t = x.getTargetException();
        if (t != null) {
            if (t instanceof JAXBException) {
                throw (JAXBException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
    }

    private static JAXBException handleClassCastException(Class originalType, Class targetType) {
        URL targetTypeURL = ContextFinder.which(targetType);
        return new JAXBException(Messages.format("JAXBContext.IllegalCast", ContextFinder.getClassClassLoader(originalType).getResource("javax/xml/bind/JAXBContext.class"), targetTypeURL));
    }

    static JAXBContext newInstance(String contextPath, String className, ClassLoader classLoader2, Map properties2) throws JAXBException {
        try {
            Class spFactory = ContextFinder.safeLoadClass(className, classLoader2);
            return ContextFinder.newInstance(contextPath, spFactory, classLoader2, properties2);
        }
        catch (ClassNotFoundException x) {
            throw new JAXBException(Messages.format("ContextFinder.ProviderNotFound", className), x);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", className, x), x);
        }
    }

    static JAXBContext newInstance(String contextPath, Class spFactory, ClassLoader classLoader2, Map properties2) throws JAXBException {
        try {
            Method m3;
            Object context = null;
            try {
                m3 = spFactory.getMethod("createContext", String.class, ClassLoader.class, Map.class);
                context = m3.invoke(null, contextPath, classLoader2, properties2);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (context == null) {
                m3 = spFactory.getMethod("createContext", String.class, ClassLoader.class);
                context = m3.invoke(null, contextPath, classLoader2);
            }
            if (!(context instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(context.getClass(), JAXBContext.class);
            }
            return (JAXBContext)context;
        }
        catch (InvocationTargetException x) {
            ContextFinder.handleInvocationTargetException(x);
            Throwable e = x;
            if (x.getTargetException() != null) {
                e = x.getTargetException();
            }
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", spFactory, e), e);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", spFactory, x), x);
        }
    }

    static JAXBContext newInstance(Class[] classes2, Map properties2, String className) throws JAXBException {
        Class spi;
        ClassLoader cl = ContextFinder.getContextClassLoader();
        try {
            spi = ContextFinder.safeLoadClass(className, cl);
        }
        catch (ClassNotFoundException e) {
            throw new JAXBException(e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "loaded {0} from {1}", new Object[]{className, ContextFinder.which(spi)});
        }
        return ContextFinder.newInstance(classes2, properties2, spi);
    }

    static JAXBContext newInstance(Class[] classes2, Map properties2, Class spFactory) throws JAXBException {
        Method m3;
        try {
            m3 = spFactory.getMethod("createContext", Class[].class, Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new JAXBException(e);
        }
        try {
            Object context = m3.invoke(null, classes2, properties2);
            if (!(context instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(context.getClass(), JAXBContext.class);
            }
            return (JAXBContext)context;
        }
        catch (IllegalAccessException e) {
            throw new JAXBException(e);
        }
        catch (InvocationTargetException e) {
            ContextFinder.handleInvocationTargetException(e);
            Throwable x = e;
            if (e.getTargetException() != null) {
                x = e.getTargetException();
            }
            throw new JAXBException(x);
        }
    }

    static JAXBContext find(String factoryId, String contextPath, ClassLoader classLoader2, Map properties2) throws JAXBException {
        String jaxbContextFQCN = JAXBContext.class.getName();
        StringTokenizer packages2 = new StringTokenizer(contextPath, ":");
        if (!packages2.hasMoreTokens()) {
            throw new JAXBException(Messages.format("ContextFinder.NoPackageInContextPath"));
        }
        logger.fine("Searching jaxb.properties");
        while (packages2.hasMoreTokens()) {
            String packageName = packages2.nextToken(":").replace('.', '/');
            StringBuilder propFileName = new StringBuilder().append(packageName).append("/jaxb.properties");
            Properties props = ContextFinder.loadJAXBProperties(classLoader2, propFileName.toString());
            if (props == null) continue;
            if (props.containsKey(factoryId)) {
                String factoryClassName = props.getProperty(factoryId);
                return ContextFinder.newInstance(contextPath, factoryClassName, classLoader2, properties2);
            }
            throw new JAXBException(Messages.format("ContextFinder.MissingProperty", packageName, factoryId));
        }
        logger.fine("Searching the system property");
        String factoryClassName = AccessController.doPrivileged(new GetPropertyAction("javax.xml.bind.context.factory"));
        if (factoryClassName != null) {
            return ContextFinder.newInstance(contextPath, factoryClassName, classLoader2, properties2);
        }
        factoryClassName = AccessController.doPrivileged(new GetPropertyAction(jaxbContextFQCN));
        if (factoryClassName != null) {
            return ContextFinder.newInstance(contextPath, factoryClassName, classLoader2, properties2);
        }
        Class jaxbContext = ContextFinder.lookupJaxbContextUsingOsgiServiceLoader();
        if (jaxbContext != null) {
            logger.fine("OSGi environment detected");
            return ContextFinder.newInstance(contextPath, jaxbContext, classLoader2, properties2);
        }
        logger.fine("Searching META-INF/services");
        BufferedReader r = null;
        try {
            StringBuilder resource2 = new StringBuilder().append("META-INF/services/").append(jaxbContextFQCN);
            InputStream resourceStream = classLoader2.getResourceAsStream(resource2.toString());
            if (resourceStream != null) {
                r = new BufferedReader(new InputStreamReader(resourceStream, "UTF-8"));
                factoryClassName = r.readLine();
                if (factoryClassName != null) {
                    factoryClassName = factoryClassName.trim();
                }
                r.close();
                JAXBContext jAXBContext = ContextFinder.newInstance(contextPath, factoryClassName, classLoader2, properties2);
                return jAXBContext;
            }
            logger.log(Level.FINE, "Unable to load:{0}", resource2.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new JAXBException(e);
        }
        catch (IOException e) {
            throw new JAXBException(e);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ContextFinder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(contextPath, PLATFORM_DEFAULT_FACTORY_CLASS, classLoader2, properties2);
    }

    static JAXBContext find(Class[] classes2, Map properties2) throws JAXBException {
        String jaxbContextFQCN = JAXBContext.class.getName();
        for (Class c : classes2) {
            ClassLoader classLoader2 = ContextFinder.getClassClassLoader(c);
            Package pkg = c.getPackage();
            if (pkg == null) continue;
            String packageName = pkg.getName().replace('.', '/');
            String resourceName = packageName + "/jaxb.properties";
            logger.log(Level.FINE, "Trying to locate {0}", resourceName);
            Properties props = ContextFinder.loadJAXBProperties(classLoader2, resourceName);
            if (props == null) {
                logger.fine("  not found");
                continue;
            }
            logger.fine("  found");
            if (props.containsKey("javax.xml.bind.context.factory")) {
                String factoryClassName = props.getProperty("javax.xml.bind.context.factory").trim();
                return ContextFinder.newInstance(classes2, properties2, factoryClassName);
            }
            throw new JAXBException(Messages.format("ContextFinder.MissingProperty", packageName, "javax.xml.bind.context.factory"));
        }
        logger.log(Level.FINE, "Checking system property {0}", "javax.xml.bind.context.factory");
        String factoryClassName = AccessController.doPrivileged(new GetPropertyAction("javax.xml.bind.context.factory"));
        if (factoryClassName != null) {
            logger.log(Level.FINE, "  found {0}", factoryClassName);
            return ContextFinder.newInstance(classes2, properties2, factoryClassName);
        }
        logger.fine("  not found");
        logger.log(Level.FINE, "Checking system property {0}", jaxbContextFQCN);
        factoryClassName = AccessController.doPrivileged(new GetPropertyAction(jaxbContextFQCN));
        if (factoryClassName != null) {
            logger.log(Level.FINE, "  found {0}", factoryClassName);
            return ContextFinder.newInstance(classes2, properties2, factoryClassName);
        }
        logger.fine("  not found");
        Class jaxbContext = ContextFinder.lookupJaxbContextUsingOsgiServiceLoader();
        if (jaxbContext != null) {
            logger.fine("OSGi environment detected");
            return ContextFinder.newInstance(classes2, properties2, jaxbContext);
        }
        logger.fine("Checking META-INF/services");
        BufferedReader r = null;
        try {
            String resource2 = "META-INF/services/" + jaxbContextFQCN;
            ClassLoader classLoader3 = ContextFinder.getContextClassLoader();
            URL resourceURL = classLoader3 == null ? ClassLoader.getSystemResource(resource2) : classLoader3.getResource(resource2);
            if (resourceURL != null) {
                logger.log(Level.FINE, "Reading {0}", resourceURL);
                r = new BufferedReader(new InputStreamReader(resourceURL.openStream(), "UTF-8"));
                factoryClassName = r.readLine();
                if (factoryClassName != null) {
                    factoryClassName = factoryClassName.trim();
                }
                JAXBContext jAXBContext = ContextFinder.newInstance(classes2, properties2, factoryClassName);
                return jAXBContext;
            }
            logger.log(Level.FINE, "Unable to find: {0}", resource2);
        }
        catch (UnsupportedEncodingException e) {
            throw new JAXBException(e);
        }
        catch (IOException e) {
            throw new JAXBException(e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ex) {
                    logger.log(Level.FINE, "Unable to close stream", ex);
                }
            }
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(classes2, properties2, PLATFORM_DEFAULT_FACTORY_CLASS);
    }

    private static Class lookupJaxbContextUsingOsgiServiceLoader() {
        try {
            Class<?> target = Class.forName("org.glassfish.hk2.osgiresourcelocator.ServiceLoader");
            Method m3 = target.getMethod("lookupProviderClasses", Class.class);
            Iterator iter = ((Iterable)m3.invoke(null, JAXBContext.class)).iterator();
            return iter.hasNext() ? (Class)iter.next() : null;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Unable to find from OSGi: javax.xml.bind.JAXBContext");
            return null;
        }
    }

    private static Properties loadJAXBProperties(ClassLoader classLoader2, String propFileName) throws JAXBException {
        Properties props = null;
        try {
            URL url2 = classLoader2 == null ? ClassLoader.getSystemResource(propFileName) : classLoader2.getResource(propFileName);
            if (url2 != null) {
                logger.log(Level.FINE, "loading props from {0}", url2);
                props = new Properties();
                InputStream is = url2.openStream();
                props.load(is);
                is.close();
            }
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Unable to load " + propFileName, ioe);
            throw new JAXBException(ioe.toString(), ioe);
        }
        return props;
    }

    static URL which(Class clazz, ClassLoader loader) {
        String classnameAsResource = clazz.getName().replace('.', '/') + ".class";
        if (loader == null) {
            loader = ContextFinder.getSystemClassLoader();
        }
        return loader.getResource(classnameAsResource);
    }

    static URL which(Class clazz) {
        return ContextFinder.which(clazz, ContextFinder.getClassClassLoader(clazz));
    }

    private static Class safeLoadClass(String className, ClassLoader classLoader2) throws ClassNotFoundException {
        logger.log(Level.FINE, "Trying to load {0}", className);
        try {
            int i;
            SecurityManager s2 = System.getSecurityManager();
            if (s2 != null && (i = className.lastIndexOf(46)) != -1) {
                s2.checkPackageAccess(className.substring(0, i));
            }
            if (classLoader2 == null) {
                return Class.forName(className);
            }
            return classLoader2.loadClass(className);
        }
        catch (SecurityException se) {
            if (PLATFORM_DEFAULT_FACTORY_CLASS.equals(className)) {
                return Class.forName(className);
            }
            throw se;
        }
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static ClassLoader getClassClassLoader(final Class c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return c.getClassLoader();
            }
        });
    }

    private static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static {
        try {
            if (AccessController.doPrivileged(new GetPropertyAction("jaxb.debug")) != null) {
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(Level.ALL);
                logger.addHandler(handler);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

