/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.InternalSerializationApi;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalSerializationApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b#\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001fJ\u001e\u0010 \u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\"J\u001e\u0010#\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\"J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010(\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020)J\u001e\u0010*\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020)J\u000e\u0010+\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001aJ\u001e\u0010,\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001aJ\u000e\u0010-\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020.J\u001e\u0010/\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020.J\u0006\u00100\u001a\u00020\u0015J\b\u00101\u001a\u00020\u0015H\u0016J=\u00102\u001a\u00020\u0015\"\b\b\u0001\u00103*\u0002042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\f\u00105\u001a\b\u0012\u0004\u0012\u0002H3062\b\u0010\u0016\u001a\u0004\u0018\u0001H3\u00a2\u0006\u0002\u00107J7\u00108\u001a\u00020\u0015\"\u0004\b\u0001\u001032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\f\u00105\u001a\b\u0012\u0004\u0012\u0002H3062\u0006\u0010\u0016\u001a\u0002H3\u00a2\u0006\u0002\u00107J\u000e\u00109\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020:J\u001e\u0010;\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020:J\u000e\u0010<\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020=J\u001e\u0010>\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020=J\u001d\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a2\u0006\u0002\u0010AJ\u001d\u0010B\u001a\u00020\u00152\u0006\u0010@\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u001cH\u0014\u00a2\u0006\u0002\u0010CJ\u001d\u0010D\u001a\u00020\u00152\u0006\u0010@\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u001fH\u0014\u00a2\u0006\u0002\u0010EJ\u001d\u0010F\u001a\u00020\u00152\u0006\u0010@\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\"H\u0014\u00a2\u0006\u0002\u0010GJ%\u0010H\u001a\u00020\u00152\u0006\u0010@\u001a\u00028\u00002\u0006\u0010'\u001a\u00020\u00132\u0006\u0010I\u001a\u00020\u001aH\u0014\u00a2\u0006\u0002\u0010JJ\u001d\u0010K\u001a\u00020\u00152\u0006\u0010@\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020)H\u0014\u00a2\u0006\u0002\u0010LJ\u001d\u0010M\u001a\u00020\u00152\u0006\u0010@\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u001aH\u0014\u00a2\u0006\u0002\u0010NJ\u001d\u0010O\u001a\u00020\u00152\u0006\u0010@\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020.H\u0014\u00a2\u0006\u0002\u0010PJ\u0015\u0010Q\u001a\u00020\u00152\u0006\u0010@\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010RJ\u001d\u0010S\u001a\u00020\u00152\u0006\u0010@\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020:H\u0014\u00a2\u0006\u0002\u0010TJ\u001d\u0010U\u001a\u00020\u00152\u0006\u0010@\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020=H\u0014\u00a2\u0006\u0002\u0010VJ\u001d\u0010W\u001a\u00020\u00152\u0006\u0010@\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u000204H\u0014\u00a2\u0006\u0002\u0010XJ\u0010\u0010Y\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u000e\u0010Z\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013J\r\u0010[\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\\\u001a\u00020\u00152\u0006\u0010]\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010RJ\u0019\u0010^\u001a\u00028\u0000*\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH$\u00a2\u0006\u0002\u0010_R\u0014\u0010\u0005\u001a\u00028\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00018\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000fj\b\u0012\u0004\u0012\u00028\u0000`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lkotlinx/serialization/internal/TaggedEncoder;", "Tag", "Lkotlinx/serialization/encoding/Encoder;", "Lkotlinx/serialization/encoding/CompositeEncoder;", "()V", "currentTag", "getCurrentTag", "()Ljava/lang/Object;", "currentTagOrNull", "getCurrentTagOrNull", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "tagStack", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "beginStructure", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encodeBoolean", "", "value", "", "encodeBooleanElement", "index", "", "encodeByte", "", "encodeByteElement", "encodeChar", "", "encodeCharElement", "encodeDouble", "", "encodeDoubleElement", "encodeElement", "desc", "encodeEnum", "enumDescriptor", "encodeFloat", "", "encodeFloatElement", "encodeInt", "encodeIntElement", "encodeLong", "", "encodeLongElement", "encodeNotNullMark", "encodeNull", "encodeNullableSerializableElement", "T", "", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeSerializableElement", "encodeShort", "", "encodeShortElement", "encodeString", "", "encodeStringElement", "encodeTaggedBoolean", "tag", "(Ljava/lang/Object;Z)V", "encodeTaggedByte", "(Ljava/lang/Object;B)V", "encodeTaggedChar", "(Ljava/lang/Object;C)V", "encodeTaggedDouble", "(Ljava/lang/Object;D)V", "encodeTaggedEnum", "ordinal", "(Ljava/lang/Object;Lkotlinx/serialization/descriptors/SerialDescriptor;I)V", "encodeTaggedFloat", "(Ljava/lang/Object;F)V", "encodeTaggedInt", "(Ljava/lang/Object;I)V", "encodeTaggedLong", "(Ljava/lang/Object;J)V", "encodeTaggedNull", "(Ljava/lang/Object;)V", "encodeTaggedShort", "(Ljava/lang/Object;S)V", "encodeTaggedString", "(Ljava/lang/Object;Ljava/lang/String;)V", "encodeTaggedValue", "(Ljava/lang/Object;Ljava/lang/Object;)V", "endEncode", "endStructure", "popTag", "pushTag", "name", "getTag", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Ljava/lang/Object;", "kotlinx-serialization-core"})
public abstract class TaggedEncoder<Tag>
implements Encoder,
CompositeEncoder {
    private final ArrayList<Tag> tagStack;

    protected abstract Tag getTag(@NotNull SerialDescriptor var1, int var2);

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return SerializersModuleKt.getEmptySerializersModule();
    }

    protected void encodeTaggedValue(Tag tag, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        throw (Throwable)new SerializationException("Non-serializable " + Reflection.getOrCreateKotlinClass(value2.getClass()) + " is not supported by " + Reflection.getOrCreateKotlinClass(this.getClass()) + " encoder");
    }

    protected void encodeTaggedNull(Tag tag) {
        throw (Throwable)new SerializationException("null is not supported");
    }

    protected void encodeTaggedInt(Tag tag, int value2) {
        this.encodeTaggedValue(tag, value2);
    }

    protected void encodeTaggedByte(Tag tag, byte value2) {
        this.encodeTaggedValue(tag, value2);
    }

    protected void encodeTaggedShort(Tag tag, short value2) {
        this.encodeTaggedValue(tag, value2);
    }

    protected void encodeTaggedLong(Tag tag, long value2) {
        this.encodeTaggedValue(tag, value2);
    }

    protected void encodeTaggedFloat(Tag tag, float value2) {
        this.encodeTaggedValue(tag, Float.valueOf(value2));
    }

    protected void encodeTaggedDouble(Tag tag, double value2) {
        this.encodeTaggedValue(tag, value2);
    }

    protected void encodeTaggedBoolean(Tag tag, boolean value2) {
        this.encodeTaggedValue(tag, value2);
    }

    protected void encodeTaggedChar(Tag tag, char value2) {
        this.encodeTaggedValue(tag, Character.valueOf(value2));
    }

    protected void encodeTaggedString(Tag tag, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.encodeTaggedValue(tag, value2);
    }

    protected void encodeTaggedEnum(Tag tag, @NotNull SerialDescriptor enumDescriptor, int ordinal) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        this.encodeTaggedValue(tag, ordinal);
    }

    private final boolean encodeElement(SerialDescriptor desc, int index) {
        Tag tag = this.getTag(desc, index);
        this.pushTag(tag);
        return true;
    }

    @Override
    public final void encodeNotNullMark() {
    }

    @Override
    public void encodeNull() {
        this.encodeTaggedNull(this.popTag());
    }

    @Override
    public final void encodeBoolean(boolean value2) {
        this.encodeTaggedBoolean(this.popTag(), value2);
    }

    @Override
    public final void encodeByte(byte value2) {
        this.encodeTaggedByte(this.popTag(), value2);
    }

    @Override
    public final void encodeShort(short value2) {
        this.encodeTaggedShort(this.popTag(), value2);
    }

    @Override
    public final void encodeInt(int value2) {
        this.encodeTaggedInt(this.popTag(), value2);
    }

    @Override
    public final void encodeLong(long value2) {
        this.encodeTaggedLong(this.popTag(), value2);
    }

    @Override
    public final void encodeFloat(float value2) {
        this.encodeTaggedFloat(this.popTag(), value2);
    }

    @Override
    public final void encodeDouble(double value2) {
        this.encodeTaggedDouble(this.popTag(), value2);
    }

    @Override
    public final void encodeChar(char value2) {
        this.encodeTaggedChar(this.popTag(), value2);
    }

    @Override
    public final void encodeString(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.encodeTaggedString(this.popTag(), value2);
    }

    @Override
    public final void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        this.encodeTaggedEnum(this.popTag(), enumDescriptor, index);
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return this;
    }

    @Override
    public final void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Collection collection = this.tagStack;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.popTag();
        }
        this.endEncode(descriptor2);
    }

    protected void endEncode(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
    }

    @Override
    public final void encodeBooleanElement(@NotNull SerialDescriptor descriptor2, int index, boolean value2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.encodeTaggedBoolean(this.getTag(descriptor2, index), value2);
    }

    @Override
    public final void encodeByteElement(@NotNull SerialDescriptor descriptor2, int index, byte value2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.encodeTaggedByte(this.getTag(descriptor2, index), value2);
    }

    @Override
    public final void encodeShortElement(@NotNull SerialDescriptor descriptor2, int index, short value2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.encodeTaggedShort(this.getTag(descriptor2, index), value2);
    }

    @Override
    public final void encodeIntElement(@NotNull SerialDescriptor descriptor2, int index, int value2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.encodeTaggedInt(this.getTag(descriptor2, index), value2);
    }

    @Override
    public final void encodeLongElement(@NotNull SerialDescriptor descriptor2, int index, long value2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.encodeTaggedLong(this.getTag(descriptor2, index), value2);
    }

    @Override
    public final void encodeFloatElement(@NotNull SerialDescriptor descriptor2, int index, float value2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.encodeTaggedFloat(this.getTag(descriptor2, index), value2);
    }

    @Override
    public final void encodeDoubleElement(@NotNull SerialDescriptor descriptor2, int index, double value2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.encodeTaggedDouble(this.getTag(descriptor2, index), value2);
    }

    @Override
    public final void encodeCharElement(@NotNull SerialDescriptor descriptor2, int index, char value2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.encodeTaggedChar(this.getTag(descriptor2, index), value2);
    }

    @Override
    public final void encodeStringElement(@NotNull SerialDescriptor descriptor2, int index, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.encodeTaggedString(this.getTag(descriptor2, index), value2);
    }

    @Override
    public final <T> void encodeSerializableElement(@NotNull SerialDescriptor descriptor2, int index, @NotNull SerializationStrategy<? super T> serializer, T value2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        if (this.encodeElement(descriptor2, index)) {
            this.encodeSerializableValue(serializer, value2);
        }
    }

    @Override
    public final <T> void encodeNullableSerializableElement(@NotNull SerialDescriptor descriptor2, int index, @NotNull SerializationStrategy<? super T> serializer, @Nullable T value2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        if (this.encodeElement(descriptor2, index)) {
            this.encodeNullableSerializableValue(serializer, value2);
        }
    }

    protected final Tag getCurrentTag() {
        return (Tag)CollectionsKt.last((List)this.tagStack);
    }

    @Nullable
    protected final Tag getCurrentTagOrNull() {
        return (Tag)CollectionsKt.lastOrNull((List)this.tagStack);
    }

    protected final void pushTag(Tag name) {
        this.tagStack.add(name);
    }

    protected final Tag popTag() {
        Collection collection = this.tagStack;
        boolean bl = false;
        if (!(!collection.isEmpty())) {
            throw (Throwable)new SerializationException("No tag in stack for requested element");
        }
        return this.tagStack.remove(CollectionsKt.getLastIndex((List)this.tagStack));
    }

    public TaggedEncoder() {
        boolean bl = false;
        this.tagStack = new ArrayList();
    }

    @Override
    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor2, int collectionSize) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return Encoder.DefaultImpls.beginCollection(this, descriptor2, collectionSize);
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value2) {
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        Encoder.DefaultImpls.encodeSerializableValue(this, serializer, value2);
    }

    @Override
    @ExperimentalSerializationApi
    public <T> void encodeNullableSerializableValue(@NotNull SerializationStrategy<? super T> serializer, @Nullable T value2) {
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        Encoder.DefaultImpls.encodeNullableSerializableValue(this, serializer, value2);
    }

    @Override
    @ExperimentalSerializationApi
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return CompositeEncoder.DefaultImpls.shouldEncodeElementDefault(this, descriptor2, index);
    }
}

