/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

class FelixClassLoaderHandler
implements ClassLoaderHandler {
    private FelixClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "org.apache.felix.framework.BundleWiringImpl$BundleClassLoaderJava5".equals(classLoaderClass.getName()) || "org.apache.felix.framework.BundleWiringImpl$BundleClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader2, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader2.getParent(), true, log);
        classLoaderOrder.add(classLoader2, log);
    }

    private static File getContentLocation(Object content) {
        return (File)ReflectionUtils.invokeMethod(content, "getFile", false);
    }

    private static void addBundle(Object bundleWiring, ClassLoader classLoader2, ClasspathOrder classpathOrderOut, Set<Object> bundles, ScanSpec scanSpec, LogNode log) {
        File location;
        bundles.add(bundleWiring);
        Object revision = ReflectionUtils.invokeMethod(bundleWiring, "getRevision", false);
        Object content = ReflectionUtils.invokeMethod(revision, "getContent", false);
        File file2 = location = content != null ? FelixClassLoaderHandler.getContentLocation(content) : null;
        if (location != null) {
            classpathOrderOut.addClasspathEntry((Object)location, classLoader2, scanSpec, log);
            List embeddedContent = (List)ReflectionUtils.invokeMethod(revision, "getContentPath", false);
            if (embeddedContent != null) {
                for (Object embedded : embeddedContent) {
                    File embeddedLocation;
                    if (embedded == content || (embeddedLocation = embedded != null ? FelixClassLoaderHandler.getContentLocation(embedded) : null) == null) continue;
                    classpathOrderOut.addClasspathEntry((Object)embeddedLocation, classLoader2, scanSpec, log);
                }
            }
        }
    }

    public static void findClasspathOrder(ClassLoader classLoader2, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        HashSet<Object> bundles = new HashSet<Object>();
        Object bundleWiring = ReflectionUtils.getFieldVal(classLoader2, "m_wiring", false);
        FelixClassLoaderHandler.addBundle(bundleWiring, classLoader2, classpathOrder, bundles, scanSpec, log);
        List requiredWires = (List)ReflectionUtils.invokeMethod(bundleWiring, "getRequiredWires", String.class, null, false);
        if (requiredWires != null) {
            for (Object wire : requiredWires) {
                Object provider = ReflectionUtils.invokeMethod(wire, "getProviderWiring", false);
                if (bundles.contains(provider)) continue;
                FelixClassLoaderHandler.addBundle(provider, classLoader2, classpathOrder, bundles, scanSpec, log);
            }
        }
    }
}

