/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EndianUtils {
    public static short swapShort(short value2) {
        return (short)(((value2 >> 0 & 0xFF) << 8) + ((value2 >> 8 & 0xFF) << 0));
    }

    public static int swapInteger(int value2) {
        return ((value2 >> 0 & 0xFF) << 24) + ((value2 >> 8 & 0xFF) << 16) + ((value2 >> 16 & 0xFF) << 8) + ((value2 >> 24 & 0xFF) << 0);
    }

    public static long swapLong(long value2) {
        return ((value2 >> 0 & 0xFFL) << 56) + ((value2 >> 8 & 0xFFL) << 48) + ((value2 >> 16 & 0xFFL) << 40) + ((value2 >> 24 & 0xFFL) << 32) + ((value2 >> 32 & 0xFFL) << 24) + ((value2 >> 40 & 0xFFL) << 16) + ((value2 >> 48 & 0xFFL) << 8) + ((value2 >> 56 & 0xFFL) << 0);
    }

    public static float swapFloat(float value2) {
        return Float.intBitsToFloat(EndianUtils.swapInteger(Float.floatToIntBits(value2)));
    }

    public static double swapDouble(double value2) {
        return Double.longBitsToDouble(EndianUtils.swapLong(Double.doubleToLongBits(value2)));
    }

    public static void writeSwappedShort(byte[] data2, int offset, short value2) {
        data2[offset + 0] = (byte)(value2 >> 0 & 0xFF);
        data2[offset + 1] = (byte)(value2 >> 8 & 0xFF);
    }

    public static short readSwappedShort(byte[] data2, int offset) {
        return (short)(((data2[offset + 0] & 0xFF) << 0) + ((data2[offset + 1] & 0xFF) << 8));
    }

    public static int readSwappedUnsignedShort(byte[] data2, int offset) {
        return ((data2[offset + 0] & 0xFF) << 0) + ((data2[offset + 1] & 0xFF) << 8);
    }

    public static void writeSwappedInteger(byte[] data2, int offset, int value2) {
        data2[offset + 0] = (byte)(value2 >> 0 & 0xFF);
        data2[offset + 1] = (byte)(value2 >> 8 & 0xFF);
        data2[offset + 2] = (byte)(value2 >> 16 & 0xFF);
        data2[offset + 3] = (byte)(value2 >> 24 & 0xFF);
    }

    public static int readSwappedInteger(byte[] data2, int offset) {
        return ((data2[offset + 0] & 0xFF) << 0) + ((data2[offset + 1] & 0xFF) << 8) + ((data2[offset + 2] & 0xFF) << 16) + ((data2[offset + 3] & 0xFF) << 24);
    }

    public static long readSwappedUnsignedInteger(byte[] data2, int offset) {
        long low = ((data2[offset + 0] & 0xFF) << 0) + ((data2[offset + 1] & 0xFF) << 8) + ((data2[offset + 2] & 0xFF) << 16);
        long high = data2[offset + 3] & 0xFF;
        return (high << 24) + (0xFFFFFFFFL & low);
    }

    public static void writeSwappedLong(byte[] data2, int offset, long value2) {
        data2[offset + 0] = (byte)(value2 >> 0 & 0xFFL);
        data2[offset + 1] = (byte)(value2 >> 8 & 0xFFL);
        data2[offset + 2] = (byte)(value2 >> 16 & 0xFFL);
        data2[offset + 3] = (byte)(value2 >> 24 & 0xFFL);
        data2[offset + 4] = (byte)(value2 >> 32 & 0xFFL);
        data2[offset + 5] = (byte)(value2 >> 40 & 0xFFL);
        data2[offset + 6] = (byte)(value2 >> 48 & 0xFFL);
        data2[offset + 7] = (byte)(value2 >> 56 & 0xFFL);
    }

    public static long readSwappedLong(byte[] data2, int offset) {
        long low = EndianUtils.readSwappedInteger(data2, offset);
        long high = EndianUtils.readSwappedInteger(data2, offset + 4);
        return (high << 32) + (0xFFFFFFFFL & low);
    }

    public static void writeSwappedFloat(byte[] data2, int offset, float value2) {
        EndianUtils.writeSwappedInteger(data2, offset, Float.floatToIntBits(value2));
    }

    public static float readSwappedFloat(byte[] data2, int offset) {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(data2, offset));
    }

    public static void writeSwappedDouble(byte[] data2, int offset, double value2) {
        EndianUtils.writeSwappedLong(data2, offset, Double.doubleToLongBits(value2));
    }

    public static double readSwappedDouble(byte[] data2, int offset) {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(data2, offset));
    }

    public static void writeSwappedShort(OutputStream output2, short value2) throws IOException {
        output2.write((byte)(value2 >> 0 & 0xFF));
        output2.write((byte)(value2 >> 8 & 0xFF));
    }

    public static short readSwappedShort(InputStream input) throws IOException {
        return (short)(((EndianUtils.read(input) & 0xFF) << 0) + ((EndianUtils.read(input) & 0xFF) << 8));
    }

    public static int readSwappedUnsignedShort(InputStream input) throws IOException {
        int value1 = EndianUtils.read(input);
        int value2 = EndianUtils.read(input);
        return ((value1 & 0xFF) << 0) + ((value2 & 0xFF) << 8);
    }

    public static void writeSwappedInteger(OutputStream output2, int value2) throws IOException {
        output2.write((byte)(value2 >> 0 & 0xFF));
        output2.write((byte)(value2 >> 8 & 0xFF));
        output2.write((byte)(value2 >> 16 & 0xFF));
        output2.write((byte)(value2 >> 24 & 0xFF));
    }

    public static int readSwappedInteger(InputStream input) throws IOException {
        int value1 = EndianUtils.read(input);
        int value2 = EndianUtils.read(input);
        int value3 = EndianUtils.read(input);
        int value4 = EndianUtils.read(input);
        return ((value1 & 0xFF) << 0) + ((value2 & 0xFF) << 8) + ((value3 & 0xFF) << 16) + ((value4 & 0xFF) << 24);
    }

    public static long readSwappedUnsignedInteger(InputStream input) throws IOException {
        int value1 = EndianUtils.read(input);
        int value2 = EndianUtils.read(input);
        int value3 = EndianUtils.read(input);
        int value4 = EndianUtils.read(input);
        long low = ((value1 & 0xFF) << 0) + ((value2 & 0xFF) << 8) + ((value3 & 0xFF) << 16);
        long high = value4 & 0xFF;
        return (high << 24) + (0xFFFFFFFFL & low);
    }

    public static void writeSwappedLong(OutputStream output2, long value2) throws IOException {
        output2.write((byte)(value2 >> 0 & 0xFFL));
        output2.write((byte)(value2 >> 8 & 0xFFL));
        output2.write((byte)(value2 >> 16 & 0xFFL));
        output2.write((byte)(value2 >> 24 & 0xFFL));
        output2.write((byte)(value2 >> 32 & 0xFFL));
        output2.write((byte)(value2 >> 40 & 0xFFL));
        output2.write((byte)(value2 >> 48 & 0xFFL));
        output2.write((byte)(value2 >> 56 & 0xFFL));
    }

    public static long readSwappedLong(InputStream input) throws IOException {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)EndianUtils.read(input);
        }
        return EndianUtils.readSwappedLong(bytes, 0);
    }

    public static void writeSwappedFloat(OutputStream output2, float value2) throws IOException {
        EndianUtils.writeSwappedInteger(output2, Float.floatToIntBits(value2));
    }

    public static float readSwappedFloat(InputStream input) throws IOException {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(input));
    }

    public static void writeSwappedDouble(OutputStream output2, double value2) throws IOException {
        EndianUtils.writeSwappedLong(output2, Double.doubleToLongBits(value2));
    }

    public static double readSwappedDouble(InputStream input) throws IOException {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(input));
    }

    private static int read(InputStream input) throws IOException {
        int value2 = input.read();
        if (-1 == value2) {
            throw new EOFException("Unexpected EOF reached");
        }
        return value2;
    }
}

