/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryContents;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class ContentsService
extends GitHubService {
    public ContentsService() {
    }

    public ContentsService(GitHubClient client2) {
        super(client2);
    }

    public RepositoryContents getReadme(IRepositoryIdProvider repository) throws Exception {
        return this.getReadme(repository, null);
    }

    public RepositoryContents getReadme(IRepositoryIdProvider repository, String ref) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/readme");
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        if (ref != null && ref.length() > 0) {
            request2.setParams(Collections.singletonMap("ref", ref));
        }
        request2.setType((Type)((Object)RepositoryContents.class));
        return (RepositoryContents)this.client.get(request2).getBody();
    }

    public List<RepositoryContents> getContents(IRepositoryIdProvider repository) throws IOException {
        return this.getContents(repository, null);
    }

    public List<RepositoryContents> getContents(IRepositoryIdProvider repository, String path) throws IOException {
        return this.getContents(repository, path, null);
    }

    public List<RepositoryContents> getContents(IRepositoryIdProvider repository, String path, String ref) throws IOException {
        Object body2;
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/contents");
        if (path != null && path.length() > 0) {
            if (path.charAt(0) != '/') {
                uri.append('/');
            }
            uri.append(path);
        }
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType((Type)((Object)RepositoryContents.class));
        request2.setArrayType(new TypeToken<List<RepositoryContents>>(){}.getType());
        if (ref != null && ref.length() > 0) {
            request2.setParams(Collections.singletonMap("ref", ref));
        }
        if ((body2 = this.client.get(request2).getBody()) instanceof RepositoryContents) {
            return Collections.singletonList((RepositoryContents)body2);
        }
        return (List)body2;
    }
}

