/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.github.core.Contributor;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.IResourceProvider;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryBranch;
import org.eclipse.egit.github.core.RepositoryHook;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.RepositoryMerging;
import org.eclipse.egit.github.core.RepositoryMergingResponse;
import org.eclipse.egit.github.core.RepositoryTag;
import org.eclipse.egit.github.core.SearchRepository;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class RepositoryService
extends GitHubService {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_HOMEPAGE = "homepage";
    public static final String FIELD_PUBLIC = "public";
    public static final String FILTER_TYPE = "type";
    public static final String TYPE_PUBLIC = "public";
    public static final String TYPE_PRIVATE = "private";
    public static final String TYPE_MEMBER = "member";
    public static final String TYPE_ALL = "all";

    public RepositoryService() {
    }

    public RepositoryService(GitHubClient client2) {
        super(client2);
    }

    public List<Repository> getRepositories() throws IOException {
        return this.getRepositories((Map<String, String>)null);
    }

    public List<Repository> getRepositories(Map<String, String> filterData) throws IOException {
        return this.getAll(this.pageRepositories(filterData));
    }

    public PageIterator<Repository> pageRepositories() {
        return this.pageRepositories(100);
    }

    public PageIterator<Repository> pageRepositories(int size2) {
        return this.pageRepositories(1, size2);
    }

    public PageIterator<Repository> pageRepositories(int start, int size2) {
        return this.pageRepositories((Map<String, String>)null, start, size2);
    }

    public PageIterator<Repository> pageRepositories(Map<String, String> filterData) {
        return this.pageRepositories(filterData, 100);
    }

    public PageIterator<Repository> pageRepositories(Map<String, String> filterData, int size2) {
        return this.pageRepositories(filterData, 1, size2);
    }

    public PageIterator<Repository> pageRepositories(Map<String, String> filterData, int start, int size2) {
        PagedRequest request2 = this.createPagedRequest(start, size2);
        request2.setUri("/user/repos");
        request2.setParams(filterData);
        request2.setType(new TypeToken<List<Repository>>(){}.getType());
        return this.createPageIterator(request2);
    }

    public PageIterator<Repository> pageAllRepositories() {
        return this.pageAllRepositories(-1L);
    }

    public PageIterator<Repository> pageAllRepositories(long since) {
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri("/repositories");
        if (since > 0L) {
            request2.setParams(Collections.singletonMap("since", Long.toString(since)));
        }
        request2.setType(new TypeToken<List<Repository>>(){}.getType());
        return this.createPageIterator(request2);
    }

    public List<Repository> getRepositories(String user2) throws IOException {
        return this.getAll(this.pageRepositories(user2));
    }

    public PageIterator<Repository> pageRepositories(String user2) {
        return this.pageRepositories(user2, 100);
    }

    public PageIterator<Repository> pageRepositories(String user2, int size2) {
        return this.pageRepositories(user2, 1, size2);
    }

    public PageIterator<Repository> pageRepositories(String user2, int start, int size2) {
        if (user2 == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user2.length() == 0) {
            throw new IllegalArgumentException("User cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/users");
        uri.append('/').append(user2);
        uri.append("/repos");
        PagedRequest request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri);
        request2.setType(new TypeToken<List<Repository>>(){}.getType());
        return this.createPageIterator(request2);
    }

    public List<Repository> getOrgRepositories(String organization) throws IOException {
        return this.getOrgRepositories(organization, null);
    }

    public PageIterator<Repository> pageOrgRepositories(String organization) {
        return this.pageOrgRepositories(organization, 100);
    }

    public PageIterator<Repository> pageOrgRepositories(String organization, int size2) {
        return this.pageOrgRepositories(organization, 1, size2);
    }

    public PageIterator<Repository> pageOrgRepositories(String organization, int start, int size2) {
        return this.pageOrgRepositories(organization, null, start, size2);
    }

    public List<Repository> getOrgRepositories(String organization, Map<String, String> filterData) throws IOException {
        return this.getAll(this.pageOrgRepositories(organization, filterData));
    }

    public PageIterator<Repository> pageOrgRepositories(String organization, Map<String, String> filterData) {
        return this.pageOrgRepositories(organization, filterData, 100);
    }

    public PageIterator<Repository> pageOrgRepositories(String organization, Map<String, String> filterData, int size2) {
        return this.pageOrgRepositories(organization, filterData, 1, size2);
    }

    public PageIterator<Repository> pageOrgRepositories(String organization, Map<String, String> filterData, int start, int size2) {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/repos");
        PagedRequest request2 = this.createPagedRequest(start, size2);
        request2.setParams(filterData);
        request2.setUri(uri);
        request2.setType(new TypeToken<List<Repository>>(){}.getType());
        return this.createPageIterator(request2);
    }

    public List<SearchRepository> searchRepositories(String query) throws IOException {
        return this.searchRepositories(query, -1);
    }

    public List<SearchRepository> searchRepositories(String query, int startPage) throws IOException {
        return this.searchRepositories(query, null, startPage);
    }

    public List<SearchRepository> searchRepositories(String query, String language) throws IOException {
        return this.searchRepositories(query, language, -1);
    }

    public List<SearchRepository> searchRepositories(String query, String language, int startPage) throws IOException {
        if (query == null) {
            throw new IllegalArgumentException("Query cannot be null");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("Query cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/legacy/repos/search");
        String encodedQuery = URLEncoder.encode(query, "UTF-8").replace("+", "%20").replace(".", "%2E");
        uri.append('/').append(encodedQuery);
        PagedRequest request2 = this.createPagedRequest();
        HashMap<String, String> params2 = new HashMap<String, String>(2, 1.0f);
        if (language != null && language.length() > 0) {
            params2.put("language", language);
        }
        if (startPage > 0) {
            params2.put("start_page", Integer.toString(startPage));
        }
        if (!params2.isEmpty()) {
            request2.setParams(params2);
        }
        request2.setUri(uri);
        request2.setType((Type)((Object)RepositoryContainer.class));
        return this.getAll(request2);
    }

    public List<SearchRepository> searchRepositories(Map<String, String> params2) throws IOException {
        return this.searchRepositories(params2, -1);
    }

    public List<SearchRepository> searchRepositories(Map<String, String> queryParams, int startPage) throws IOException {
        if (queryParams == null) {
            throw new IllegalArgumentException("Params cannot be null");
        }
        if (queryParams.isEmpty()) {
            throw new IllegalArgumentException("Params cannot be empty");
        }
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> param : queryParams.entrySet()) {
            query.append(param.getKey()).append(':').append(param.getValue()).append(' ');
        }
        return this.searchRepositories(query.toString(), startPage);
    }

    public Repository createRepository(Repository repository) throws IOException {
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        return (Repository)this.client.post("/user/repos", repository, (Type)((Object)Repository.class));
    }

    public Repository createRepository(String organization, Repository repository) throws IOException {
        if (organization == null) {
            throw new IllegalArgumentException("Organization cannot be null");
        }
        if (organization.length() == 0) {
            throw new IllegalArgumentException("Organization cannot be empty");
        }
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        StringBuilder uri = new StringBuilder("/orgs");
        uri.append('/').append(organization);
        uri.append("/repos");
        return (Repository)this.client.post(uri.toString(), repository, (Type)((Object)Repository.class));
    }

    public Repository getRepository(String owner, String name) throws IOException {
        return this.getRepository(RepositoryId.create(owner, name));
    }

    public Repository getRepository(IRepositoryIdProvider provider) throws IOException {
        String id2 = this.getId(provider);
        GitHubRequest request2 = this.createRequest();
        request2.setUri("/repos/" + id2);
        request2.setType((Type)((Object)Repository.class));
        return (Repository)this.client.get(request2).getBody();
    }

    protected PagedRequest<Repository> createPagedForkRequest(IRepositoryIdProvider repository, int start, int size2) {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/forks");
        PagedRequest<Repository> request2 = this.createPagedRequest(start, size2);
        request2.setUri(uri);
        request2.setType(new TypeToken<List<Repository>>(){}.getType());
        return request2;
    }

    public List<Repository> getForks(IRepositoryIdProvider repository) throws IOException {
        return this.getAll(this.pageForks(repository));
    }

    public PageIterator<Repository> pageForks(IRepositoryIdProvider repository) {
        return this.pageForks(repository, 100);
    }

    public PageIterator<Repository> pageForks(IRepositoryIdProvider repository, int size2) {
        return this.pageForks(repository, 1, size2);
    }

    public PageIterator<Repository> pageForks(IRepositoryIdProvider repository, int start, int size2) {
        PagedRequest<Repository> request2 = this.createPagedForkRequest(repository, start, size2);
        return this.createPageIterator(request2);
    }

    public Repository editRepository(Repository repository) throws IOException {
        if (repository == null) {
            throw new IllegalArgumentException("Repository cannot be null");
        }
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        return (Repository)this.client.post(uri.toString(), repository, (Type)((Object)Repository.class));
    }

    public Repository editRepository(String owner, String name, Map<String, Object> fields2) throws IOException {
        this.verifyRepository(owner, name);
        if (fields2 == null) {
            throw new IllegalArgumentException("Fields cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(owner).append('/').append(name);
        return (Repository)this.client.post(uri.toString(), fields2, (Type)((Object)Repository.class));
    }

    public Repository editRepository(IRepositoryIdProvider provider, Map<String, Object> fields2) throws IOException {
        String id2 = this.getId(provider);
        if (fields2 == null) {
            throw new IllegalArgumentException("Fields cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        return (Repository)this.client.post(uri.toString(), fields2, (Type)((Object)Repository.class));
    }

    public Repository forkRepository(IRepositoryIdProvider repository) throws IOException {
        return this.forkRepository(repository, null);
    }

    public Repository forkRepository(IRepositoryIdProvider repository, String organization) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/forks");
        if (organization != null) {
            uri.append("?org=").append(organization);
        }
        return (Repository)this.client.post(uri.toString(), null, (Type)((Object)Repository.class));
    }

    public void deleteRepository(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        this.client.delete(uri.toString());
    }

    public Map<String, Long> getLanguages(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/languages");
        GitHubRequest request2 = this.createRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<Map<String, Long>>(){}.getType());
        return (Map)this.client.get(request2).getBody();
    }

    public List<RepositoryBranch> getBranches(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/branches");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<RepositoryBranch>>(){}.getType());
        return this.getAll(request2);
    }

    public List<RepositoryTag> getTags(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/tags");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<RepositoryTag>>(){}.getType());
        return this.getAll(request2);
    }

    public List<Contributor> getContributors(IRepositoryIdProvider repository, boolean includeAnonymous) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/contributors");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        if (includeAnonymous) {
            request2.setParams(Collections.singletonMap("anon", "1"));
        }
        request2.setType(new TypeToken<List<Contributor>>(){}.getType());
        return this.getAll(request2);
    }

    public List<RepositoryHook> getHooks(IRepositoryIdProvider repository) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/hooks");
        PagedRequest request2 = this.createPagedRequest();
        request2.setUri(uri);
        request2.setType(new TypeToken<List<RepositoryHook>>(){}.getType());
        return this.getAll(request2);
    }

    public RepositoryHook getHook(IRepositoryIdProvider repository, long hookId) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/hooks");
        uri.append('/').append(hookId);
        GitHubRequest request2 = this.createRequest();
        request2.setType((Type)((Object)RepositoryHook.class));
        request2.setUri(uri);
        return (RepositoryHook)this.client.get(request2).getBody();
    }

    public RepositoryHook createHook(IRepositoryIdProvider repository, RepositoryHook hook) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/hooks");
        return (RepositoryHook)this.client.post(uri.toString(), hook, (Type)((Object)RepositoryHook.class));
    }

    public RepositoryHook editHook(IRepositoryIdProvider repository, RepositoryHook hook) throws IOException {
        String id2 = this.getId(repository);
        if (hook == null) {
            throw new IllegalArgumentException("Hook cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/hooks");
        uri.append('/').append(hook.getId());
        return (RepositoryHook)this.client.post(uri.toString(), hook, (Type)((Object)RepositoryHook.class));
    }

    public void deleteHook(IRepositoryIdProvider repository, long hookId) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/hooks");
        uri.append('/').append(hookId);
        this.client.delete(uri.toString());
    }

    public void testHook(IRepositoryIdProvider repository, long hookId) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/hooks");
        uri.append('/').append(hookId);
        uri.append("/tests");
        this.client.post(uri.toString());
    }

    public RepositoryMergingResponse mergingBranches(IRepositoryIdProvider repository, RepositoryMerging merging) throws IOException {
        String id2 = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id2);
        uri.append("/merges");
        RepositoryMergingResponse result2 = (RepositoryMergingResponse)this.client.post(uri.toString(), merging, (Type)((Object)RepositoryMergingResponse.class));
        if (result2 != null && result2.getCommit() != null && result2.getCommit().getSha() == null) {
            result2.getCommit().setSha(result2.getSha());
        }
        return result2;
    }

    private static class RepositoryContainer
    implements IResourceProvider<SearchRepository> {
        private List<SearchRepository> repositories;

        private RepositoryContainer() {
        }

        @Override
        public List<SearchRepository> getResources() {
            return this.repositories;
        }
    }
}

