/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import org.eclipse.egit.github.core.IRepositoryIdProvider;

public final class UrlUtils {
    private UrlUtils() {
    }

    public static String createRemoteSshUrl(IRepositoryIdProvider repository) {
        return UrlUtils.createRemoteSshUrl(repository, "github.com");
    }

    public static String createRemoteSshUrl(IRepositoryIdProvider repository, String host) {
        return "git@" + host + ":" + repository.generateId() + ".git";
    }

    public static String createRemoteHttpsUrl(IRepositoryIdProvider repository, String user2) {
        return UrlUtils.createRemoteHttpsUrl(repository, "github.com", user2);
    }

    public static String createRemoteHttpsUrl(IRepositoryIdProvider repository, String host, String user2) {
        return "https://" + user2 + "@" + host + "/" + repository.generateId() + ".git";
    }

    public static String createRemoteReadOnlyUrl(IRepositoryIdProvider repository) {
        return UrlUtils.createRemoteReadOnlyUrl(repository, "github.com");
    }

    public static String createRemoteReadOnlyUrl(IRepositoryIdProvider repository, String host) {
        return "git://" + host + "/" + repository.generateId() + ".git";
    }

    public static String encode(String value2) {
        try {
            return URLEncoder.encode(value2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String decode(String value2) {
        try {
            return URLDecoder.decode(value2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void addParam(String name, String value2, StringBuilder uri) {
        if (uri.length() > 0) {
            uri.append('&');
        }
        uri.append(UrlUtils.encode(name)).append('=');
        if (value2 != null) {
            uri.append(UrlUtils.encode(value2));
        }
    }

    public static void addParams(Map<String, String> params2, StringBuilder uri) {
        if (params2 == null || params2.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> param : params2.entrySet()) {
            UrlUtils.addParam(param.getKey(), param.getValue(), uri);
        }
    }

    public static String getParam(URI uri, String name) {
        String[] params2;
        String query = uri.getRawQuery();
        if (query == null || query.length() == 0) {
            return null;
        }
        String[] stringArray = params2 = query.split("&");
        int n = params2.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] parts = param.split("=");
            if (parts.length == 2 && name.equals(parts[0])) {
                return UrlUtils.decode(parts[1]);
            }
            ++n2;
        }
        return null;
    }
}

