/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public class AddNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String message;
    private String notesRef = "refs/notes/commits";

    protected AddNoteCommand(Repository repo) {
        super(repo);
    }

    /*
     * Loose catch block
     */
    @Override
    public Note call() throws GitAPIException {
        this.checkCallable();
        NoteMap map3 = NoteMap.newEmptyMap();
        RevCommit notesCommit = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Note note;
                ObjectInserter inserter;
                RevWalk walk;
                block19: {
                    walk = new RevWalk(this.repo);
                    inserter = this.repo.newObjectInserter();
                    Ref ref = this.repo.findRef(this.notesRef);
                    if (ref != null) {
                        notesCommit = walk.parseCommit(ref.getObjectId());
                        map3 = NoteMap.read(walk.getObjectReader(), notesCommit);
                    }
                    map3.set(this.id, this.message, inserter);
                    AddNoteCommand.commitNoteMap(this.repo, this.notesRef, walk, map3, notesCommit, inserter, "Notes added by 'git notes add'");
                    note = map3.getNote(this.id);
                    if (inserter != null) {
                        inserter.close();
                    }
                    if (walk == null) break block19;
                    walk.close();
                }
                return note;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (inserter != null) {
                                inserter.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (walk != null) {
                                walk.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public AddNoteCommand setObjectId(RevObject id2) {
        this.checkCallable();
        this.id = id2;
        return this;
    }

    public AddNoteCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    static void commitNoteMap(Repository r, String ref, RevWalk walk, NoteMap map3, RevCommit notesCommit, ObjectInserter inserter, String msg) throws IOException {
        CommitBuilder builder = new CommitBuilder();
        builder.setTreeId(map3.writeTree(inserter));
        builder.setAuthor(new PersonIdent(r));
        builder.setCommitter(builder.getAuthor());
        builder.setMessage(msg);
        if (notesCommit != null) {
            builder.setParentIds(notesCommit);
        }
        ObjectId commit = inserter.insert(builder);
        inserter.flush();
        RefUpdate refUpdate = r.updateRef(ref);
        if (notesCommit != null) {
            refUpdate.setExpectedOldObjectId(notesCommit);
        } else {
            refUpdate.setExpectedOldObjectId(ObjectId.zeroId());
        }
        refUpdate.setNewObjectId(commit);
        refUpdate.update(walk);
    }

    public AddNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

