/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import org.eclipse.jgit.api.AddNoteCommand;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public class RemoveNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String notesRef = "refs/notes/commits";

    protected RemoveNoteCommand(Repository repo) {
        super(repo);
    }

    /*
     * Loose catch block
     */
    @Override
    public Note call() throws GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                Note note;
                ObjectInserter inserter;
                RevWalk walk;
                block19: {
                    walk = new RevWalk(this.repo);
                    inserter = this.repo.newObjectInserter();
                    NoteMap map3 = NoteMap.newEmptyMap();
                    RevCommit notesCommit = null;
                    Ref ref = this.repo.exactRef(this.notesRef);
                    if (ref != null) {
                        notesCommit = walk.parseCommit(ref.getObjectId());
                        map3 = NoteMap.read(walk.getObjectReader(), notesCommit);
                    }
                    map3.set(this.id, null, inserter);
                    AddNoteCommand.commitNoteMap(this.repo, this.notesRef, walk, map3, notesCommit, inserter, "Notes removed by 'git notes remove'");
                    note = map3.getNote(this.id);
                    if (inserter != null) {
                        inserter.close();
                    }
                    if (walk == null) break block19;
                    walk.close();
                }
                return note;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (inserter != null) {
                                inserter.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (walk != null) {
                                walk.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public RemoveNoteCommand setObjectId(RevObject id2) {
        this.checkCallable();
        this.id = id2;
        return this;
    }

    public RemoveNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

