/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.ketch;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jgit.internal.ketch.KetchConstants;
import org.eclipse.jgit.internal.ketch.KetchLeader;
import org.eclipse.jgit.internal.ketch.LogIndex;
import org.eclipse.jgit.internal.ketch.Round;
import org.eclipse.jgit.internal.ketch.TimeIsUncertainException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.time.ProposedTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ElectionRound
extends Round {
    private static final Logger log = LoggerFactory.getLogger(ElectionRound.class);
    private long term;

    ElectionRound(KetchLeader leader, LogIndex head) {
        super(leader, head);
    }

    @Override
    void start() throws IOException {
        ObjectId id2;
        Throwable throwable = null;
        Object var3_3 = null;
        try {
            Repository git2 = this.leader.openRepository();
            try {
                ProposedTimestamp ts = this.getSystem().getClock().propose();
                try {
                    try (ObjectInserter inserter = git2.newObjectInserter();){
                        id2 = this.bumpTerm(git2, ts, inserter);
                        inserter.flush();
                        this.blockUntil(ts);
                    }
                    if (ts != null) {
                        ts.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (ts != null) {
                        ts.close();
                    }
                    throw throwable;
                }
                if (git2 != null) {
                    git2.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (git2 != null) {
                    git2.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.runAsync(id2);
    }

    @Override
    void success() {
    }

    long getTerm() {
        return this.term;
    }

    private ObjectId bumpTerm(Repository git2, ProposedTimestamp ts, ObjectInserter inserter) throws IOException {
        CommitBuilder b;
        block13: {
            b = new CommitBuilder();
            if (!ObjectId.zeroId().equals(this.acceptedOldIndex)) {
                Throwable throwable = null;
                Object var6_7 = null;
                try (RevWalk rw = new RevWalk(git2);){
                    RevCommit c = rw.parseCommit(this.acceptedOldIndex);
                    if (this.getSystem().requireMonotonicLeaderElections() && ts.read(TimeUnit.SECONDS) < (long)c.getCommitTime()) {
                        throw new TimeIsUncertainException();
                    }
                    b.setTreeId(c.getTree());
                    b.setParentId(this.acceptedOldIndex);
                    this.term = ElectionRound.parseTerm(c.getFooterLines(KetchConstants.TERM)) + 1L;
                    break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.term = 1L;
            b.setTreeId(inserter.insert(new TreeFormatter()));
        }
        StringBuilder msg = new StringBuilder();
        msg.append(KetchConstants.TERM.getName()).append(": ").append(this.term);
        String tag = this.leader.getSystem().newLeaderTag();
        if (tag != null && !tag.isEmpty()) {
            msg.append(' ').append(tag);
        }
        b.setAuthor(this.leader.getSystem().newCommitter(ts));
        b.setCommitter(b.getAuthor());
        b.setMessage(msg.toString());
        if (log.isDebugEnabled()) {
            log.debug("Trying to elect myself " + b.getMessage());
        }
        return inserter.insert(b);
    }

    private static long parseTerm(List<String> footer) {
        if (footer.isEmpty()) {
            return 0L;
        }
        String s2 = footer.get(0);
        int p = s2.indexOf(32);
        if (p > 0) {
            s2 = s2.substring(0, p);
        }
        return Long.parseLong(s2, 10);
    }

    private void blockUntil(ProposedTimestamp ts) throws IOException {
        try {
            ts.blockUntil(this.getSystem().getMaxWaitForMonotonicClock());
        }
        catch (InterruptedException | TimeoutException e) {
            throw new TimeIsUncertainException(e);
        }
    }
}

