/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.ketch;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.ketch.KetchReplica;
import org.eclipse.jgit.internal.ketch.ReplicaFetchRequest;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

class LagCheck
implements AutoCloseable {
    private final KetchReplica replica;
    private final Repository repo;
    private RevWalk rw;
    private ObjectId remoteId;

    LagCheck(KetchReplica replica, Repository repo) {
        this.replica = replica;
        this.repo = repo;
        this.initRevWalk();
    }

    private void initRevWalk() {
        if (this.rw != null) {
            this.rw.close();
        }
        this.rw = new RevWalk(this.repo);
        this.rw.setRetainBody(false);
    }

    @Override
    public void close() {
        if (this.rw != null) {
            this.rw.close();
            this.rw = null;
        }
    }

    ObjectId getRemoteId() {
        return this.remoteId;
    }

    KetchReplica.State check(ObjectId acceptId, ReceiveCommand acceptCmd) {
        this.remoteId = acceptId;
        if (this.remoteId == null) {
            return KetchReplica.State.UNKNOWN;
        }
        if (AnyObjectId.isEqual(this.remoteId, ObjectId.zeroId())) {
            return KetchReplica.State.LAGGING;
        }
        try {
            RevCommit remote;
            try {
                remote = this.parseRemoteCommit(acceptCmd.getRefName());
            }
            catch (RefGoneException gone) {
                return KetchReplica.State.LAGGING;
            }
            catch (MissingObjectException notFound) {
                return KetchReplica.State.DIVERGENT;
            }
            RevCommit head = this.rw.parseCommit(acceptCmd.getNewId());
            if (this.rw.isMergedInto(remote, head)) {
                return KetchReplica.State.LAGGING;
            }
            if (this.rw.isMergedInto(head, remote)) {
                return KetchReplica.State.AHEAD;
            }
            return KetchReplica.State.DIVERGENT;
        }
        catch (IOException err) {
            KetchReplica.log.error(String.format("Cannot compare %s", acceptCmd.getRefName()), err);
            return KetchReplica.State.UNKNOWN;
        }
    }

    private RevCommit parseRemoteCommit(String refName) throws IOException, MissingObjectException, RefGoneException {
        try {
            return this.rw.parseCommit(this.remoteId);
        }
        catch (MissingObjectException missingObjectException) {
            ReplicaFetchRequest fetch = new ReplicaFetchRequest(Collections.singleton(refName), Collections.emptySet());
            try {
                this.replica.blockingFetch(this.repo, fetch);
            }
            catch (IOException fetchErr) {
                KetchReplica.log.error(String.format("Cannot fetch %s (%s) from %s", this.remoteId.abbreviate(8).name(), refName, this.replica.describeForLog()), fetchErr);
                throw new MissingObjectException(this.remoteId, 1);
            }
            Map<String, Ref> adv = fetch.getRefs();
            if (adv == null) {
                throw new MissingObjectException(this.remoteId, 1);
            }
            Ref ref = adv.get(refName);
            if (ref == null || ref.getObjectId() == null) {
                throw new RefGoneException();
            }
            this.initRevWalk();
            this.remoteId = ref.getObjectId();
            return this.rw.parseCommit(this.remoteId);
        }
    }

    private static class RefGoneException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private RefGoneException() {
        }
    }
}

