/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;

public abstract class RefDatabase {
    protected static final String[] SEARCH_PATH = new String[]{"", "refs/", "refs/tags/", "refs/heads/", "refs/remotes/"};
    public static final int MAX_SYMBOLIC_REF_DEPTH = 5;
    public static final String ALL = "";

    public abstract void create() throws IOException;

    public abstract void close();

    public boolean hasVersioning() {
        return false;
    }

    public abstract boolean isNameConflicting(String var1) throws IOException;

    @NonNull
    public Collection<String> getConflictingNames(String name) throws IOException {
        Map<String, Ref> allRefs = this.getRefs(ALL);
        int lastSlash = name.lastIndexOf(47);
        while (lastSlash > 0) {
            String needle = name.substring(0, lastSlash);
            if (allRefs.containsKey(needle)) {
                return Collections.singletonList(needle);
            }
            lastSlash = name.lastIndexOf(47, lastSlash - 1);
        }
        ArrayList<String> conflicting = new ArrayList<String>();
        String prefix2 = String.valueOf(name) + '/';
        for (String existing : allRefs.keySet()) {
            if (!existing.startsWith(prefix2)) continue;
            conflicting.add(existing);
        }
        return conflicting;
    }

    @NonNull
    public abstract RefUpdate newUpdate(String var1, boolean var2) throws IOException;

    @NonNull
    public abstract RefRename newRename(String var1, String var2) throws IOException;

    @NonNull
    public BatchRefUpdate newBatchUpdate() {
        return new BatchRefUpdate(this);
    }

    public boolean performsAtomicTransactions() {
        return false;
    }

    @Deprecated
    @Nullable
    public final Ref getRef(String name) throws IOException {
        return this.findRef(name);
    }

    @Nullable
    public final Ref findRef(String name) throws IOException {
        String[] names = new String[SEARCH_PATH.length];
        int i = 0;
        while (i < SEARCH_PATH.length) {
            names[i] = String.valueOf(SEARCH_PATH[i]) + name;
            ++i;
        }
        return this.firstExactRef(names);
    }

    @Nullable
    public abstract Ref exactRef(String var1) throws IOException;

    @NonNull
    public Map<String, Ref> exactRef(String ... refs) throws IOException {
        HashMap<String, Ref> result2 = new HashMap<String, Ref>(refs.length);
        String[] stringArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Ref ref = this.exactRef(name);
            if (ref != null) {
                result2.put(name, ref);
            }
            ++n2;
        }
        return result2;
    }

    @Nullable
    public Ref firstExactRef(String ... refs) throws IOException {
        String[] stringArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Ref ref = this.exactRef(name);
            if (ref != null) {
                return ref;
            }
            ++n2;
        }
        return null;
    }

    @NonNull
    public List<Ref> getRefs() throws IOException {
        return this.getRefsByPrefix(ALL);
    }

    @Deprecated
    @NonNull
    public abstract Map<String, Ref> getRefs(String var1) throws IOException;

    @NonNull
    public List<Ref> getRefsByPrefix(String prefix2) throws IOException {
        List result2;
        int lastSlash = prefix2.lastIndexOf(47);
        Map<String, Ref> coarseRefs = lastSlash == -1 ? this.getRefs(ALL) : this.getRefs(prefix2.substring(0, lastSlash + 1));
        if (lastSlash + 1 == prefix2.length()) {
            result2 = coarseRefs.values().stream().collect(Collectors.toList());
        } else {
            String p = prefix2.substring(lastSlash + 1);
            result2 = coarseRefs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(p)).map(e -> (Ref)e.getValue()).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(result2);
    }

    @NonNull
    public List<Ref> getRefsByPrefix(String ... prefixes) throws IOException {
        ArrayList<Ref> result2 = new ArrayList<Ref>();
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix2 = stringArray[n2];
            result2.addAll(this.getRefsByPrefix(prefix2));
            ++n2;
        }
        return Collections.unmodifiableList(result2);
    }

    @NonNull
    public Set<Ref> getTipsWithSha1(ObjectId id2) throws IOException {
        return this.getRefs().stream().filter(r -> id2.equals(r.getObjectId()) || id2.equals(r.getPeeledObjectId())).collect(Collectors.toSet());
    }

    public boolean hasFastTipsWithSha1() throws IOException {
        return false;
    }

    public boolean hasRefs() throws IOException {
        return !this.getRefs().isEmpty();
    }

    @NonNull
    public abstract List<Ref> getAdditionalRefs() throws IOException;

    @NonNull
    public abstract Ref peel(Ref var1) throws IOException;

    public void refresh() {
    }

    @Nullable
    public static Ref findRef(Map<String, Ref> map3, String name) {
        String[] stringArray = SEARCH_PATH;
        int n = SEARCH_PATH.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix2 = stringArray[n2];
            String fullname = String.valueOf(prefix2) + name;
            Ref ref = map3.get(fullname);
            if (ref != null) {
                return ref;
            }
            ++n2;
        }
        return null;
    }
}

