/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.IndexWriteException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeAlgorithm;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.submodule.SubmoduleConflict;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;

public class ResolveMerger
extends ThreeWayMerger {
    protected NameConflictTreeWalk tw;
    protected String[] commitNames;
    protected static final int T_BASE = 0;
    protected static final int T_OURS = 1;
    protected static final int T_THEIRS = 2;
    protected static final int T_INDEX = 3;
    protected static final int T_FILE = 4;
    protected DirCacheBuilder builder;
    protected ObjectId resultTree;
    protected List<String> unmergedPaths = new ArrayList<String>();
    protected List<String> modifiedFiles = new LinkedList<String>();
    protected Map<String, DirCacheEntry> toBeCheckedOut = new HashMap<String, DirCacheEntry>();
    protected List<String> toBeDeleted = new ArrayList<String>();
    protected Map<String, MergeResult<? extends Sequence>> mergeResults = new HashMap<String, MergeResult<? extends Sequence>>();
    protected Map<String, MergeFailureReason> failingPaths = new HashMap<String, MergeFailureReason>();
    protected boolean enterSubtree;
    protected boolean inCore;
    protected boolean implicitDirCache;
    protected DirCache dircache;
    protected WorkingTreeIterator workingTreeIterator;
    protected MergeAlgorithm mergeAlgorithm;
    protected WorkingTreeOptions workingTreeOptions;
    private int inCoreLimit;
    private Map<String, DirCacheCheckout.CheckoutMetadata> checkoutMetadata;
    private static final Attributes NO_ATTRIBUTES = new Attributes(new Attribute[0]);

    private static MergeAlgorithm getMergeAlgorithm(Config config) {
        DiffAlgorithm.SupportedAlgorithm diffAlg = config.getEnum("diff", null, "algorithm", DiffAlgorithm.SupportedAlgorithm.HISTOGRAM);
        return new MergeAlgorithm(DiffAlgorithm.getAlgorithm(diffAlg));
    }

    private static int getInCoreLimit(Config config) {
        return config.getInt("merge", "inCoreLimit", 0xA00000);
    }

    private static String[] defaultCommitNames() {
        return new String[]{"BASE", "OURS", "THEIRS"};
    }

    protected ResolveMerger(Repository local2, boolean inCore) {
        super(local2);
        StoredConfig config = local2.getConfig();
        this.mergeAlgorithm = ResolveMerger.getMergeAlgorithm(config);
        this.inCoreLimit = ResolveMerger.getInCoreLimit(config);
        this.commitNames = ResolveMerger.defaultCommitNames();
        this.inCore = inCore;
        if (inCore) {
            this.implicitDirCache = false;
            this.dircache = DirCache.newInCore();
        } else {
            this.implicitDirCache = true;
            this.workingTreeOptions = local2.getConfig().get(WorkingTreeOptions.KEY);
        }
    }

    protected ResolveMerger(Repository local2) {
        this(local2, false);
    }

    protected ResolveMerger(ObjectInserter inserter, Config config) {
        super(inserter);
        this.mergeAlgorithm = ResolveMerger.getMergeAlgorithm(config);
        this.commitNames = ResolveMerger.defaultCommitNames();
        this.inCore = true;
        this.implicitDirCache = false;
        this.dircache = DirCache.newInCore();
    }

    @Override
    protected boolean mergeImpl() throws IOException {
        if (this.implicitDirCache) {
            this.dircache = this.nonNullRepo().lockDirCache();
        }
        if (!this.inCore) {
            this.checkoutMetadata = new HashMap<String, DirCacheCheckout.CheckoutMetadata>();
        }
        try {
            boolean bl = this.mergeTrees(this.mergeBase(), this.sourceTrees[0], this.sourceTrees[1], false);
            return bl;
        }
        finally {
            this.checkoutMetadata = null;
            if (this.implicitDirCache) {
                this.dircache.unlock();
            }
        }
    }

    private void checkout() throws NoWorkTreeException, IOException {
        int i = this.toBeDeleted.size() - 1;
        while (i >= 0) {
            String fileName = this.toBeDeleted.get(i);
            File f = new File(this.nonNullRepo().getWorkTree(), fileName);
            if (!f.delete() && !f.isDirectory()) {
                this.failingPaths.put(fileName, MergeFailureReason.COULD_NOT_DELETE);
            }
            this.modifiedFiles.add(fileName);
            --i;
        }
        for (Map.Entry<String, DirCacheEntry> entry : this.toBeCheckedOut.entrySet()) {
            DirCacheEntry cacheEntry = entry.getValue();
            if (cacheEntry.getFileMode() == FileMode.GITLINK) {
                new File(this.nonNullRepo().getWorkTree(), entry.getKey()).mkdirs();
                continue;
            }
            DirCacheCheckout.checkoutEntry(this.db, cacheEntry, this.reader, false, this.checkoutMetadata.get(entry.getKey()));
            this.modifiedFiles.add(entry.getKey());
        }
    }

    protected void cleanUp() throws NoWorkTreeException, CorruptObjectException, IOException {
        if (this.inCore) {
            this.modifiedFiles.clear();
            return;
        }
        DirCache dc = this.nonNullRepo().readDirCache();
        Iterator<String> mpathsIt = this.modifiedFiles.iterator();
        while (mpathsIt.hasNext()) {
            String mpath = mpathsIt.next();
            DirCacheEntry entry = dc.getEntry(mpath);
            if (entry != null) {
                DirCacheCheckout.checkoutEntry(this.db, entry, this.reader, false, this.checkoutMetadata.get(mpath));
            }
            mpathsIt.remove();
        }
    }

    private DirCacheEntry add(byte[] path, CanonicalTreeParser p, int stage, Instant lastMod, long len) {
        if (p != null && !p.getEntryFileMode().equals(FileMode.TREE)) {
            DirCacheEntry e = new DirCacheEntry(path, stage);
            e.setFileMode(p.getEntryFileMode());
            e.setObjectId(p.getEntryObjectId());
            e.setLastModified(lastMod);
            e.setLength(len);
            this.builder.add(e);
            return e;
        }
        return null;
    }

    private DirCacheEntry keep(DirCacheEntry e) {
        DirCacheEntry newEntry = new DirCacheEntry(e.getRawPath(), e.getStage());
        newEntry.setFileMode(e.getFileMode());
        newEntry.setObjectId(e.getObjectId());
        newEntry.setLastModified(e.getLastModifiedInstant());
        newEntry.setLength(e.getLength());
        this.builder.add(newEntry);
        return newEntry;
    }

    protected void addCheckoutMetadata(String path, Attributes attributes) throws IOException {
        if (this.checkoutMetadata != null) {
            CoreConfig.EolStreamType eol = EolStreamTypeUtil.detectStreamType(TreeWalk.OperationType.CHECKOUT_OP, this.workingTreeOptions, attributes);
            DirCacheCheckout.CheckoutMetadata data2 = new DirCacheCheckout.CheckoutMetadata(eol, this.tw.getFilterCommand("smudge"));
            this.checkoutMetadata.put(path, data2);
        }
    }

    protected void addToCheckout(String path, DirCacheEntry entry, Attributes attributes) throws IOException {
        this.toBeCheckedOut.put(path, entry);
        this.addCheckoutMetadata(path, attributes);
    }

    protected void addDeletion(String path, boolean isFile, Attributes attributes) throws IOException {
        this.toBeDeleted.add(path);
        if (isFile) {
            this.addCheckoutMetadata(path, attributes);
        }
    }

    protected boolean processEntry(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, DirCacheBuildIterator index, WorkingTreeIterator work, boolean ignoreConflicts, Attributes attributes) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        boolean gitLinkMerging;
        this.enterSubtree = true;
        int modeO = this.tw.getRawMode(1);
        int modeT = this.tw.getRawMode(2);
        int modeB = this.tw.getRawMode(0);
        boolean bl = gitLinkMerging = ResolveMerger.isGitLink(modeO) || ResolveMerger.isGitLink(modeT) || ResolveMerger.isGitLink(modeB);
        if (modeO == 0 && modeT == 0 && modeB == 0) {
            return true;
        }
        if (this.isIndexDirty()) {
            return false;
        }
        DirCacheEntry ourDce = null;
        if (index == null || index.getDirCacheEntry() == null) {
            if (ResolveMerger.nonTree(modeO)) {
                ourDce = new DirCacheEntry(this.tw.getRawPath());
                ourDce.setObjectId(this.tw.getObjectId(1));
                ourDce.setFileMode(this.tw.getFileMode(1));
            }
        } else {
            ourDce = index.getDirCacheEntry();
        }
        if (ResolveMerger.nonTree(modeO) && ResolveMerger.nonTree(modeT) && this.tw.idEqual(1, 2)) {
            if (modeO == modeT) {
                this.keep(ourDce);
                return true;
            }
            int newMode = this.mergeFileModes(modeB, modeO, modeT);
            if (newMode != FileMode.MISSING.getBits()) {
                if (newMode == modeO) {
                    this.keep(ourDce);
                } else {
                    if (this.isWorktreeDirty(work, ourDce)) {
                        return false;
                    }
                    DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                    this.addToCheckout(this.tw.getPathString(), e, attributes);
                }
                return true;
            }
            this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
            this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
            this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
            this.unmergedPaths.add(this.tw.getPathString());
            this.mergeResults.put(this.tw.getPathString(), new MergeResult(Collections.emptyList()));
            return true;
        }
        if (modeB == modeT && this.tw.idEqual(0, 2)) {
            if (ourDce != null) {
                this.keep(ourDce);
            }
            return true;
        }
        if (modeB == modeO && this.tw.idEqual(0, 1)) {
            if (this.isWorktreeDirty(work, ourDce)) {
                return false;
            }
            if (ResolveMerger.nonTree(modeT)) {
                DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                if (e != null) {
                    this.addToCheckout(this.tw.getPathString(), e, attributes);
                }
                return true;
            }
            if (this.tw.getTreeCount() > 4 && this.tw.getRawMode(4) == 0) {
                return true;
            }
            if (modeT != 0 && modeT == modeB) {
                return true;
            }
            this.addDeletion(this.tw.getPathString(), ResolveMerger.nonTree(modeO), attributes);
            return true;
        }
        if (this.tw.isSubtree()) {
            if (ResolveMerger.nonTree(modeO) && !ResolveMerger.nonTree(modeT)) {
                if (ResolveMerger.nonTree(modeB)) {
                    this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                }
                this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (ResolveMerger.nonTree(modeT) && !ResolveMerger.nonTree(modeO)) {
                if (ResolveMerger.nonTree(modeB)) {
                    this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                }
                this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (!ResolveMerger.nonTree(modeO)) {
                return true;
            }
        }
        if (ResolveMerger.nonTree(modeO) && ResolveMerger.nonTree(modeT)) {
            boolean worktreeDirty = this.isWorktreeDirty(work, ourDce);
            if (!attributes.canBeContentMerged() && worktreeDirty) {
                return false;
            }
            if (gitLinkMerging && ignoreConflicts) {
                this.add(this.tw.getRawPath(), ours, 0, Instant.EPOCH, 0L);
                return true;
            }
            if (gitLinkMerging) {
                this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                MergeResult<SubmoduleConflict> result2 = ResolveMerger.createGitLinksMergeResult(base, ours, theirs);
                result2.setContainsConflicts(true);
                this.mergeResults.put(this.tw.getPathString(), result2);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            if (!attributes.canBeContentMerged()) {
                this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            if (worktreeDirty) {
                return false;
            }
            MergeResult<RawText> result3 = this.contentMerge(base, ours, theirs, attributes);
            if (ignoreConflicts) {
                result3.setContainsConflicts(false);
            }
            this.updateIndex(base, ours, theirs, result3, attributes);
            String currentPath = this.tw.getPathString();
            if (result3.containsConflicts() && !ignoreConflicts) {
                this.unmergedPaths.add(currentPath);
            }
            this.modifiedFiles.add(currentPath);
            this.addCheckoutMetadata(currentPath, attributes);
        } else if (modeO != modeT && (modeO != 0 && !this.tw.idEqual(0, 1) || modeT != 0 && !this.tw.idEqual(0, 2))) {
            if (gitLinkMerging && ignoreConflicts) {
                this.add(this.tw.getRawPath(), ours, 0, Instant.EPOCH, 0L);
            } else if (gitLinkMerging) {
                this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                MergeResult<SubmoduleConflict> result4 = ResolveMerger.createGitLinksMergeResult(base, ours, theirs);
                result4.setContainsConflicts(true);
                this.mergeResults.put(this.tw.getPathString(), result4);
                this.unmergedPaths.add(this.tw.getPathString());
            } else {
                MergeResult<RawText> result5 = this.contentMerge(base, ours, theirs, attributes);
                if (ignoreConflicts) {
                    result5.setContainsConflicts(false);
                    this.updateIndex(base, ours, theirs, result5, attributes);
                } else {
                    this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                    this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                    DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                    if (modeO == 0) {
                        if (this.isWorktreeDirty(work, ourDce)) {
                            return false;
                        }
                        if (ResolveMerger.nonTree(modeT) && e != null) {
                            this.addToCheckout(this.tw.getPathString(), e, attributes);
                        }
                    }
                    this.unmergedPaths.add(this.tw.getPathString());
                    this.mergeResults.put(this.tw.getPathString(), result5);
                }
            }
        }
        return true;
    }

    private static MergeResult<SubmoduleConflict> createGitLinksMergeResult(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs) {
        return new MergeResult<SubmoduleConflict>(Arrays.asList(new SubmoduleConflict(base == null ? null : base.getEntryObjectId()), new SubmoduleConflict(ours == null ? null : ours.getEntryObjectId()), new SubmoduleConflict(theirs == null ? null : theirs.getEntryObjectId())));
    }

    private MergeResult<RawText> contentMerge(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, Attributes attributes) throws IOException {
        RawText theirsText;
        RawText ourText;
        RawText baseText;
        try {
            baseText = base == null ? RawText.EMPTY_TEXT : this.getRawText(base.getEntryObjectId(), attributes);
            ourText = ours == null ? RawText.EMPTY_TEXT : this.getRawText(ours.getEntryObjectId(), attributes);
            theirsText = theirs == null ? RawText.EMPTY_TEXT : this.getRawText(theirs.getEntryObjectId(), attributes);
        }
        catch (BinaryBlobException e) {
            MergeResult<RawText> r = new MergeResult<RawText>(Collections.emptyList());
            r.setContainsConflicts(true);
            return r;
        }
        return this.mergeAlgorithm.merge(RawTextComparator.DEFAULT, baseText, ourText, theirsText);
    }

    private boolean isIndexDirty() {
        boolean isDirty;
        if (this.inCore) {
            return false;
        }
        int modeI = this.tw.getRawMode(3);
        int modeO = this.tw.getRawMode(1);
        boolean bl = isDirty = ResolveMerger.nonTree(modeI) && (modeO != modeI || !this.tw.idEqual(3, 1));
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), MergeFailureReason.DIRTY_INDEX);
        }
        return isDirty;
    }

    private boolean isWorktreeDirty(WorkingTreeIterator work, DirCacheEntry ourDce) throws IOException {
        boolean isDirty;
        if (work == null) {
            return false;
        }
        int modeF = this.tw.getRawMode(4);
        int modeO = this.tw.getRawMode(1);
        if (ourDce != null) {
            isDirty = work.isModified(ourDce, true, this.reader);
        } else {
            isDirty = work.isModeDifferent(modeO);
            if (!isDirty && ResolveMerger.nonTree(modeF)) {
                boolean bl = isDirty = !this.tw.idEqual(4, 1);
            }
        }
        if (isDirty && modeF == 16384 && modeO == 0) {
            isDirty = false;
        }
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), MergeFailureReason.DIRTY_WORKTREE);
        }
        return isDirty;
    }

    private void updateIndex(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, MergeResult<RawText> result2, Attributes attributes) throws FileNotFoundException, IOException {
        TemporaryBuffer rawMerged = null;
        try {
            File mergedFile;
            rawMerged = this.doMerge(result2);
            File file2 = mergedFile = this.inCore ? null : this.writeMergedFile(rawMerged, attributes);
            if (result2.containsConflicts()) {
                this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                this.mergeResults.put(this.tw.getPathString(), result2);
                return;
            }
            DirCacheEntry dce = new DirCacheEntry(this.tw.getPathString());
            int newMode = this.mergeFileModes(this.tw.getRawMode(0), this.tw.getRawMode(1), this.tw.getRawMode(2));
            dce.setFileMode(newMode == FileMode.MISSING.getBits() ? FileMode.REGULAR_FILE : FileMode.fromBits(newMode));
            if (mergedFile != null) {
                dce.setLastModified(this.nonNullRepo().getFS().lastModifiedInstant(mergedFile));
                dce.setLength((int)mergedFile.length());
            }
            dce.setObjectId(this.insertMergeResult(rawMerged, attributes));
            this.builder.add(dce);
        }
        finally {
            if (rawMerged != null) {
                rawMerged.destroy();
            }
        }
    }

    private File writeMergedFile(TemporaryBuffer rawMerged, Attributes attributes) throws FileNotFoundException, IOException {
        File of2;
        File parentFolder;
        File workTree = this.nonNullRepo().getWorkTree();
        FS fs = this.nonNullRepo().getFS();
        if (!fs.exists(parentFolder = (of2 = new File(workTree, this.tw.getPathString())).getParentFile())) {
            parentFolder.mkdirs();
        }
        CoreConfig.EolStreamType streamType = EolStreamTypeUtil.detectStreamType(TreeWalk.OperationType.CHECKOUT_OP, this.workingTreeOptions, attributes);
        Throwable throwable = null;
        Object var9_10 = null;
        try (OutputStream os = EolStreamTypeUtil.wrapOutputStream(new BufferedOutputStream(new FileOutputStream(of2)), streamType);){
            rawMerged.writeTo(os, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return of2;
    }

    private TemporaryBuffer doMerge(MergeResult<RawText> result2) throws IOException {
        TemporaryBuffer.LocalFile buf = new TemporaryBuffer.LocalFile(this.db != null ? this.nonNullRepo().getDirectory() : null, this.inCoreLimit);
        boolean success = false;
        try {
            new MergeFormatter().formatMerge((OutputStream)buf, result2, Arrays.asList(this.commitNames), StandardCharsets.UTF_8);
            buf.close();
            success = true;
        }
        finally {
            if (!success) {
                buf.destroy();
            }
        }
        return buf;
    }

    private ObjectId insertMergeResult(TemporaryBuffer buf, Attributes attributes) throws IOException {
        InputStream in = buf.openInputStream();
        Throwable throwable = null;
        Object var5_6 = null;
        try (LfsFactory.LfsInputStream is = LfsFactory.getInstance().applyCleanFilter(this.getRepository(), in, buf.length(), attributes.get("merge"));){
            return this.getObjectInserter().insert(3, is.getLength(), is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private int mergeFileModes(int modeB, int modeO, int modeT) {
        if (modeO == modeT) {
            return modeO;
        }
        if (modeB == modeO) {
            return modeT == FileMode.MISSING.getBits() ? modeO : modeT;
        }
        if (modeB == modeT) {
            return modeO == FileMode.MISSING.getBits() ? modeT : modeO;
        }
        return FileMode.MISSING.getBits();
    }

    private RawText getRawText(ObjectId id2, Attributes attributes) throws IOException, BinaryBlobException {
        if (id2.equals(ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        ObjectLoader loader = LfsFactory.getInstance().applySmudgeFilter(this.getRepository(), this.reader.open(id2, 3), attributes.get("merge"));
        int threshold = 0x3200000;
        return RawText.load(loader, threshold);
    }

    private static boolean nonTree(int mode) {
        return mode != 0 && !FileMode.TREE.equals(mode);
    }

    private static boolean isGitLink(int mode) {
        return FileMode.GITLINK.equals(mode);
    }

    @Override
    public ObjectId getResultTreeId() {
        return this.resultTree == null ? null : this.resultTree.toObjectId();
    }

    public void setCommitNames(String[] commitNames) {
        this.commitNames = commitNames;
    }

    public String[] getCommitNames() {
        return this.commitNames;
    }

    public List<String> getUnmergedPaths() {
        return this.unmergedPaths;
    }

    public List<String> getModifiedFiles() {
        return this.modifiedFiles;
    }

    public Map<String, DirCacheEntry> getToBeCheckedOut() {
        return this.toBeCheckedOut;
    }

    public Map<String, MergeResult<? extends Sequence>> getMergeResults() {
        return this.mergeResults;
    }

    public Map<String, MergeFailureReason> getFailingPaths() {
        return this.failingPaths.isEmpty() ? null : this.failingPaths;
    }

    public boolean failed() {
        return !this.failingPaths.isEmpty();
    }

    public void setDirCache(DirCache dc) {
        this.dircache = dc;
        this.implicitDirCache = false;
    }

    public void setWorkingTreeIterator(WorkingTreeIterator workingTreeIterator) {
        this.workingTreeIterator = workingTreeIterator;
    }

    protected boolean mergeTrees(AbstractTreeIterator baseTree, RevTree headTree, RevTree mergeTree, boolean ignoreConflicts) throws IOException {
        this.builder = this.dircache.builder();
        DirCacheBuildIterator buildIt = new DirCacheBuildIterator(this.builder);
        this.tw = new NameConflictTreeWalk(this.db, this.reader);
        this.tw.addTree(baseTree);
        this.tw.addTree(headTree);
        this.tw.addTree(mergeTree);
        int dciPos = this.tw.addTree(buildIt);
        if (this.workingTreeIterator != null) {
            this.tw.addTree(this.workingTreeIterator);
            this.workingTreeIterator.setDirCacheIterator(this.tw, dciPos);
        } else {
            this.tw.setFilter(TreeFilter.ANY_DIFF);
        }
        if (!this.mergeTreeWalk(this.tw, ignoreConflicts)) {
            return false;
        }
        if (!this.inCore) {
            this.checkout();
            if (!this.builder.commit()) {
                this.cleanUp();
                throw new IndexWriteException();
            }
            this.builder = null;
        } else {
            this.builder.finish();
            this.builder = null;
        }
        if (this.getUnmergedPaths().isEmpty() && !this.failed()) {
            this.resultTree = this.dircache.writeTree(this.getObjectInserter());
            return true;
        }
        this.resultTree = null;
        return false;
    }

    protected boolean mergeTreeWalk(TreeWalk treeWalk, boolean ignoreConflicts) throws IOException {
        boolean hasWorkingTreeIterator = this.tw.getTreeCount() > 4;
        boolean hasAttributeNodeProvider = treeWalk.getAttributesNodeProvider() != null;
        while (treeWalk.next()) {
            if (!this.processEntry(treeWalk.getTree(0, CanonicalTreeParser.class), treeWalk.getTree(1, CanonicalTreeParser.class), treeWalk.getTree(2, CanonicalTreeParser.class), treeWalk.getTree(3, DirCacheBuildIterator.class), hasWorkingTreeIterator ? treeWalk.getTree(4, WorkingTreeIterator.class) : null, ignoreConflicts, hasAttributeNodeProvider ? treeWalk.getAttributes() : NO_ATTRIBUTES)) {
                this.cleanUp();
                return false;
            }
            if (!treeWalk.isSubtree() || !this.enterSubtree) continue;
            treeWalk.enterSubtree();
        }
        return true;
    }

    public static enum MergeFailureReason {
        DIRTY_INDEX,
        DIRTY_WORKTREE,
        COULD_NOT_DELETE;

    }
}

