/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.notes.FanoutBucket;
import org.eclipse.jgit.notes.InMemoryNoteBucket;
import org.eclipse.jgit.notes.LeafBucket;
import org.eclipse.jgit.notes.NonNoteEntry;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.util.RawParseUtils;

final class NoteParser
extends CanonicalTreeParser {
    private final int prefixLen;
    private final int pathPadding;
    private NonNoteEntry firstNonNote;
    private NonNoteEntry lastNonNote;

    static InMemoryNoteBucket parse(AbbreviatedObjectId prefix2, ObjectId treeId, ObjectReader reader) throws IOException {
        return new NoteParser(prefix2, reader, treeId).parse();
    }

    private NoteParser(AbbreviatedObjectId prefix2, ObjectReader r, ObjectId t) throws IncorrectObjectTypeException, IOException {
        super(Constants.encodeASCII(prefix2.name()), r, t);
        this.prefixLen = prefix2.length();
        int n = this.pathPadding = this.prefixLen > 0 ? 1 : 0;
        if (this.pathPadding > 0) {
            System.arraycopy(this.path, 0, this.path, this.pathPadding, this.prefixLen);
        }
    }

    private InMemoryNoteBucket parse() {
        InMemoryNoteBucket r = this.parseTree();
        r.nonNotes = this.firstNonNote;
        return r;
    }

    private InMemoryNoteBucket parseTree() {
        while (!this.eof()) {
            if (this.pathLen == this.pathPadding + 40 && this.isHex()) {
                return this.parseLeafTree();
            }
            if (this.getNameLength() == 2 && this.isHex() && this.isTree()) {
                return this.parseFanoutTree();
            }
            this.storeNonNote();
            this.next(1);
        }
        return new LeafBucket(this.prefixLen);
    }

    private LeafBucket parseLeafTree() {
        LeafBucket leaf = new LeafBucket(this.prefixLen);
        MutableObjectId idBuf = new MutableObjectId();
        while (!this.eof()) {
            if (this.parseObjectId(idBuf)) {
                leaf.parseOneEntry(idBuf, this.getEntryObjectId());
            } else {
                this.storeNonNote();
            }
            this.next(1);
        }
        return leaf;
    }

    private boolean parseObjectId(MutableObjectId id2) {
        if (this.pathLen == this.pathPadding + 40) {
            try {
                id2.fromString(this.path, this.pathPadding);
                return true;
            }
            catch (ArrayIndexOutOfBoundsException notHex) {
                return false;
            }
        }
        return false;
    }

    private FanoutBucket parseFanoutTree() {
        FanoutBucket fanout = new FanoutBucket(this.prefixLen);
        while (!this.eof()) {
            int cell = this.parseFanoutCell();
            if (cell >= 0) {
                fanout.setBucket(cell, this.getEntryObjectId());
            } else {
                this.storeNonNote();
            }
            this.next(1);
        }
        return fanout;
    }

    private int parseFanoutCell() {
        if (this.getNameLength() == 2 && this.isTree()) {
            try {
                return RawParseUtils.parseHexInt4(this.path[this.pathOffset + 0]) << 4 | RawParseUtils.parseHexInt4(this.path[this.pathOffset + 1]);
            }
            catch (ArrayIndexOutOfBoundsException notHex) {
                return -1;
            }
        }
        return -1;
    }

    private void storeNonNote() {
        ObjectId id2 = this.getEntryObjectId();
        FileMode fileMode = this.getEntryFileMode();
        byte[] name = new byte[this.getNameLength()];
        this.getName(name, 0);
        NonNoteEntry ent = new NonNoteEntry(name, fileMode, id2);
        if (this.firstNonNote == null) {
            this.firstNonNote = ent;
        }
        if (this.lastNonNote != null) {
            this.lastNonNote.next = ent;
        }
        this.lastNonNote = ent;
    }

    private boolean isTree() {
        return FileMode.TREE.equals(this.mode);
    }

    private boolean isHex() {
        try {
            int i = this.pathOffset;
            while (i < this.pathLen) {
                RawParseUtils.parseHexInt4(this.path[i]);
                ++i;
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException fail) {
            return false;
        }
    }
}

