/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.CompoundException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.internal.storage.file.UnpackedObject;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.BaseFetchConnection;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FileUtils;

class WalkFetchConnection
extends BaseFetchConnection {
    final Repository local;
    final ObjectChecker objCheck;
    private final List<WalkRemoteObjectDatabase> remotes;
    private int lastRemoteIdx;
    private final RevWalk revWalk;
    private final TreeWalk treeWalk;
    private final RevFlag COMPLETE;
    private final RevFlag IN_WORK_QUEUE;
    private final RevFlag LOCALLY_SEEN;
    private final DateRevQueue localCommitQueue;
    private LinkedList<ObjectId> workQueue;
    private final LinkedList<WalkRemoteObjectDatabase> noPacksYet;
    private final LinkedList<WalkRemoteObjectDatabase> noAlternatesYet;
    private final LinkedList<RemotePack> unfetchedPacks;
    private final Set<String> packsConsidered;
    private final MutableObjectId idBuffer = new MutableObjectId();
    private final HashMap<ObjectId, List<Throwable>> fetchErrors;
    String lockMessage;
    final List<PackLock> packLocks;
    final ObjectInserter inserter;
    private final ObjectReader reader;

    WalkFetchConnection(WalkTransport t, WalkRemoteObjectDatabase w) {
        Transport wt = (Transport)((Object)t);
        this.local = wt.local;
        this.objCheck = wt.getObjectChecker();
        this.inserter = this.local.newObjectInserter();
        this.reader = this.inserter.newReader();
        this.remotes = new ArrayList<WalkRemoteObjectDatabase>();
        this.remotes.add(w);
        this.unfetchedPacks = new LinkedList();
        this.packsConsidered = new HashSet<String>();
        this.noPacksYet = new LinkedList();
        this.noPacksYet.add(w);
        this.noAlternatesYet = new LinkedList();
        this.noAlternatesYet.add(w);
        this.fetchErrors = new HashMap();
        this.packLocks = new ArrayList<PackLock>(4);
        this.revWalk = new RevWalk(this.reader);
        this.revWalk.setRetainBody(false);
        this.treeWalk = new TreeWalk(this.reader);
        this.COMPLETE = this.revWalk.newFlag("COMPLETE");
        this.IN_WORK_QUEUE = this.revWalk.newFlag("IN_WORK_QUEUE");
        this.LOCALLY_SEEN = this.revWalk.newFlag("LOCALLY_SEEN");
        this.localCommitQueue = new DateRevQueue();
        this.workQueue = new LinkedList();
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return true;
    }

    @Override
    protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
        this.markLocalRefsComplete(have);
        this.queueWants(want);
        while (!monitor.isCancelled() && !this.workQueue.isEmpty()) {
            ObjectId id2 = this.workQueue.removeFirst();
            if (!(id2 instanceof RevObject) || !((RevObject)id2).has(this.COMPLETE)) {
                this.downloadObject(monitor, id2);
            }
            this.process(id2);
        }
        try {
            this.inserter.flush();
        }
        catch (IOException e) {
            throw new TransportException(e.getMessage(), e);
        }
    }

    @Override
    public Collection<PackLock> getPackLocks() {
        return this.packLocks;
    }

    @Override
    public void setPackLockMessage(String message) {
        this.lockMessage = message;
    }

    @Override
    public void close() {
        this.inserter.close();
        this.reader.close();
        for (RemotePack p : this.unfetchedPacks) {
            if (p.tmpIdx == null) continue;
            p.tmpIdx.delete();
        }
        for (WalkRemoteObjectDatabase r : this.remotes) {
            r.close();
        }
    }

    private void queueWants(Collection<Ref> want) throws TransportException {
        HashSet<ObjectId> inWorkQueue = new HashSet<ObjectId>();
        for (Ref r : want) {
            ObjectId id2 = r.getObjectId();
            if (id2 == null) {
                throw new NullPointerException(MessageFormat.format(JGitText.get().transportProvidedRefWithNoObjectId, r.getName()));
            }
            try {
                RevObject obj = this.revWalk.parseAny(id2);
                if (obj.has(this.COMPLETE) || !inWorkQueue.add(id2)) continue;
                obj.add(this.IN_WORK_QUEUE);
                this.workQueue.add(obj);
            }
            catch (MissingObjectException e) {
                if (!inWorkQueue.add(id2)) continue;
                this.workQueue.add(id2);
            }
            catch (IOException e) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotRead, id2.name()), e);
            }
        }
    }

    private void process(ObjectId id2) throws TransportException {
        RevObject obj;
        try {
            if (id2 instanceof RevObject) {
                obj = (RevObject)id2;
                if (obj.has(this.COMPLETE)) {
                    return;
                }
                this.revWalk.parseHeaders(obj);
            } else {
                obj = this.revWalk.parseAny(id2);
                if (obj.has(this.COMPLETE)) {
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotRead, id2.name()), e);
        }
        switch (obj.getType()) {
            case 3: {
                this.processBlob(obj);
                break;
            }
            case 2: {
                this.processTree(obj);
                break;
            }
            case 1: {
                this.processCommit(obj);
                break;
            }
            case 4: {
                this.processTag(obj);
                break;
            }
            default: {
                throw new TransportException(MessageFormat.format(JGitText.get().unknownObjectType, id2.name()));
            }
        }
        this.fetchErrors.remove(id2);
    }

    private void processBlob(RevObject obj) throws TransportException {
        try {
            if (!this.reader.has(obj, 3)) {
                throw new TransportException(MessageFormat.format(JGitText.get().cannotReadBlob, obj.name()), new MissingObjectException((ObjectId)obj, "blob"));
            }
            obj.add(this.COMPLETE);
        }
        catch (IOException error2) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotReadBlob, obj.name()), error2);
        }
    }

    private void processTree(RevObject obj) throws TransportException {
        try {
            this.treeWalk.reset((AnyObjectId)obj);
            block5: while (this.treeWalk.next()) {
                FileMode mode = this.treeWalk.getFileMode(0);
                int sType = mode.getObjectType();
                switch (sType) {
                    case 2: 
                    case 3: {
                        this.treeWalk.getObjectId(this.idBuffer, 0);
                        this.needs(this.revWalk.lookupAny(this.idBuffer, sType));
                        break;
                    }
                    default: {
                        if (FileMode.GITLINK.equals(mode)) continue block5;
                        this.treeWalk.getObjectId(this.idBuffer, 0);
                        throw new CorruptObjectException(MessageFormat.format(JGitText.get().invalidModeFor, mode, this.idBuffer.name(), this.treeWalk.getPathString(), obj.getId().name()));
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotReadTree, obj.name()), ioe);
        }
        obj.add(this.COMPLETE);
    }

    private void processCommit(RevObject obj) throws TransportException {
        RevCommit commit = (RevCommit)obj;
        this.markLocalCommitsComplete(commit.getCommitTime());
        this.needs(commit.getTree());
        RevCommit[] revCommitArray = commit.getParents();
        int n = revCommitArray.length;
        int n2 = 0;
        while (n2 < n) {
            RevCommit p = revCommitArray[n2];
            this.needs(p);
            ++n2;
        }
        obj.add(this.COMPLETE);
    }

    private void processTag(RevObject obj) {
        RevTag tag = (RevTag)obj;
        this.needs(tag.getObject());
        obj.add(this.COMPLETE);
    }

    private void needs(RevObject obj) {
        if (obj.has(this.COMPLETE)) {
            return;
        }
        if (!obj.has(this.IN_WORK_QUEUE)) {
            obj.add(this.IN_WORK_QUEUE);
            this.workQueue.add(obj);
        }
    }

    private void downloadObject(ProgressMonitor pm, AnyObjectId id2) throws TransportException {
        if (this.alreadyHave(id2)) {
            return;
        }
        block4: while (true) {
            if (this.downloadPackedObject(pm, id2)) {
                return;
            }
            String idStr = id2.name();
            String subdir = idStr.substring(0, 2);
            String file2 = idStr.substring(2);
            String looseName = String.valueOf(subdir) + "/" + file2;
            int i = this.lastRemoteIdx;
            while (i < this.remotes.size()) {
                if (this.downloadLooseObject(id2, looseName, this.remotes.get(i))) {
                    this.lastRemoteIdx = i;
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < this.lastRemoteIdx) {
                if (this.downloadLooseObject(id2, looseName, this.remotes.get(i))) {
                    this.lastRemoteIdx = i;
                    return;
                }
                ++i;
            }
            while (!this.noPacksYet.isEmpty()) {
                Collection<String> packNameList;
                WalkRemoteObjectDatabase wrr = this.noPacksYet.removeFirst();
                try {
                    try {
                        pm.beginTask(JGitText.get().listingPacks, 0);
                        packNameList = wrr.getPackNames();
                    }
                    catch (IOException iOException) {
                        this.recordError(id2, iOException);
                        pm.endTask();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    pm.endTask();
                    throw throwable;
                }
                pm.endTask();
                if (packNameList == null || packNameList.isEmpty()) continue;
                for (String string : packNameList) {
                    if (!this.packsConsidered.add(string)) continue;
                    this.unfetchedPacks.add(new RemotePack(wrr, string));
                }
                if (!this.downloadPackedObject(pm, id2)) continue;
                return;
            }
            Collection<WalkRemoteObjectDatabase> al = this.expandOneAlternate(id2, pm);
            if (al == null || al.isEmpty()) break;
            Iterator<WalkRemoteObjectDatabase> iterator2 = al.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block4;
                WalkRemoteObjectDatabase alt = iterator2.next();
                this.remotes.add(alt);
                this.noPacksYet.add(alt);
                this.noAlternatesYet.add(alt);
            }
            break;
        }
        List<Throwable> failures = this.fetchErrors.get(id2);
        TransportException transportException = new TransportException(MessageFormat.format(JGitText.get().cannotGet, id2.name()));
        if (failures != null && !failures.isEmpty()) {
            if (failures.size() == 1) {
                transportException.initCause(failures.get(0));
            } else {
                transportException.initCause(new CompoundException(failures));
            }
        }
        throw transportException;
    }

    private boolean alreadyHave(AnyObjectId id2) throws TransportException {
        try {
            return this.reader.has(id2);
        }
        catch (IOException error2) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotReadObject, id2.name()), error2);
        }
    }

    private boolean downloadPackedObject(ProgressMonitor monitor, AnyObjectId id2) throws TransportException {
        Iterator packItr = this.unfetchedPacks.iterator();
        while (packItr.hasNext() && !monitor.isCancelled()) {
            RemotePack pack = (RemotePack)packItr.next();
            try {
                pack.openIndex(monitor);
            }
            catch (IOException err) {
                this.recordError(id2, err);
                packItr.remove();
                continue;
            }
            if (monitor.isCancelled()) {
                return false;
            }
            if (!pack.index.hasObject(id2)) continue;
            try {
                try {
                    pack.downloadPack(monitor);
                }
                catch (IOException err) {
                    this.recordError(id2, err);
                    try {
                        if (pack.tmpIdx != null) {
                            FileUtils.delete(pack.tmpIdx);
                        }
                    }
                    catch (IOException e) {
                        throw new TransportException(e.getMessage(), e);
                    }
                    packItr.remove();
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pack.tmpIdx != null) {
                        FileUtils.delete(pack.tmpIdx);
                    }
                }
                catch (IOException e) {
                    throw new TransportException(e.getMessage(), e);
                }
                packItr.remove();
                throw throwable;
            }
            try {
                if (pack.tmpIdx != null) {
                    FileUtils.delete(pack.tmpIdx);
                }
            }
            catch (IOException e) {
                throw new TransportException(e.getMessage(), e);
            }
            packItr.remove();
            if (!this.alreadyHave(id2)) {
                this.recordError(id2, new FileNotFoundException(MessageFormat.format(JGitText.get().objectNotFoundIn, id2.name(), pack.packName)));
                continue;
            }
            Iterator<ObjectId> pending = this.swapFetchQueue();
            while (pending.hasNext()) {
                ObjectId p = pending.next();
                if (pack.index.hasObject(p)) {
                    pending.remove();
                    this.process(p);
                    continue;
                }
                this.workQueue.add(p);
            }
            return true;
        }
        return false;
    }

    private Iterator<ObjectId> swapFetchQueue() {
        Iterator<ObjectId> r = this.workQueue.iterator();
        this.workQueue = new LinkedList();
        return r;
    }

    private boolean downloadLooseObject(AnyObjectId id2, String looseName, WalkRemoteObjectDatabase remote) throws TransportException {
        try {
            byte[] compressed = remote.open(looseName).toArray();
            this.verifyAndInsertLooseObject(id2, compressed);
            return true;
        }
        catch (FileNotFoundException e) {
            this.recordError(id2, e);
            return false;
        }
        catch (IOException e) {
            throw new TransportException(MessageFormat.format(JGitText.get().cannotDownload, id2.name()), e);
        }
    }

    private void verifyAndInsertLooseObject(AnyObjectId id2, byte[] compressed) throws IOException {
        ObjectId act;
        ObjectLoader uol;
        try {
            uol = UnpackedObject.parse(compressed, id2);
        }
        catch (CorruptObjectException parsingError) {
            FileNotFoundException e = new FileNotFoundException(id2.name());
            e.initCause(parsingError);
            throw e;
        }
        int type2 = uol.getType();
        byte[] raw = uol.getCachedBytes();
        if (this.objCheck != null) {
            try {
                this.objCheck.check(id2, type2, raw);
            }
            catch (CorruptObjectException e) {
                throw new TransportException(MessageFormat.format(JGitText.get().transportExceptionInvalid, Constants.typeString(type2), id2.name(), e.getMessage()));
            }
        }
        if (!AnyObjectId.isEqual(id2, act = this.inserter.insert(type2, raw))) {
            throw new TransportException(MessageFormat.format(JGitText.get().incorrectHashFor, id2.name(), act.name(), Constants.typeString(type2), compressed.length));
        }
    }

    private Collection<WalkRemoteObjectDatabase> expandOneAlternate(AnyObjectId id2, ProgressMonitor pm) {
        while (!this.noAlternatesYet.isEmpty()) {
            WalkRemoteObjectDatabase wrr = this.noAlternatesYet.removeFirst();
            try {
                pm.beginTask(JGitText.get().listingAlternates, 0);
                Collection<WalkRemoteObjectDatabase> altList = wrr.getAlternates();
                if (altList == null || altList.isEmpty()) continue;
                Collection<WalkRemoteObjectDatabase> collection = altList;
                return collection;
            }
            catch (IOException e) {
                this.recordError(id2, e);
            }
            finally {
                pm.endTask();
            }
        }
        return null;
    }

    private void markLocalRefsComplete(Set<ObjectId> have) throws TransportException {
        List<Ref> refs;
        try {
            refs = this.local.getRefDatabase().getRefs();
        }
        catch (IOException e) {
            throw new TransportException(e.getMessage(), e);
        }
        for (Ref r : refs) {
            try {
                this.markLocalObjComplete(this.revWalk.parseAny(r.getObjectId()));
            }
            catch (IOException readError) {
                throw new TransportException(MessageFormat.format(JGitText.get().localRefIsMissingObjects, r.getName()), readError);
            }
        }
        for (ObjectId id2 : have) {
            try {
                this.markLocalObjComplete(this.revWalk.parseAny(id2));
            }
            catch (IOException readError) {
                throw new TransportException(MessageFormat.format(JGitText.get().transportExceptionMissingAssumed, id2.name()), readError);
            }
        }
    }

    private void markLocalObjComplete(RevObject obj) throws IOException {
        while (obj.getType() == 4) {
            obj.add(this.COMPLETE);
            obj = ((RevTag)obj).getObject();
            this.revWalk.parseHeaders(obj);
        }
        switch (obj.getType()) {
            case 3: {
                obj.add(this.COMPLETE);
                break;
            }
            case 1: {
                this.pushLocalCommit((RevCommit)obj);
                break;
            }
            case 2: {
                this.markTreeComplete((RevTree)obj);
            }
        }
    }

    private void markLocalCommitsComplete(int until) throws TransportException {
        try {
            block2: while (true) {
                RevCommit c;
                if ((c = this.localCommitQueue.peek()) == null || c.getCommitTime() < until) {
                    return;
                }
                this.localCommitQueue.next();
                this.markTreeComplete(c.getTree());
                RevCommit[] revCommitArray = c.getParents();
                int n = revCommitArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block2;
                    RevCommit p = revCommitArray[n2];
                    this.pushLocalCommit(p);
                    ++n2;
                }
                break;
            }
        }
        catch (IOException err) {
            throw new TransportException(JGitText.get().localObjectsIncomplete, err);
        }
    }

    private void pushLocalCommit(RevCommit p) throws MissingObjectException, IOException {
        if (p.has(this.LOCALLY_SEEN)) {
            return;
        }
        this.revWalk.parseHeaders(p);
        p.add(this.LOCALLY_SEEN);
        p.add(this.COMPLETE);
        p.carry(this.COMPLETE);
        this.localCommitQueue.add(p);
    }

    private void markTreeComplete(RevTree tree2) throws IOException {
        if (tree2.has(this.COMPLETE)) {
            return;
        }
        tree2.add(this.COMPLETE);
        this.treeWalk.reset((AnyObjectId)tree2);
        block4: while (this.treeWalk.next()) {
            FileMode mode = this.treeWalk.getFileMode(0);
            int sType = mode.getObjectType();
            switch (sType) {
                case 3: {
                    this.treeWalk.getObjectId(this.idBuffer, 0);
                    this.revWalk.lookupAny(this.idBuffer, sType).add(this.COMPLETE);
                    break;
                }
                case 2: {
                    this.treeWalk.getObjectId(this.idBuffer, 0);
                    RevObject o = this.revWalk.lookupAny(this.idBuffer, sType);
                    if (o.has(this.COMPLETE)) continue block4;
                    o.add(this.COMPLETE);
                    this.treeWalk.enterSubtree();
                    break;
                }
                default: {
                    if (FileMode.GITLINK.equals(mode)) continue block4;
                    this.treeWalk.getObjectId(this.idBuffer, 0);
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptObjectInvalidMode3, mode, this.idBuffer.name(), this.treeWalk.getPathString(), tree2.name()));
                }
            }
        }
    }

    private void recordError(AnyObjectId id2, Throwable what) {
        ObjectId objId = id2.copy();
        List<Throwable> errors = this.fetchErrors.get(objId);
        if (errors == null) {
            errors = new ArrayList<Throwable>(2);
            this.fetchErrors.put(objId, errors);
        }
        errors.add(what);
    }

    private class RemotePack {
        final WalkRemoteObjectDatabase connection;
        final String packName;
        final String idxName;
        File tmpIdx;
        PackIndex index;

        RemotePack(WalkRemoteObjectDatabase c, String pn) {
            this.connection = c;
            this.packName = pn;
            String tn = this.idxName = String.valueOf(this.packName.substring(0, this.packName.length() - 5)) + ".idx";
            if (tn.startsWith("pack-")) {
                tn = tn.substring(5);
            }
            if (tn.endsWith(".idx")) {
                tn = tn.substring(0, tn.length() - 4);
            }
            if (WalkFetchConnection.this.local.getObjectDatabase() instanceof ObjectDirectory) {
                this.tmpIdx = new File(((ObjectDirectory)WalkFetchConnection.this.local.getObjectDatabase()).getDirectory(), "walk-" + tn + ".walkidx");
            }
        }

        void openIndex(ProgressMonitor pm) throws IOException {
            if (this.index != null) {
                return;
            }
            if (this.tmpIdx == null) {
                this.tmpIdx = File.createTempFile("jgit-walk-", ".idx");
            } else if (this.tmpIdx.isFile()) {
                try {
                    this.index = PackIndex.open(this.tmpIdx);
                    return;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            WalkRemoteObjectDatabase.FileStream s2 = this.connection.open("pack/" + this.idxName);
            pm.beginTask("Get " + this.idxName.substring(0, 12) + "..idx", s2.length < 0L ? 0 : (int)(s2.length / 1024L));
            try {
                try {
                    Throwable throwable = null;
                    Object var4_8 = null;
                    try (FileOutputStream fos = new FileOutputStream(this.tmpIdx);){
                        int cnt;
                        byte[] buf = new byte[2048];
                        while (!pm.isCancelled() && (cnt = s2.in.read(buf)) >= 0) {
                            fos.write(buf, 0, cnt);
                            pm.update(cnt / 1024);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException err) {
                    FileUtils.delete(this.tmpIdx);
                    throw err;
                }
            }
            finally {
                s2.in.close();
            }
            pm.endTask();
            if (pm.isCancelled()) {
                FileUtils.delete(this.tmpIdx);
                return;
            }
            try {
                this.index = PackIndex.open(this.tmpIdx);
            }
            catch (IOException e) {
                FileUtils.delete(this.tmpIdx);
                throw e;
            }
        }

        void downloadPack(ProgressMonitor monitor) throws IOException {
            String name = "pack/" + this.packName;
            WalkRemoteObjectDatabase.FileStream s2 = this.connection.open(name);
            try {
                PackParser parser = WalkFetchConnection.this.inserter.newPackParser(s2.in);
                parser.setAllowThin(false);
                parser.setObjectChecker(WalkFetchConnection.this.objCheck);
                parser.setLockMessage(WalkFetchConnection.this.lockMessage);
                PackLock lock2 = parser.parse(monitor);
                if (lock2 != null) {
                    WalkFetchConnection.this.packLocks.add(lock2);
                }
            }
            finally {
                s2.in.close();
            }
        }
    }
}

