/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.format;

import java.io.IOException;
import java.io.Writer;
import org.gjt.xpp.XmlEndTag;
import org.gjt.xpp.XmlNode;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.XmlRecorder;
import org.gjt.xpp.XmlStartTag;
import org.gjt.xpp.XmlWritable;

public class Recorder
implements XmlRecorder {
    protected String[] declaredPrefixes;
    protected String[] declaredNs;
    protected Writer out;

    public Writer getOutput() {
        return this.out;
    }

    public void setOutput(Writer out) {
        this.out = out;
    }

    public void write(Object o) throws IOException, XmlPullParserException {
        if (o instanceof XmlNode) {
            this.writeNode((XmlNode)o);
        } else if (o instanceof XmlStartTag) {
            this.writeStartTag((XmlStartTag)o);
        } else if (o instanceof XmlEndTag) {
            this.writeEndTag((XmlEndTag)o);
        } else if (o instanceof XmlWritable) {
            ((XmlWritable)o).writeXml(this.out);
        } else if (o != null) {
            this.writeContent(o.toString());
        }
    }

    public void writeXml(XmlWritable w) throws IOException, XmlPullParserException {
        w.writeXml(this.out);
    }

    public void writeContent(String s2) throws IOException, XmlPullParserException {
        if (s2 == null) {
            throw new XmlPullParserException("null string can not be written as XML element content");
        }
        this.writeEscaped(s2, false);
    }

    public void writeEndTag(XmlEndTag etag) throws IOException, XmlPullParserException {
        if (etag.getRawName() == null) {
            throw new XmlPullParserException("raw name of XML element can not be null");
        }
        this.out.write("</");
        this.out.write(etag.getRawName());
        this.out.write(62);
    }

    public void writeStartTag(XmlStartTag stag) throws IOException, XmlPullParserException {
        this.writeStartTagStart(stag);
        this.out.write(62);
    }

    public void writeStartTagStart(XmlStartTag stag) throws IOException, XmlPullParserException {
        if (stag.getRawName() == null) {
            throw new XmlPullParserException("raw name of XML element can not be null");
        }
        this.out.write(60);
        this.out.write(stag.getRawName());
        int i = 0;
        while (i < stag.getAttributeCount()) {
            if (!stag.isAttributeNamespaceDeclaration(i)) {
                this.out.write(32);
                this.out.write(stag.getAttributeRawName(i));
                this.out.write("='");
                this.writeEscaped(stag.getAttributeValue(i), true);
                this.out.write(39);
            }
            ++i;
        }
    }

    public void writeStartTagAsEndTag(XmlStartTag stag) throws IOException, XmlPullParserException {
        if (stag.getRawName() == null) {
            throw new XmlPullParserException("raw name of XML end tag can not be null");
        }
        this.out.write("</");
        this.out.write(stag.getRawName());
        this.out.write(62);
    }

    public void writeNode(XmlNode node) throws IOException, XmlPullParserException {
        XmlNode parent;
        String defaultUri;
        this.writeStartTagStart(node);
        int len = node.getDeclaredNamespaceLength();
        if (len > 0) {
            if (this.declaredNs == null || len > this.declaredNs.length) {
                int newLen = len + 10;
                String[] newDeclaredPrefixes = new String[newLen];
                String[] newDeclaredNs = new String[newLen];
                int oldLen = this.declaredNs != null ? this.declaredNs.length : 0;
                int i = 0;
                while (i < oldLen) {
                    newDeclaredPrefixes[i] = this.declaredPrefixes[i];
                    newDeclaredNs[i] = this.declaredNs[i];
                    ++i;
                }
                this.declaredPrefixes = newDeclaredPrefixes;
                this.declaredNs = newDeclaredNs;
            }
            node.readDeclaredPrefixes(this.declaredPrefixes, 0, len);
            node.readDeclaredNamespaceUris(this.declaredNs, 0, len);
            int i = 0;
            while (i < len) {
                this.out.write(" xmlns:");
                this.out.write(this.declaredPrefixes[i]);
                this.out.write("='");
                this.writeEscaped(this.declaredNs[i], true);
                this.out.write(39);
                ++i;
            }
        }
        if ((defaultUri = node.getDefaultNamespaceUri()) != null && ((parent = node.getParentNode()) != null && !defaultUri.equals(parent.getDefaultNamespaceUri()) || parent == null && !"".equals(defaultUri))) {
            this.out.write(" xmlns='");
            this.writeEscaped(defaultUri, true);
            this.out.write(39);
        }
        boolean hadChildren = false;
        int childCount = node.getChildrenCount();
        int i = 0;
        while (i < childCount) {
            Object o = node.getChildAt(i);
            if (o != null) {
                if (!hadChildren) {
                    hadChildren = true;
                    this.out.write(62);
                }
                this.write(o);
            }
            ++i;
        }
        if (hadChildren) {
            this.writeStartTagAsEndTag(node);
        } else {
            this.out.write("/>");
        }
    }

    protected void writeEscaped(String s2, boolean escapeApostAttrib) throws IOException, XmlPullParserException {
        int pos = 0;
        int i = 0;
        int len = s2.length();
        while (i < len) {
            char ch = s2.charAt(i);
            switch (ch) {
                case '<': {
                    if (i > pos) {
                        this.out.write(s2, pos, i - pos);
                    }
                    pos = i + 1;
                    this.out.write("&lt;");
                    break;
                }
                case '\r': {
                    if (i > pos) {
                        this.out.write(s2, pos, i - pos);
                    }
                    pos = i + 1;
                    this.out.write("&#xD;");
                    break;
                }
                case '&': {
                    if (i > pos) {
                        this.out.write(s2, pos, i - pos);
                    }
                    pos = i + 1;
                    this.out.write("&amp;");
                    break;
                }
                case '\t': {
                    if (!escapeApostAttrib) break;
                    if (i > pos) {
                        this.out.write(s2, pos, i - pos);
                    }
                    pos = i + 1;
                    this.out.write("&#x9;");
                    break;
                }
                case '\n': {
                    if (!escapeApostAttrib) break;
                    if (i > pos) {
                        this.out.write(s2, pos, i - pos);
                    }
                    pos = i + 1;
                    this.out.write("&#xA;");
                    break;
                }
                case '\'': {
                    if (!escapeApostAttrib) break;
                    if (i > pos) {
                        this.out.write(s2, pos, i - pos);
                    }
                    pos = i + 1;
                    this.out.write("&apos;");
                }
            }
            ++i;
        }
        if (pos == 0) {
            this.out.write(s2);
        } else {
            this.out.write(s2, pos, i - pos);
        }
    }
}

