/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.pullnode;

import java.io.IOException;
import java.util.Enumeration;
import org.gjt.xpp.XmlPullNode;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.impl.tag.PullParserRuntimeException;

class PullNodeEnumerator
implements Enumeration {
    XmlPullNode node;
    int pos;

    PullNodeEnumerator(XmlPullNode node) {
        this.node = node;
        this.pos = 0;
    }

    public boolean hasMoreElements() {
        if (this.node.isFinished()) {
            return this.pos < this.node.getChildrenCount();
        }
        int countSoFar = this.node.getChildrenCountSoFar();
        if (this.pos < countSoFar) {
            return true;
        }
        try {
            Object value2;
            while ((value2 = this.node.readNextChild()) != null) {
                if (this.pos != ++countSoFar - 1) continue;
                return true;
            }
            return false;
        }
        catch (XmlPullParserException ex) {
            throw new PullParserRuntimeException("next value could not be read ", ex);
        }
        catch (IOException ex) {
            throw new PullParserRuntimeException("next value could not be read ", ex);
        }
    }

    public Object nextElement() {
        return this.node.getChildAt(this.pos++);
    }
}

