/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.impl.tag;

import org.gjt.xpp.XmlStartTag;
import org.gjt.xpp.impl.tag.Attribute;
import org.gjt.xpp.impl.tag.Tag;

public class StartTag
extends Tag
implements XmlStartTag {
    private int attEnd;
    private int attSize;
    private Attribute[] attArr;

    public void resetStartTag() {
        super.resetTag();
        this.attEnd = 0;
    }

    public int getAttributeCount() {
        return this.attEnd;
    }

    public String getAttributeNamespaceUri(int index) {
        if (index >= 0 && index < this.attEnd) {
            return this.attArr[index].uri;
        }
        return null;
    }

    public String getAttributeLocalName(int index) {
        if (index >= 0 && index < this.attEnd) {
            return this.attArr[index].localName;
        }
        return null;
    }

    public String getAttributePrefix(int index) {
        int pos;
        String s2;
        if (index >= 0 && index < this.attEnd && (s2 = this.attArr[index].qName) != null && (pos = s2.indexOf(58)) != -1) {
            return s2.substring(0, pos);
        }
        return null;
    }

    public String getAttributeRawName(int index) {
        if (index >= 0 && index < this.attEnd) {
            return this.attArr[index].qName;
        }
        return null;
    }

    public String getAttributeValue(int index) {
        if (index >= 0 && index < this.attEnd) {
            return this.attArr[index].value;
        }
        return null;
    }

    public boolean isAttributeNamespaceDeclaration(int index) {
        return this.attArr[index].xmlnsAttrib;
    }

    public String getAttributeValueFromName(String uri, String localName) {
        int i = 0;
        while (i < this.attEnd) {
            if ((uri != null && uri.equals(this.attArr[i].uri) || uri == null && this.attArr[i].uri == null) && localName.equals(this.attArr[i].localName)) {
                return this.attArr[i].value;
            }
            ++i;
        }
        return null;
    }

    public String getAttributeValueFromRawName(String qName) {
        int i = 0;
        while (i < this.attEnd) {
            if (qName.equals(this.attArr[i].qName)) {
                return this.attArr[i].value;
            }
            ++i;
        }
        return null;
    }

    public void addAttribute(String namespaceUri, String localName, String rawName, String value2) {
        this.addAttribute(namespaceUri, localName, rawName, value2, false);
    }

    public void addAttribute(String namespaceUri, String localName, String rawName, String value2, boolean isNamespaceDeclaration) {
        if (this.attEnd >= this.attSize) {
            this.ensureAttributesCapacity(2 * this.attEnd + 1);
        }
        Attribute att = this.attArr[this.attEnd++];
        att.uri = namespaceUri;
        att.localName = localName;
        att.qName = rawName;
        att.value = value2;
    }

    public void ensureAttributesCapacity(int minCapacity) {
        int newSize = minCapacity;
        if (this.attSize < newSize) {
            Attribute[] newAttArr = new Attribute[newSize];
            if (this.attArr != null) {
                System.arraycopy(this.attArr, 0, newAttArr, 0, this.attEnd);
            }
            int i = this.attEnd;
            while (i < newSize) {
                newAttArr[i] = new Attribute();
                ++i;
            }
            this.attArr = newAttArr;
            this.attSize = newSize;
        }
    }

    public void removeAtttributes() {
        this.attEnd = 0;
    }

    protected void printFields(StringBuffer buf) {
        super.printFields(buf);
        if (this.attEnd > 0) {
            buf.append(" attArr=[ ");
            int i = 0;
            while (i < this.attEnd) {
                buf.append(this.attArr[i] + " ");
                ++i;
            }
            buf.append(" ]");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("StartTag={");
        this.printFields(buf);
        buf.append(" }");
        return buf.toString();
    }
}

