/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.jaxp11;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gjt.xpp.jaxp11.DefaultValidationErrorHandler;
import org.gjt.xpp.sax2.Driver;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

public class SAXParserImpl
extends SAXParser {
    private XMLReader xmlReader;
    private Parser parser = null;
    private boolean validating = false;
    private boolean namespaceAware = false;

    SAXParserImpl(SAXParserFactory spf, Hashtable features2) throws SAXException {
        try {
            this.xmlReader = new Driver();
        }
        catch (Exception ex) {
            throw new SAXException("could not create XPP2 driver for SAX2 " + ex, ex);
        }
        this.validating = spf.isValidating();
        String validation = "http://xml.org/sax/features/validation";
        if (this.validating) {
            this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.xmlReader.setFeature(validation, this.validating);
        this.namespaceAware = spf.isNamespaceAware();
        String namespaces = "http://xml.org/sax/features/namespaces";
        this.xmlReader.setFeature(namespaces, this.namespaceAware);
        this.setFeatures(features2);
    }

    private void setFeatures(Hashtable features2) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (features2 != null) {
            Enumeration e = features2.keys();
            while (e.hasMoreElements()) {
                String feature = (String)e.nextElement();
                boolean value2 = (Boolean)features2.get(feature);
                this.xmlReader.setFeature(feature, value2);
            }
        }
    }

    public Parser getParser() throws SAXException {
        if (this.parser == null) {
            this.parser = new XMLReaderAdapter(this.xmlReader);
            this.parser.setDocumentHandler(new HandlerBase());
        }
        return this.parser;
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setProperty(String name, Object value2) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlReader.setProperty(name, value2);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlReader.getProperty(name);
    }
}

