/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.xpp.sax2;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.gjt.xpp.XmlEndTag;
import org.gjt.xpp.XmlPullParser;
import org.gjt.xpp.XmlPullParserException;
import org.gjt.xpp.XmlPullParserFactory;
import org.gjt.xpp.XmlStartTag;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Driver
implements Locator,
XMLReader,
Attributes {
    protected static final String DECLARATION_HANDLER_PROPERTY = "http://xml.org/sax/properties/declaration-handler";
    protected static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    protected static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String APACHE_SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    protected static final String APACHE_DYNAMIC_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/dynamic";
    protected ContentHandler contentHandler;
    protected ErrorHandler errorHandler;
    protected String systemId;
    protected XmlPullParser pp;
    protected XmlEndTag etag;
    protected XmlStartTag stag;
    private static final boolean DEBUG = false;
    private char[] buf = new char[1024];
    private String[] namespaces = new String[5];
    private String[] prefixes = new String[5];

    public Driver() throws XmlPullParserException {
        this.contentHandler = new DefaultHandler();
        this.errorHandler = new DefaultHandler();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        this.pp = factory.newPullParser();
        this.etag = factory.newEndTag();
        this.stag = factory.newStartTag();
    }

    public int getLength() {
        return this.stag.getAttributeCount();
    }

    public String getURI(int index) {
        return this.stag.getAttributeNamespaceUri(index);
    }

    public String getLocalName(int index) {
        return this.stag.getAttributeLocalName(index);
    }

    public String getQName(int index) {
        return this.stag.getAttributeRawName(index);
    }

    public String getType(int index) {
        return "CDATA";
    }

    public String getValue(int index) {
        return this.stag.getAttributeValue(index);
    }

    public int getIndex(String uri, String localName) {
        int i = 0;
        while (i < this.stag.getAttributeCount()) {
            if (this.stag.getAttributeNamespaceUri(i).equals(uri) && this.stag.getAttributeLocalName(i).equals(localName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndex(String qName) {
        int i = 0;
        while (i < this.stag.getAttributeCount()) {
            if (this.stag.getAttributeRawName(i).equals(qName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getType(String uri, String localName) {
        return "CDATA";
    }

    public String getType(String qName) {
        return "CDATA";
    }

    public String getValue(String uri, String localName) {
        return this.stag.getAttributeValueFromName(uri, localName);
    }

    public String getValue(String qName) {
        return this.stag.getAttributeValueFromRawName(qName);
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.pp.getLineNumber();
    }

    public int getColumnNumber() {
        return this.pp.getColumnNumber();
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE.equals(name)) {
            return this.pp.isNamespaceAware();
        }
        if (NAMESPACE_PREFIXES_FEATURE.equals(name)) {
            return this.pp.isNamespaceAttributesReporting();
        }
        if (VALIDATION_FEATURE.equals(name)) {
            return false;
        }
        if (APACHE_SCHEMA_VALIDATION_FEATURE.equals(name)) {
            return false;
        }
        if (APACHE_DYNAMIC_VALIDATION_FEATURE.equals(name)) {
            return false;
        }
        throw new SAXNotRecognizedException("unrecognized feature " + name);
    }

    public void setFeature(String name, boolean value2) throws SAXNotRecognizedException, SAXNotSupportedException {
        block8: {
            try {
                if (NAMESPACES_FEATURE.equals(name)) {
                    this.pp.setNamespaceAware(value2);
                    break block8;
                }
                if (NAMESPACE_PREFIXES_FEATURE.equals(name)) {
                    this.pp.setNamespaceAttributesReporting(value2);
                    break block8;
                }
                if (VALIDATION_FEATURE.equals(name)) {
                    if (value2) {
                        throw new SAXNotSupportedException("validation is not supported");
                    }
                    break block8;
                }
                if (APACHE_SCHEMA_VALIDATION_FEATURE.equals(name)) break block8;
                if (APACHE_DYNAMIC_VALIDATION_FEATURE.equals(name)) {
                    if (value2) {
                        throw new SAXNotSupportedException("dynamic validation is not supported");
                    }
                    break block8;
                }
                throw new SAXNotRecognizedException("unrecognized feature " + name);
            }
            catch (XmlPullParserException ex) {
                throw new SAXNotSupportedException("problem with setting feature " + name + ": " + ex);
            }
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (DECLARATION_HANDLER_PROPERTY.equals(name)) {
            return null;
        }
        if (LEXICAL_HANDLER_PROPERTY.equals(name)) {
            return null;
        }
        throw new SAXNotRecognizedException("not recognized get property " + name);
    }

    public void setProperty(String name, Object value2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (DECLARATION_HANDLER_PROPERTY.equals(name)) {
            throw new SAXNotSupportedException("not supported setting property " + name);
        }
        if (LEXICAL_HANDLER_PROPERTY.equals(name)) {
            throw new SAXNotSupportedException("not supported setting property " + name);
        }
        throw new SAXNotRecognizedException("not recognized set property " + name);
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(InputSource source) throws SAXException, IOException {
        this.systemId = source.getSystemId();
        this.contentHandler.setDocumentLocator(this);
        Reader reader = source.getCharacterStream();
        if (reader == null) {
            InputStream stream = source.getByteStream();
            String encoding = source.getEncoding();
            if (stream == null) {
                this.systemId = source.getSystemId();
                if (this.systemId == null) {
                    SAXParseException saxException = new SAXParseException("null source systemId", this);
                    this.errorHandler.fatalError(saxException);
                    return;
                }
                try {
                    URL url2 = new URL(this.systemId);
                    stream = url2.openStream();
                }
                catch (MalformedURLException nue) {
                    try {
                        stream = new FileInputStream(this.systemId);
                    }
                    catch (FileNotFoundException fnfe) {
                        SAXParseException saxException = new SAXParseException("could not open file with systemId " + this.systemId, this, fnfe);
                        this.errorHandler.fatalError(saxException);
                        return;
                    }
                }
            }
            if (encoding == null) {
                reader = new InputStreamReader(stream);
            } else {
                try {
                    reader = new InputStreamReader(stream, encoding);
                }
                catch (UnsupportedEncodingException une) {
                    SAXParseException saxException = new SAXParseException("cant create input stream reader for encoding " + encoding, this, une);
                    this.errorHandler.fatalError(saxException);
                    return;
                }
            }
        }
        try {
            this.pp.setInput(reader);
            this.contentHandler.startDocument();
            this.pp.next();
            if (this.pp.getEventType() != 2) {
                SAXParseException saxException = new SAXParseException("expected start tag not" + this.pp.getPosDesc(), this);
                this.errorHandler.fatalError(saxException);
                return;
            }
        }
        catch (XmlPullParserException ex) {
            SAXParseException saxException = new SAXParseException("parsing initialization error: " + ex, this, ex);
            this.errorHandler.fatalError(saxException);
            return;
        }
        this.parseSubTree(this.pp);
        this.contentHandler.endDocument();
    }

    public void parse(String systemId) throws SAXException, IOException {
        this.parse(new InputSource(systemId));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseSubTree(XmlPullParser pp) throws SAXException, IOException {
        try {
            if (pp.getEventType() != 2) {
                throw new SAXException("start tag must be read before skiping subtree" + pp.getPosDesc());
            }
            int level = 0;
            int type2 = 2;
            while (true) {
                switch (type2) {
                    case 2: {
                        pp.readStartTag(this.stag);
                        int count2 = pp.getNamespacesLength(pp.getDepth());
                        if (count2 > 0) {
                            if (this.namespaces.length < count2) {
                                this.namespaces = new String[count2];
                                this.prefixes = new String[count2];
                            }
                            pp.readNamespacesPrefixes(pp.getDepth(), this.prefixes, 0, count2);
                            pp.readNamespacesUris(pp.getDepth(), this.namespaces, 0, count2);
                            int i = 0;
                            while (i < count2) {
                                this.contentHandler.startPrefixMapping(this.prefixes[i], this.namespaces[i]);
                                ++i;
                            }
                        }
                        this.contentHandler.startElement(this.stag.getNamespaceUri(), this.stag.getLocalName(), this.stag.getRawName(), this);
                        ++level;
                        break;
                    }
                    case 4: {
                        String content = pp.readContent();
                        int len = content.length();
                        if (len > this.buf.length) {
                            this.buf = new char[len];
                        }
                        content.getChars(0, len, this.buf, 0);
                        this.contentHandler.characters(this.buf, 0, len);
                        break;
                    }
                    case 3: {
                        pp.readEndTag(this.etag);
                        int count3 = pp.getNamespacesLength(pp.getDepth());
                        this.contentHandler.endElement(this.etag.getNamespaceUri(), this.etag.getLocalName(), this.etag.getRawName());
                        --level;
                        if (count3 <= 0) break;
                        if (this.namespaces.length < count3) {
                            this.namespaces = new String[count3];
                            this.prefixes = new String[count3];
                        }
                        pp.readNamespacesPrefixes(pp.getDepth(), this.prefixes, 0, count3);
                        pp.readNamespacesUris(pp.getDepth(), this.namespaces, 0, count3);
                        int i = count3 - 1;
                        while (i >= 0) {
                            this.contentHandler.endPrefixMapping(this.prefixes[i]);
                            --i;
                        }
                        break;
                    }
                    case 1: {
                        return;
                    }
                }
                type2 = pp.next();
            }
        }
        catch (XmlPullParserException ex) {
            SAXParseException saxException = new SAXParseException("parsing error: " + ex, this, ex);
            this.errorHandler.fatalError(saxException);
        }
    }
}

