/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.serializers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.Store;
import org.reflections.serializers.Serializer;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.Utils;

public class XmlSerializer
implements Serializer {
    @Override
    public Reflections read(InputStream inputStream) {
        Reflections reflections;
        try {
            Constructor constructor = Reflections.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            reflections = (Reflections)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            reflections = new Reflections(new ConfigurationBuilder());
        }
        try {
            Document document = new SAXReader().read(inputStream);
            Iterator<Element> iterator2 = document.getRootElement().elements().iterator();
            while (iterator2.hasNext()) {
                Element e1;
                Element index = e1 = iterator2.next();
                Iterator<Element> iterator3 = index.elements().iterator();
                while (iterator3.hasNext()) {
                    Element e2;
                    Element entry = e2 = iterator3.next();
                    Element key = entry.element("key");
                    Element values2 = entry.element("values");
                    Iterator<Element> iterator4 = values2.elements().iterator();
                    while (iterator4.hasNext()) {
                        Element o3;
                        Element value2 = o3 = iterator4.next();
                        reflections.getStore().put(index.getName(), key.getText(), value2.getText());
                    }
                }
            }
        }
        catch (DocumentException e) {
            throw new ReflectionsException("could not read.", e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not read. Make sure relevant dependencies exist on classpath.", e);
        }
        return reflections;
    }

    @Override
    public File save(Reflections reflections, String filename) {
        File file2 = Utils.prepareFile(filename);
        try {
            Document document = this.createDocument(reflections);
            XMLWriter xmlWriter = new XMLWriter(new FileOutputStream(file2), OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new ReflectionsException("could not save to file " + filename, e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not save to file " + filename + ". Make sure relevant dependencies exist on classpath.", e);
        }
        return file2;
    }

    @Override
    public String toString(Reflections reflections) {
        Document document = this.createDocument(reflections);
        try {
            StringWriter writer2 = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(writer2, OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
            xmlWriter.close();
            return writer2.toString();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private Document createDocument(Reflections reflections) {
        Store map3 = reflections.getStore();
        Document document = DocumentFactory.getInstance().createDocument();
        Element root = document.addElement("Reflections");
        for (String indexName : map3.keySet()) {
            Element indexElement = root.addElement(indexName);
            for (String key : map3.keys(indexName)) {
                Element entryElement = indexElement.addElement("entry");
                entryElement.addElement("key").setText(key);
                Element valuesElement = entryElement.addElement("values");
                for (String value2 : map3.get(indexName, key)) {
                    valuesElement.addElement("value").setText(value2);
                }
            }
        }
        return document;
    }
}

