/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.StreamDataWriter;
import org.snakeyaml.engine.v2.api.StreamToStringWriter;
import org.snakeyaml.engine.v2.emitter.Emitter;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.representer.BaseRepresenter;
import org.snakeyaml.engine.v2.representer.StandardRepresenter;
import org.snakeyaml.engine.v2.serializer.Serializer;

public class Dump {
    protected DumpSettings settings;
    protected BaseRepresenter representer;

    public Dump(DumpSettings settings2) {
        this(settings2, new StandardRepresenter(settings2));
    }

    public Dump(DumpSettings settings2, BaseRepresenter representer) {
        Objects.requireNonNull(settings2, "DumpSettings cannot be null");
        Objects.requireNonNull(representer, "Representer cannot be null");
        this.settings = settings2;
        this.representer = representer;
    }

    public void dumpAll(Iterator<? extends Object> instancesIterator, StreamDataWriter streamDataWriter) {
        Serializer serializer = new Serializer(this.settings, new Emitter(this.settings, streamDataWriter));
        serializer.open();
        while (instancesIterator.hasNext()) {
            Object instance2 = instancesIterator.next();
            Node node = this.representer.represent(instance2);
            serializer.serialize(node);
        }
        serializer.close();
    }

    public void dump(Object yaml, StreamDataWriter streamDataWriter) {
        Iterator<Object> iter = Collections.singleton(yaml).iterator();
        this.dumpAll(iter, streamDataWriter);
    }

    public String dumpAllToString(Iterator<? extends Object> instancesIterator) {
        StreamToStringWriter writer2 = new StreamToStringWriter();
        this.dumpAll(instancesIterator, writer2);
        return writer2.toString();
    }

    public String dumpToString(Object yaml) {
        StreamToStringWriter writer2 = new StreamToStringWriter();
        this.dump(yaml, writer2);
        return writer2.toString();
    }
}

