/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.representer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.snakeyaml.engine.v2.api.RepresentToNode;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.snakeyaml.engine.v2.nodes.AnchorNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.snakeyaml.engine.v2.nodes.Tag;

public abstract class BaseRepresenter {
    protected final Map<Class<?>, RepresentToNode> representers = new HashMap();
    protected RepresentToNode nullRepresenter;
    protected final Map<Class<?>, RepresentToNode> parentClassRepresenters = new LinkedHashMap();
    protected ScalarStyle defaultScalarStyle = ScalarStyle.PLAIN;
    protected FlowStyle defaultFlowStyle = FlowStyle.AUTO;
    protected final Map<Object, Node> representedObjects = new IdentityHashMap<Object, Node>(){

        @Override
        public Node put(Object key, Node value2) {
            return super.put(key, new AnchorNode(value2));
        }
    };
    protected Object objectToRepresent;

    public Node represent(Object data2) {
        Node node = this.representData(data2);
        this.representedObjects.clear();
        this.objectToRepresent = null;
        return node;
    }

    protected Optional<RepresentToNode> findRepresenterFor(Object data2) {
        Class<?> clazz = data2.getClass();
        if (this.representers.containsKey(clazz)) {
            return Optional.of(this.representers.get(clazz));
        }
        for (Map.Entry<Class<?>, RepresentToNode> parentRepresenterEntry : this.parentClassRepresenters.entrySet()) {
            if (!parentRepresenterEntry.getKey().isInstance(data2)) continue;
            return Optional.of(parentRepresenterEntry.getValue());
        }
        return Optional.empty();
    }

    protected final Node representData(Object data2) {
        this.objectToRepresent = data2;
        if (this.representedObjects.containsKey(this.objectToRepresent)) {
            return this.representedObjects.get(this.objectToRepresent);
        }
        if (data2 == null) {
            return this.nullRepresenter.representData(null);
        }
        RepresentToNode representer = this.findRepresenterFor(data2).orElseThrow(() -> new YamlEngineException("Representer is not defined for " + data2.getClass()));
        return representer.representData(data2);
    }

    protected Node representScalar(Tag tag, String value2, ScalarStyle style) {
        if (style == ScalarStyle.PLAIN) {
            style = this.defaultScalarStyle;
        }
        return new ScalarNode(tag, value2, style);
    }

    protected Node representScalar(Tag tag, String value2) {
        return this.representScalar(tag, value2, ScalarStyle.PLAIN);
    }

    protected Node representSequence(Tag tag, Iterable<?> sequence2, FlowStyle flowStyle) {
        int size2 = 10;
        if (sequence2 instanceof List) {
            size2 = ((List)sequence2).size();
        }
        ArrayList<Node> value2 = new ArrayList<Node>(size2);
        SequenceNode node = new SequenceNode(tag, value2, flowStyle);
        this.representedObjects.put(this.objectToRepresent, node);
        FlowStyle bestStyle = FlowStyle.FLOW;
        for (Object item2 : sequence2) {
            Node nodeItem = this.representData(item2);
            if (!(nodeItem instanceof ScalarNode) || !((ScalarNode)nodeItem).isPlain()) {
                bestStyle = FlowStyle.BLOCK;
            }
            value2.add(nodeItem);
        }
        if (flowStyle == FlowStyle.AUTO) {
            if (this.defaultFlowStyle != FlowStyle.AUTO) {
                node.setFlowStyle(this.defaultFlowStyle);
            } else {
                node.setFlowStyle(bestStyle);
            }
        }
        return node;
    }

    protected Node representMapping(Tag tag, Map<?, ?> mapping, FlowStyle flowStyle) {
        ArrayList<NodeTuple> value2 = new ArrayList<NodeTuple>(mapping.size());
        MappingNode node = new MappingNode(tag, value2, flowStyle);
        this.representedObjects.put(this.objectToRepresent, node);
        FlowStyle bestStyle = FlowStyle.FLOW;
        for (Map.Entry<?, ?> entry : mapping.entrySet()) {
            Node nodeKey = this.representData(entry.getKey());
            Node nodeValue = this.representData(entry.getValue());
            if (!(nodeKey instanceof ScalarNode) || !((ScalarNode)nodeKey).isPlain()) {
                bestStyle = FlowStyle.BLOCK;
            }
            if (!(nodeValue instanceof ScalarNode) || !((ScalarNode)nodeValue).isPlain()) {
                bestStyle = FlowStyle.BLOCK;
            }
            value2.add(new NodeTuple(nodeKey, nodeValue));
        }
        if (flowStyle == FlowStyle.AUTO) {
            if (this.defaultFlowStyle != FlowStyle.AUTO) {
                node.setFlowStyle(this.defaultFlowStyle);
            } else {
                node.setFlowStyle(bestStyle);
            }
        }
        return node;
    }
}

