/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.ParserFactory;

public class ParserAdapter
implements XMLReader,
DocumentHandler {
    private static final String FEATURES = "http://xml.org/sax/features/";
    private static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private NamespaceSupport nsSupport;
    private AttributeListAdapter attAdapter;
    private boolean parsing = false;
    private String[] nameParts = new String[3];
    private Parser parser = null;
    private AttributesImpl atts = null;
    private boolean namespaces = true;
    private boolean prefixes = false;
    Locator locator;
    EntityResolver entityResolver = null;
    DTDHandler dtdHandler = null;
    ContentHandler contentHandler = null;
    ErrorHandler errorHandler = null;

    public ParserAdapter() throws SAXException {
        String driver = System.getProperty("org.xml.sax.parser");
        try {
            this.setup(ParserFactory.makeParser());
        }
        catch (ClassNotFoundException e1) {
            throw new SAXException("Cannot find SAX1 driver class " + driver, e1);
        }
        catch (IllegalAccessException e2) {
            throw new SAXException("SAX1 driver class " + driver + " found but cannot be loaded", e2);
        }
        catch (InstantiationException e3) {
            throw new SAXException("SAX1 driver class " + driver + " loaded but cannot be instantiated", e3);
        }
        catch (ClassCastException e4) {
            throw new SAXException("SAX1 driver class " + driver + " does not implement org.xml.sax.Parser");
        }
        catch (NullPointerException e5) {
            throw new SAXException("System property org.xml.sax.parser not specified");
        }
    }

    public ParserAdapter(Parser parser) {
        this.setup(parser);
    }

    private void setup(Parser parser) {
        if (parser == null) {
            throw new NullPointerException("Parser argument must not be null");
        }
        this.parser = parser;
        this.atts = new AttributesImpl();
        this.nsSupport = new NamespaceSupport();
        this.attAdapter = new AttributeListAdapter();
    }

    public void setFeature(String name, boolean value2) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(NAMESPACES)) {
            this.checkNotParsing("feature", name);
            this.namespaces = value2;
            if (!this.namespaces && !this.prefixes) {
                this.prefixes = true;
            }
        } else if (name.equals(NAMESPACE_PREFIXES)) {
            this.checkNotParsing("feature", name);
            this.prefixes = value2;
            if (!this.prefixes && !this.namespaces) {
                this.namespaces = true;
            }
        } else {
            throw new SAXNotRecognizedException("Feature: " + name);
        }
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(NAMESPACES)) {
            return this.namespaces;
        }
        if (name.equals(NAMESPACE_PREFIXES)) {
            return this.prefixes;
        }
        throw new SAXNotRecognizedException("Feature: " + name);
    }

    public void setProperty(String name, Object value2) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property: " + name);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property: " + name);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    public void parse(InputSource input) throws IOException, SAXException {
        if (this.parsing) {
            throw new SAXException("Parser is already in use");
        }
        this.setupParser();
        this.parsing = true;
        try {
            this.parser.parse(input);
            Object var3_2 = null;
            this.parsing = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.parsing = false;
            throw throwable;
        }
        this.parsing = false;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    public void startElement(String qName, AttributeList qAtts) throws SAXException {
        String value2;
        Vector<SAXException> exceptions = null;
        if (!this.namespaces) {
            if (this.contentHandler != null) {
                this.attAdapter.setAttributeList(qAtts);
                this.contentHandler.startElement("", "", qName.intern(), this.attAdapter);
            }
            return;
        }
        this.nsSupport.pushContext();
        int length2 = qAtts.getLength();
        int i = 0;
        while (i < length2) {
            block21: {
                String prefix2;
                block23: {
                    int n;
                    String attQName;
                    block22: {
                        attQName = qAtts.getName(i);
                        if (!attQName.startsWith("xmlns")) break block21;
                        n = attQName.indexOf(58);
                        if (n != -1 || attQName.length() != 5) break block22;
                        prefix2 = "";
                        break block23;
                    }
                    if (n != 5) break block21;
                    prefix2 = attQName.substring(n + 1);
                }
                value2 = qAtts.getValue(i);
                if (!this.nsSupport.declarePrefix(prefix2, value2)) {
                    this.reportError("Illegal Namespace prefix: " + prefix2);
                } else if (this.contentHandler != null) {
                    this.contentHandler.startPrefixMapping(prefix2, value2);
                }
            }
            ++i;
        }
        this.atts.clear();
        int i2 = 0;
        while (i2 < length2) {
            int n;
            String prefix3;
            String attQName = qAtts.getName(i2);
            String type2 = qAtts.getType(i2);
            value2 = qAtts.getValue(i2);
            if (attQName.startsWith("xmlns") && (prefix3 = (n = attQName.indexOf(58)) == -1 && attQName.length() == 5 ? "" : (n != 5 ? null : attQName.substring(n + 1))) != null) {
                if (this.prefixes) {
                    this.atts.addAttribute("", "", attQName.intern(), type2, value2);
                }
            } else {
                try {
                    String[] attName = this.processName(attQName, true, true);
                    this.atts.addAttribute(attName[0], attName[1], attName[2], type2, value2);
                }
                catch (SAXException e) {
                    if (exceptions == null) {
                        exceptions = new Vector<SAXException>();
                    }
                    exceptions.addElement(e);
                    this.atts.addAttribute("", attQName, attQName, type2, value2);
                }
            }
            ++i2;
        }
        if (exceptions != null && this.errorHandler != null) {
            int i3 = 0;
            while (i3 < exceptions.size()) {
                this.errorHandler.error((SAXParseException)exceptions.elementAt(i3));
                ++i3;
            }
        }
        if (this.contentHandler != null) {
            String[] name = this.processName(qName, false, false);
            this.contentHandler.startElement(name[0], name[1], name[2], this.atts);
        }
    }

    public void endElement(String qName) throws SAXException {
        if (!this.namespaces) {
            if (this.contentHandler != null) {
                this.contentHandler.endElement("", "", qName.intern());
            }
            return;
        }
        String[] names = this.processName(qName, false, false);
        if (this.contentHandler != null) {
            this.contentHandler.endElement(names[0], names[1], names[2]);
            Enumeration prefixes = this.nsSupport.getDeclaredPrefixes();
            while (prefixes.hasMoreElements()) {
                String prefix2 = (String)prefixes.nextElement();
                this.contentHandler.endPrefixMapping(prefix2);
            }
        }
        this.nsSupport.popContext();
    }

    public void characters(char[] ch, int start, int length2) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.characters(ch, start, length2);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length2) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(ch, start, length2);
        }
    }

    public void processingInstruction(String target, String data2) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(target, data2);
        }
    }

    private void setupParser() {
        this.nsSupport.reset();
        if (this.entityResolver != null) {
            this.parser.setEntityResolver(this.entityResolver);
        }
        if (this.dtdHandler != null) {
            this.parser.setDTDHandler(this.dtdHandler);
        }
        if (this.errorHandler != null) {
            this.parser.setErrorHandler(this.errorHandler);
        }
        this.parser.setDocumentHandler(this);
        this.locator = null;
    }

    private String[] processName(String qName, boolean isAttribute, boolean useException) throws SAXException {
        String[] parts = this.nsSupport.processName(qName, this.nameParts, isAttribute);
        if (parts == null) {
            if (useException) {
                throw this.makeException("Undeclared prefix: " + qName);
            }
            this.reportError("Undeclared prefix: " + qName);
            parts = new String[3];
            parts[1] = "";
            parts[0] = "";
            parts[2] = qName.intern();
        }
        return parts;
    }

    void reportError(String message) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(this.makeException(message));
        }
    }

    private SAXParseException makeException(String message) {
        if (this.locator != null) {
            return new SAXParseException(message, this.locator);
        }
        return new SAXParseException(message, null, null, -1, -1);
    }

    private void checkNotParsing(String type2, String name) throws SAXNotSupportedException {
        if (this.parsing) {
            throw new SAXNotSupportedException("Cannot change " + type2 + ' ' + name + " while parsing");
        }
    }

    final class AttributeListAdapter
    implements Attributes {
        private AttributeList qAtts;

        AttributeListAdapter() {
        }

        void setAttributeList(AttributeList qAtts) {
            this.qAtts = qAtts;
        }

        public int getLength() {
            return this.qAtts.getLength();
        }

        public String getURI(int i) {
            return "";
        }

        public String getLocalName(int i) {
            return "";
        }

        public String getQName(int i) {
            return this.qAtts.getName(i).intern();
        }

        public String getType(int i) {
            return this.qAtts.getType(i).intern();
        }

        public String getValue(int i) {
            return this.qAtts.getValue(i);
        }

        public int getIndex(String uri, String localName) {
            return -1;
        }

        public int getIndex(String qName) {
            int max = ParserAdapter.this.atts.getLength();
            int i = 0;
            while (i < max) {
                if (this.qAtts.getName(i).equals(qName)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getType(String qName) {
            return this.qAtts.getType(qName).intern();
        }

        public String getValue(String uri, String localName) {
            return null;
        }

        public String getValue(String qName) {
            return this.qAtts.getValue(qName);
        }
    }
}

