/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.contracts.wallet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.EncryptedData;
import org.bitcoinj.crypto.KeyCrypterAESCBC;
import org.bouncycastle.crypto.params.KeyParameter;
import org.dashj.platform.contracts.wallet.TxMetadataItem;
import org.dashj.platform.dpp.document.Document;
import org.dashj.platform.dpp.util.Cbor;
import org.dashj.platform.sdk.platform.AbstractDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/dashj/platform/contracts/wallet/TxMetadataDocument;", "Lorg/dashj/platform/sdk/platform/AbstractDocument;", "document", "Lorg/dashj/platform/dpp/document/Document;", "(Lorg/dashj/platform/dpp/document/Document;)V", "encryptedMetadata", "", "getEncryptedMetadata", "()[B", "encryptionKeyIndex", "", "getEncryptionKeyIndex", "()I", "keyIndex", "getKeyIndex", "decrypt", "", "Lorg/dashj/platform/contracts/wallet/TxMetadataItem;", "keyParameter", "Lorg/bouncycastle/crypto/params/KeyParameter;", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "dpp"})
@SourceDebugExtension(value={"SMAP\nTxMetadataDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TxMetadataDocument.kt\norg/dashj/platform/contracts/wallet/TxMetadataDocument\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1549#2:63\n1620#2,3:64\n*S KotlinDebug\n*F\n+ 1 TxMetadataDocument.kt\norg/dashj/platform/contracts/wallet/TxMetadataDocument\n*L\n59#1:63\n59#1:64,3\n*E\n"})
public final class TxMetadataDocument
extends AbstractDocument {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ChildNumber childNumber = new ChildNumber(131072, true);
    public static final int MAX_ENCRYPTED_SIZE = 4064;

    public TxMetadataDocument(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super(document);
    }

    public final int getKeyIndex() {
        Object object = this.getDocument().getData().get("keyIndex");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (int)((Long)object).longValue();
    }

    public final int getEncryptionKeyIndex() {
        Object object = this.getDocument().getData().get("encryptionKeyIndex");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
        return (int)((Long)object).longValue();
    }

    @NotNull
    public final byte[] getEncryptedMetadata() {
        byte[] byArray = this.getFieldByteArray("encryptedMetadata");
        Intrinsics.checkNotNull((Object)byArray);
        return byArray;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.dashj.platform.contracts.wallet.TxMetadataDocument");
        TxMetadataDocument cfr_ignored_0 = (TxMetadataDocument)other;
        return this.getDocument().equals(((TxMetadataDocument)other).getDocument());
    }

    @Override
    public int hashCode() {
        return this.getDocument().getId().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return "TxMetadata(" + this.getDocument().toJSON() + ')';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TxMetadataItem> decrypt(@NotNull KeyParameter keyParameter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)keyParameter, (String)"keyParameter");
        KeyCrypterAESCBC cipher = new KeyCrypterAESCBC();
        byte[] byArray = this.getEncryptedMetadata();
        int n = 0;
        int n2 = 16;
        byte[] iv = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        byte[] byArray2 = this.getEncryptedMetadata();
        n2 = 16;
        int n3 = this.getEncryptedMetadata().length;
        byte[] encryptedData = ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3);
        byte[] decryptedData = cipher.decrypt(new EncryptedData(iv, encryptedData), keyParameter);
        Intrinsics.checkNotNullExpressionValue((Object)decryptedData, (String)"decryptedData");
        List<Object> list = Cbor.INSTANCE.decodeList(decryptedData);
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            collection.add(new TxMetadataItem((Map)it));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/dashj/platform/contracts/wallet/TxMetadataDocument$Companion;", "", "()V", "MAX_ENCRYPTED_SIZE", "", "childNumber", "Lorg/bitcoinj/crypto/ChildNumber;", "getChildNumber", "()Lorg/bitcoinj/crypto/ChildNumber;", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChildNumber getChildNumber() {
            return childNumber;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

