/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dapiclient;

import com.google.common.base.Stopwatch;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.evolution.SimplifiedMasternodeListManager;
import org.bitcoinj.quorums.FinalCommitment;
import org.bitcoinj.quorums.LLMQParameters;
import org.dashj.platform.dapiclient.DapiClient;
import org.dashj.platform.dapiclient.MaxRetriesReachedException;
import org.dashj.platform.dapiclient.errors.NotFoundException;
import org.dashj.platform.dapiclient.errors.ResponseException;
import org.dashj.platform.dapiclient.model.DocumentQuery;
import org.dashj.platform.dapiclient.model.JsonRPCRequest;
import org.dashj.platform.dapiclient.model.JsonRPCResponse;
import org.dashj.platform.dapiclient.provider.DAPIAddress;
import org.dashj.platform.dapiclient.provider.DAPIAddressListProvider;
import org.dashj.platform.dapiclient.provider.ListDAPIAddressProvider;
import org.dashj.platform.dapiclient.provider.SimplifiedMasternodeListDAPIAddressProvider;
import org.dashj.platform.dapiclient.rest.DapiService;
import org.dashj.platform.dpp.DashPlatformProtocol;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.contract.DataContract;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.Identity;
import org.dashj.platform.dpp.identity.IdentityPublicKey;
import org.dashj.platform.dpp.statetransition.StateTransition;
import org.dashj.platform.dpp.util.Converters;
import org.dashj.platform.dpp.voting.ResourceVotesByIdentity;
import org.dashj.platform.dpp.voting.Vote;
import org.dashj.platform.dpp.voting.VotePollsGroupedByTimestamp;
import org.dashj.platform.sdk.Contenders;
import org.dashj.platform.sdk.ContestedResources;
import org.dashj.platform.sdk.Document;
import org.dashj.platform.sdk.PlatformValue;
import org.dashj.platform.sdk.Result_ok_Vec_u8_err_String;
import org.dashj.platform.sdk.SWIGTYPE_p_DashSdk;
import org.dashj.platform.sdk.Start;
import org.dashj.platform.sdk.TimestampMillis;
import org.dashj.platform.sdk.VotePollsGroupedByTimeStamp;
import org.dashj.platform.sdk.base.Result;
import org.dashj.platform.sdk.callbacks.ContextProvider;
import org.dashj.platform.sdk.callbacks.Signer;
import org.dashj.platform.sdk.dashsdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u0096\u00012\u00020\u0001:\u0002\u0096\u0001BO\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fBU\b\u0016\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0012BM\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\b\b\u0002\u0010K\u001a\u00020\u0007J\"\u0010L\u001a\u00020\u00032\u0006\u0010M\u001a\u00020N2\b\b\u0002\u0010O\u001a\u00020\u00072\b\b\u0002\u0010P\u001a\u00020\u0007J&\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020R2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020YJ\u001e\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020N2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u0003J\b\u0010`\u001a\u0004\u0018\u00010\u0003J\u0010\u0010a\u001a\u0004\u0018\u00010N2\u0006\u0010b\u001a\u00020\u0003J\u0010\u0010c\u001a\u0004\u0018\u00010\u00032\u0006\u0010d\u001a\u00020\fJ6\u0010e\u001a\u00020f2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u00032\b\b\u0002\u0010g\u001a\u00020\f2\n\b\u0002\u0010h\u001a\u0004\u0018\u00010i2\b\b\u0002\u0010j\u001a\u00020\u0007J\u001a\u0010k\u001a\u0004\u0018\u00010l2\u0006\u0010m\u001a\u00020N2\b\b\u0002\u0010n\u001a\u00020\u0007J.\u0010o\u001a\b\u0012\u0004\u0012\u00020[0\u00112\u0006\u0010p\u001a\u00020N2\u0006\u0010q\u001a\u00020\u00032\u0006\u0010r\u001a\u00020s2\b\b\u0002\u0010n\u001a\u00020\u0007J\u001a\u0010t\u001a\u0004\u0018\u00010u2\u0006\u0010v\u001a\u00020N2\b\b\u0002\u0010n\u001a\u00020\u0007J\u000e\u0010w\u001a\u00020\n2\u0006\u0010x\u001a\u00020^J\u001a\u0010y\u001a\u0004\u0018\u00010u2\u0006\u0010z\u001a\u00020N2\b\b\u0002\u0010n\u001a\u00020\u0007J\b\u0010{\u001a\u00020&H\u0002J5\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020U2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u00032\u0006\u0010\u007f\u001a\u00020\u00032\r\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011J(\u0010\u0081\u0001\u001a\u0011\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0082\u00012\u0007\u0010\u0083\u0001\u001a\u00020\u00032\u0007\u0010\u0084\u0001\u001a\u00020\u0003J\u0012\u0010\u0085\u0001\u001a\u0004\u0018\u00010N2\u0007\u0010\u0086\u0001\u001a\u00020\u0003J\u0012\u0010\u0087\u0001\u001a\u0004\u0018\u00010N2\u0007\u0010\u0088\u0001\u001a\u00020\u0003J/\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u00032\u0006\u0010\u007f\u001a\u00020\u00032\r\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011JE\u0010\u008b\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u008d\u0001\u001a\u00020\n2\t\b\u0002\u0010\u008e\u0001\u001a\u00020\u00072\u0007\u0010\u008f\u0001\u001a\u00020\n2\t\b\u0002\u0010\u0090\u0001\u001a\u00020\u00072\b\b\u0002\u0010g\u001a\u00020\f2\t\b\u0002\u0010\u0091\u0001\u001a\u00020\u0007J\u0007\u0010\u0092\u0001\u001a\u00020\u0003J\u0007\u0010\u0093\u0001\u001a\u00020\u0003J\u001e\u0010\u0094\u0001\u001a\u00020H2\u0006\u00106\u001a\u0002072\r\u0010\u0095\u0001\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010/R\u001c\u00100\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\u00020<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0016\u0010A\u001a\n C*\u0004\u0018\u00010B0BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010/R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"Lorg/dashj/platform/dapiclient/DapiClient;", "", "masternodeAddress", "", "dpp", "Lorg/dashj/platform/dpp/DashPlatformProtocol;", "useContextProvider", "", "isTestnet", "timeOut", "", "retries", "", "banBaseTime", "waitForNodes", "(Ljava/lang/String;Lorg/dashj/platform/dpp/DashPlatformProtocol;ZZJIII)V", "addresses", "", "(Ljava/util/List;Lorg/dashj/platform/dpp/DashPlatformProtocol;ZZJIII)V", "dapiAddressListProvider", "Lorg/dashj/platform/dapiclient/provider/DAPIAddressListProvider;", "(Lorg/dashj/platform/dapiclient/provider/DAPIAddressListProvider;Lorg/dashj/platform/dpp/DashPlatformProtocol;ZZJIII)V", "contextProvider", "Lorg/dashj/platform/sdk/callbacks/ContextProvider;", "getContextProvider", "()Lorg/dashj/platform/sdk/callbacks/ContextProvider;", "setContextProvider", "(Lorg/dashj/platform/sdk/callbacks/ContextProvider;)V", "contextProviderContext", "getContextProviderContext", "()J", "contextProviderFunction", "getContextProviderFunction", "getDapiAddressListProvider", "()Lorg/dashj/platform/dapiclient/provider/DAPIAddressListProvider;", "setDapiAddressListProvider", "(Lorg/dashj/platform/dapiclient/provider/DAPIAddressListProvider;)V", "dapiService", "Lorg/dashj/platform/dapiclient/rest/DapiService;", "debugJrpc", "debugOkHttpClient", "Lokhttp3/OkHttpClient;", "getDpp", "()Lorg/dashj/platform/dpp/DashPlatformProtocol;", "failedCalls", "fullVerification", "initializedJRPC", "()Z", "lastUsedAddress", "Lorg/dashj/platform/dapiclient/provider/DAPIAddress;", "getLastUsedAddress", "()Lorg/dashj/platform/dapiclient/provider/DAPIAddress;", "setLastUsedAddress", "(Lorg/dashj/platform/dapiclient/provider/DAPIAddress;)V", "masternodeListManager", "Lorg/bitcoinj/evolution/SimplifiedMasternodeListManager;", "retriedCalls", "retrofit", "Lretrofit2/Retrofit;", "rustSdk", "Lorg/dashj/platform/sdk/SWIGTYPE_p_DashSdk;", "getRustSdk", "()Lorg/dashj/platform/sdk/SWIGTYPE_p_DashSdk;", "setRustSdk", "(Lorg/dashj/platform/sdk/SWIGTYPE_p_DashSdk;)V", "stopWatch", "Lcom/google/common/base/Stopwatch;", "kotlin.jvm.PlatformType", "successfulCalls", "totalCalls", "getUseContextProvider", "broadcastStateTransition", "", "stateTransition", "Lorg/dashj/platform/dpp/statetransition/StateTransition;", "statusCheck", "broadcastTransaction", "txBytes", "", "allowHighFees", "bypassLimits", "broadcastVote", "Lorg/dashj/platform/dpp/voting/Vote;", "vote", "voterProTxHash", "Lorg/bitcoinj/core/Sha256Hash;", "identityPublicKey", "Lorg/dashj/platform/dpp/identity/IdentityPublicKey;", "signerCallback", "Lorg/dashj/platform/sdk/callbacks/Signer;", "deserializeDocument", "Lorg/dashj/platform/dpp/document/Document;", "serializedDocument", "dataContractId", "Lorg/dashj/platform/dpp/identifier/Identifier;", "documentType", "getBestBlockHash", "getBlockByHash", "hash", "getBlockHash", "height", "getContestedResources", "Lorg/dashj/platform/dpp/voting/ContestedResources;", "limit", "startAt", "Lorg/dashj/platform/sdk/PlatformValue;", "startAtInclude", "getDataContract", "Lorg/dashj/platform/dpp/contract/DataContract;", "contractIdByteArray", "prove", "getDocuments", "contractId", "type", "documentQuery", "Lorg/dashj/platform/dapiclient/model/DocumentQuery;", "getIdentity", "Lorg/dashj/platform/dpp/identity/Identity;", "id", "getIdentityBalance", "identifier", "getIdentityByFirstPublicKey", "pubKeyHash", "getJRPCService", "getLastVoteFromMasternode", "Lorg/dashj/platform/dpp/voting/ResourceVotesByIdentity;", "protxHash", "indexName", "indexes", "getMnListDiff", "", "baseBlockHash", "blockHash", "getTransaction", "txIdHex", "getTransactionBytes", "txHex", "getVoteContenders", "Lorg/dashj/platform/dpp/voting/Contenders;", "getVotePolls", "Lorg/dashj/platform/dpp/voting/VotePollsGroupedByTimestamp;", "startTime", "startTimeIncluded", "endTime", "endTimeIncluded", "orderAscending", "reportErrorStatus", "reportNetworkStatus", "setSimplifiedMasternodeListManager", "defaultList", "Companion"})
@SourceDebugExtension(value={"SMAP\nDapiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DapiClient.kt\norg/dashj/platform/dapiclient/DapiClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1303:1\n1549#2:1304\n1620#2,3:1305\n1549#2:1308\n1620#2,3:1309\n1549#2:1312\n1620#2,3:1313\n*S KotlinDebug\n*F\n+ 1 DapiClient.kt\norg/dashj/platform/dapiclient/DapiClient\n*L\n631#1:1304\n631#1:1305,3\n1147#1:1308\n1147#1:1309,3\n1285#1:1312\n1285#1:1313,3\n*E\n"})
public final class DapiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DAPIAddressListProvider dapiAddressListProvider;
    @NotNull
    private final DashPlatformProtocol dpp;
    private final boolean useContextProvider;
    private final boolean isTestnet;
    private long timeOut;
    private int retries;
    private int banBaseTime;
    private int waitForNodes;
    @Nullable
    private DAPIAddress lastUsedAddress;
    private Retrofit retrofit;
    private DapiService dapiService;
    @NotNull
    private final OkHttpClient debugOkHttpClient;
    private final boolean debugJrpc;
    private boolean initializedJRPC;
    private long successfulCalls;
    private long failedCalls;
    private long totalCalls;
    private long retriedCalls;
    private final Stopwatch stopWatch;
    private final boolean fullVerification;
    private SimplifiedMasternodeListManager masternodeListManager;
    @NotNull
    private ContextProvider contextProvider;
    @NotNull
    private SWIGTYPE_p_DashSdk rustSdk;
    private static final Logger logger = LoggerFactory.getLogger((String)DapiClient.class.getName());
    public static final int BLOCK_HASH_LENGTH = 64;
    public static final int DEFAULT_BASE_BAN_TIME = 60000;
    public static final int DEFAULT_RETRY_COUNT = 10;
    public static final int USE_DEFAULT_RETRY_COUNT = -1;
    public static final long DEFAULT_TIMEOUT = 5000L;
    public static final long DEFAULT_BROADCAST_TIMEOUT = 80000L;
    public static final int DEFAULT_WAIT_FOR_NODES = 5;
    public static final long DEFAULT_HTTP_TIMEOUT = 10L;
    public static final double REQUIRED_SUCCESS_RATE = 0.5;
    public static final int DEFAULT_LIMIT = 100;

    public DapiClient(@NotNull DAPIAddressListProvider dapiAddressListProvider, @NotNull DashPlatformProtocol dpp, boolean useContextProvider, boolean isTestnet, long timeOut, int retries, int banBaseTime, int waitForNodes) {
        boolean bl;
        DapiClient dapiClient;
        Intrinsics.checkNotNullParameter((Object)dapiAddressListProvider, (String)"dapiAddressListProvider");
        Intrinsics.checkNotNullParameter((Object)dpp, (String)"dpp");
        this.dapiAddressListProvider = dapiAddressListProvider;
        this.dpp = dpp;
        this.useContextProvider = useContextProvider;
        this.isTestnet = isTestnet;
        this.timeOut = timeOut;
        this.retries = retries;
        this.banBaseTime = banBaseTime;
        this.waitForNodes = waitForNodes;
        this.debugJrpc = true;
        this.stopWatch = Stopwatch.createStarted();
        this.contextProvider = new ContextProvider(this){
            final /* synthetic */ DapiClient this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public byte[] getQuorumPublicKey(int quorumType, @Nullable byte[] quorumHashBytes, int coreChainLockedHeight) {
                Sha256Hash quorumHash = Sha256Hash.wrap((byte[])quorumHashBytes);
                Ref.ObjectRef quorumPublicKey = new Ref.ObjectRef();
                DapiClient.access$getLogger$cp().info("searching for quorum: " + quorumType + ", " + quorumHash + ", " + coreChainLockedHeight);
                SimplifiedMasternodeListManager simplifiedMasternodeListManager = DapiClient.access$getMasternodeListManager$p(this.this$0);
                if (simplifiedMasternodeListManager == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"masternodeListManager");
                    simplifiedMasternodeListManager = null;
                }
                simplifiedMasternodeListManager.getQuorumListAtTip(LLMQParameters.LLMQType.fromValue((int)quorumType)).forEachQuorum(true, arg_0 -> contextProvider.1.getQuorumPublicKey$lambda$0(quorumType, quorumHash, quorumPublicKey, arg_0));
                byte[] byArray = (byte[])quorumPublicKey.element;
                DapiClient.access$getLogger$cp().info("searching for quorum: result: " + (byArray != null ? ExtensionsKt.toHex(byArray) : null));
                return (byte[])quorumPublicKey.element;
            }

            @NotNull
            public byte[] getDataContract(@Nullable org.dashj.platform.sdk.Identifier identifier) {
                byte[] byArray = new byte[]{0};
                return byArray;
            }

            private static final void getQuorumPublicKey$lambda$0(int $quorumType, Sha256Hash $quorumHash, Ref.ObjectRef $quorumPublicKey, FinalCommitment it) {
                Intrinsics.checkNotNullParameter((Object)$quorumPublicKey, (String)"$quorumPublicKey");
                if (it.getLlmqType().getValue() == $quorumType && Intrinsics.areEqual((Object)it.getQuorumHash(), (Object)$quorumHash)) {
                    $quorumPublicKey.element = it.getQuorumPublicKey().serialize(false);
                }
            }
        };
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(DapiClient::_init_$lambda$0);
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)loggingInterceptor).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();
        Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"Builder()\n            .a\u2026NDS)\n            .build()");
        this.debugOkHttpClient = okHttpClient;
        if (this.banBaseTime != 60000) {
            this.dapiAddressListProvider.setBanBaseTime(this.banBaseTime);
        }
        DapiClient dapiClient2 = this;
        try {
            dapiClient = dapiClient2;
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            dapiClient = dapiClient2;
            bl = false;
        }
        dapiClient.fullVerification = bl;
        SWIGTYPE_p_DashSdk sWIGTYPE_p_DashSdk = dashsdk.platformMobileSdkCreateDashSdkWithContext((long)this.getContextProviderContext(), (BigInteger)BigInteger.valueOf(this.getContextProviderFunction()), (BigInteger)BigInteger.ZERO, (boolean)this.isTestnet, (long)(this.timeOut * (long)2), (long)this.timeOut, (long)this.retries);
        Intrinsics.checkNotNullExpressionValue((Object)sWIGTYPE_p_DashSdk, (String)"platformMobileSdkCreateD\u2026etries.toLong()\n        )");
        this.rustSdk = sWIGTYPE_p_DashSdk;
    }

    public /* synthetic */ DapiClient(DAPIAddressListProvider dAPIAddressListProvider, DashPlatformProtocol dashPlatformProtocol, boolean bl, boolean bl2, long l, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            l = 5000L;
        }
        if ((n4 & 0x20) != 0) {
            n = 10;
        }
        if ((n4 & 0x40) != 0) {
            n2 = 60000;
        }
        if ((n4 & 0x80) != 0) {
            n3 = 5;
        }
        this(dAPIAddressListProvider, dashPlatformProtocol, bl, bl2, l, n, n2, n3);
    }

    @NotNull
    public final DAPIAddressListProvider getDapiAddressListProvider() {
        return this.dapiAddressListProvider;
    }

    public final void setDapiAddressListProvider(@NotNull DAPIAddressListProvider dAPIAddressListProvider) {
        Intrinsics.checkNotNullParameter((Object)dAPIAddressListProvider, (String)"<set-?>");
        this.dapiAddressListProvider = dAPIAddressListProvider;
    }

    @NotNull
    public final DashPlatformProtocol getDpp() {
        return this.dpp;
    }

    public final boolean getUseContextProvider() {
        return this.useContextProvider;
    }

    public final boolean isTestnet() {
        return this.isTestnet;
    }

    @Nullable
    public final DAPIAddress getLastUsedAddress() {
        return this.lastUsedAddress;
    }

    public final void setLastUsedAddress(@Nullable DAPIAddress dAPIAddress) {
        this.lastUsedAddress = dAPIAddress;
    }

    @NotNull
    public final ContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public final void setContextProvider(@NotNull ContextProvider contextProvider2) {
        Intrinsics.checkNotNullParameter((Object)contextProvider2, (String)"<set-?>");
        this.contextProvider = contextProvider2;
    }

    public final long getContextProviderFunction() {
        return this.useContextProvider ? this.contextProvider.getQuorumPublicKeyCallback() : 0L;
    }

    public final long getContextProviderContext() {
        return this.useContextProvider ? this.contextProvider.getNativeContext() : 0L;
    }

    @NotNull
    public final SWIGTYPE_p_DashSdk getRustSdk() {
        return this.rustSdk;
    }

    public final void setRustSdk(@NotNull SWIGTYPE_p_DashSdk sWIGTYPE_p_DashSdk) {
        Intrinsics.checkNotNullParameter((Object)sWIGTYPE_p_DashSdk, (String)"<set-?>");
        this.rustSdk = sWIGTYPE_p_DashSdk;
    }

    public DapiClient(@NotNull String masternodeAddress, @NotNull DashPlatformProtocol dpp, boolean useContextProvider, boolean isTestnet, long timeOut, int retries, int banBaseTime, int waitForNodes) {
        Intrinsics.checkNotNullParameter((Object)masternodeAddress, (String)"masternodeAddress");
        Intrinsics.checkNotNullParameter((Object)dpp, (String)"dpp");
        this(CollectionsKt.listOf((Object)masternodeAddress), dpp, useContextProvider, isTestnet, timeOut, retries, banBaseTime, waitForNodes);
    }

    public /* synthetic */ DapiClient(String string, DashPlatformProtocol dashPlatformProtocol, boolean bl, boolean bl2, long l, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            l = 5000L;
        }
        if ((n4 & 0x20) != 0) {
            n = 10;
        }
        if ((n4 & 0x40) != 0) {
            n2 = 60000;
        }
        if ((n4 & 0x80) != 0) {
            n3 = 5;
        }
        this(string, dashPlatformProtocol, bl, bl2, l, n, n2, n3);
    }

    public DapiClient(@NotNull List<String> addresses, @NotNull DashPlatformProtocol dpp, boolean useContextProvider, boolean isTestnet, long timeOut, int retries, int banBaseTime, int waitForNodes) {
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        Intrinsics.checkNotNullParameter((Object)dpp, (String)"dpp");
        this(ListDAPIAddressProvider.Companion.fromList(addresses, banBaseTime), dpp, useContextProvider, isTestnet, timeOut, retries, banBaseTime, waitForNodes);
    }

    public /* synthetic */ DapiClient(List list, DashPlatformProtocol dashPlatformProtocol, boolean bl, boolean bl2, long l, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            l = 5000L;
        }
        if ((n4 & 0x20) != 0) {
            n = 10;
        }
        if ((n4 & 0x40) != 0) {
            n2 = 60000;
        }
        if ((n4 & 0x80) != 0) {
            n3 = 5;
        }
        this(list, dashPlatformProtocol, bl, bl2, l, n, n2, n3);
    }

    public final void broadcastStateTransition(@NotNull StateTransition stateTransition, boolean statusCheck) {
        Intrinsics.checkNotNullParameter((Object)stateTransition, (String)"stateTransition");
        logger.info("broadcastStateTransition(" + stateTransition.toJSON() + ')');
    }

    public static /* synthetic */ void broadcastStateTransition$default(DapiClient dapiClient, StateTransition stateTransition, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        dapiClient.broadcastStateTransition(stateTransition, bl);
    }

    @Nullable
    public final Identity getIdentity(@NotNull byte[] id, boolean prove) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        logger.info("getIdentity(" + ExtensionsKt.toBase58(id) + ", " + prove + ')');
        Identifier identityId = Identifier.Companion.from(id);
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        int retriesLeft = this.retries;
        while (true) {
            Result result = dashsdk.platformMobileFetchIdentityFetchIdentityWithSdk((SWIGTYPE_p_DashSdk)this.rustSdk, (org.dashj.platform.sdk.Identifier)identityId.toNative());
            try {
                Identity identity;
                try {
                    Object t = ((Optional)result.unwrap()).get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"result.unwrap().get()");
                    identity = new Identity((org.dashj.platform.sdk.Identity)t);
                }
                catch (Exception e) {
                    identity = null;
                }
                return identity;
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"context provider error: invalid quorum: quorum not found", (boolean)false, (int)2, null) : false)) {
                    throw e;
                }
                exceptionList.add(e);
                if (--retriesLeft > 0) continue;
                throw new MaxRetriesReachedException((List<? extends Exception>)exceptionList);
            }
            break;
        }
    }

    public static /* synthetic */ Identity getIdentity$default(DapiClient dapiClient, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return dapiClient.getIdentity(byArray, bl);
    }

    @Nullable
    public final Identity getIdentityByFirstPublicKey(@NotNull byte[] pubKeyHash, boolean prove) {
        Intrinsics.checkNotNullParameter((Object)pubKeyHash, (String)"pubKeyHash");
        logger.info("getIdentityByFirstPublicKey(" + ExtensionsKt.toHex(pubKeyHash) + ')');
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        int retriesLeft = this.retries;
        while (true) {
            Result result = dashsdk.platformMobileFetchIdentityFetchIdentityWithKeyhashSdk((SWIGTYPE_p_DashSdk)this.rustSdk, (byte[])pubKeyHash);
            try {
                Identity identity;
                try {
                    Object object = result.unwrap();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.unwrap()");
                    identity = new Identity((org.dashj.platform.sdk.Identity)object);
                }
                catch (Exception e) {
                    identity = null;
                }
                return identity;
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"context provider error: invalid quorum: quorum not found", (boolean)false, (int)2, null) : false)) {
                    throw e;
                }
                exceptionList.add(e);
                if (--retriesLeft > 0) continue;
                throw new MaxRetriesReachedException((List<? extends Exception>)exceptionList);
            }
            break;
        }
    }

    public static /* synthetic */ Identity getIdentityByFirstPublicKey$default(DapiClient dapiClient, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return dapiClient.getIdentityByFirstPublicKey(byArray, bl);
    }

    @Nullable
    public final DataContract getDataContract(@NotNull byte[] contractIdByteArray, boolean prove) {
        Intrinsics.checkNotNullParameter((Object)contractIdByteArray, (String)"contractIdByteArray");
        logger.info("getDataContract(" + ExtensionsKt.toBase58(contractIdByteArray) + ')');
        Identifier contractId = Identifier.Companion.from(contractIdByteArray);
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        int retriesLeft = this.retries;
        while (true) {
            Result dataContractResult = dashsdk.platformMobileDataContractsFetchDataContract((SWIGTYPE_p_DashSdk)this.rustSdk, (org.dashj.platform.sdk.Identifier)contractId.toNative());
            try {
                DataContract dataContract;
                try {
                    Object t = ((Optional)dataContractResult.unwrap()).get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"dataContractResult.unwrap().get()");
                    dataContract = DataContract.DEFAULTS.from((org.dashj.platform.sdk.DataContract)t);
                }
                catch (Exception e) {
                    dataContract = null;
                }
                return dataContract;
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"context provider error: invalid quorum: quorum not found", (boolean)false, (int)2, null) : false)) {
                    logger.error("get data contract error", (Throwable)e);
                    throw new NotFoundException("DataContract " + ExtensionsKt.toBase58(contractIdByteArray) + " not found");
                }
                exceptionList.add(e);
                logger.error("get data contract error", (Throwable)e);
                if (--retriesLeft > 0) continue;
                throw new MaxRetriesReachedException((List<? extends Exception>)exceptionList);
            }
            break;
        }
    }

    public static /* synthetic */ DataContract getDataContract$default(DapiClient dapiClient, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return dapiClient.getDataContract(byArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<org.dashj.platform.dpp.document.Document> getDocuments(@NotNull byte[] contractId, @NotNull String type, @NotNull DocumentQuery documentQuery, boolean prove) {
        Start start;
        Intrinsics.checkNotNullParameter((Object)contractId, (String)"contractId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)documentQuery, (String)"documentQuery");
        Object[] objectArray = new Object[]{ExtensionsKt.toBase58(contractId), type, documentQuery};
        logger.info("getDocuments(contractId={}, type={}, {})", objectArray);
        Identifier contractIdentifier = new Identifier(contractId);
        org.dashj.platform.sdk.Identifier rustContractIdentifier = contractIdentifier.toNative();
        if (documentQuery.getStartAt() != null) {
            Identifier identifier = documentQuery.getStartAt();
            Intrinsics.checkNotNull((Object)identifier);
            start = new Start(identifier.toBuffer(), true);
        } else if (documentQuery.getStartAfter() != null) {
            Identifier identifier = documentQuery.getStartAfter();
            Intrinsics.checkNotNull((Object)identifier);
            start = new Start(identifier.toBuffer(), false);
        } else {
            start = null;
        }
        Start start2 = start;
        int retriesLeft = 10;
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        while (true) {
            Result result = dashsdk.platformMobileFetchDocumentFetchDocumentsWithQueryAndSdk((SWIGTYPE_p_DashSdk)this.rustSdk, (org.dashj.platform.sdk.Identifier)rustContractIdentifier, (String)type, documentQuery.encodeWhere(), documentQuery.encodeOrderBy(), (long)(documentQuery.getLimit() == -1 ? 100L : (long)documentQuery.getLimit()), (Start)start2);
            try {
                void $this$mapTo$iv$iv;
                Object object = result.unwrap();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.unwrap()");
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Document document = (Document)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(new org.dashj.platform.dpp.document.Document((Document)it, contractIdentifier));
                }
                return (List)destination$iv$iv;
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"context provider error: invalid quorum: quorum not found", (boolean)false, (int)2, null) : false)) {
                    throw e;
                }
                exceptionList.add(e);
                if (--retriesLeft > 0) continue;
                throw new MaxRetriesReachedException((List<? extends Exception>)exceptionList);
            }
            break;
        }
    }

    public static /* synthetic */ List getDocuments$default(DapiClient dapiClient, byte[] byArray, String string, DocumentQuery documentQuery, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return dapiClient.getDocuments(byArray, string, documentQuery, bl);
    }

    @Nullable
    public final byte[] getBlockByHash(@NotNull String hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return new byte[80];
    }

    @NotNull
    public final String broadcastTransaction(@NotNull byte[] txBytes, boolean allowHighFees, boolean bypassLimits) {
        Intrinsics.checkNotNullParameter((Object)txBytes, (String)"txBytes");
        return "";
    }

    public static /* synthetic */ String broadcastTransaction$default(DapiClient dapiClient, byte[] byArray, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return dapiClient.broadcastTransaction(byArray, bl, bl2);
    }

    @Nullable
    public final byte[] getTransactionBytes(@NotNull String txHex) {
        Intrinsics.checkNotNullParameter((Object)txHex, (String)"txHex");
        logger.info("getTransaction(" + txHex + ')');
        try {
            Result_ok_Vec_u8_err_String transactionResult = dashsdk.platformMobileCoreGetTransactionSdk((SWIGTYPE_p_DashSdk)this.rustSdk, (byte[])Converters.fromHex(txHex));
            return transactionResult.getOk();
        }
        catch (NullPointerException e) {
            logger.error("transaction " + txHex + " not found:", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public final byte[] getTransaction(@NotNull String txIdHex) {
        Intrinsics.checkNotNullParameter((Object)txIdHex, (String)"txIdHex");
        logger.info("getTransaction(" + txIdHex + ')');
        return this.getTransactionBytes(txIdHex);
    }

    @Nullable
    public final String getBestBlockHash() {
        logger.info("getBestBlockHash(): jRPC");
        DapiService service = this.getJRPCService();
        Response response = service.getBestBlockHash(new JsonRPCRequest<Map<String, String>>("getBestBlockHash", MapsKt.emptyMap(), null, null, 12, null)).execute();
        if (response.isSuccessful()) {
            Object object = response.body();
            Intrinsics.checkNotNull((Object)object);
            return (String)((JsonRPCResponse)object).getResult();
        }
        throw new ResponseException(response.code(), String.valueOf(response.errorBody()));
    }

    @Nullable
    public final String getBlockHash(int height) {
        logger.info("getBlockHash(): jRPC");
        DapiService service = this.getJRPCService();
        Map parameters = MapsKt.mapOf((Pair)TuplesKt.to((Object)"height", (Object)height));
        Response response = service.getBlockHash(new JsonRPCRequest<Map<String, Integer>>("getBlockHash", parameters, null, null, 12, null)).execute();
        if (response.isSuccessful()) {
            Object object = response.body();
            Intrinsics.checkNotNull((Object)object);
            return (String)((JsonRPCResponse)object).getResult();
        }
        throw new ResponseException(response.code(), String.valueOf(response.errorBody()));
    }

    @Nullable
    public final Map<String, Object> getMnListDiff(@NotNull String baseBlockHash, @NotNull String blockHash) {
        Intrinsics.checkNotNullParameter((Object)baseBlockHash, (String)"baseBlockHash");
        Intrinsics.checkNotNullParameter((Object)blockHash, (String)"blockHash");
        logger.info("getMnListDiff(): jRPC");
        DapiService service = this.getJRPCService();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"baseBlockHash", (Object)baseBlockHash), TuplesKt.to((Object)"blockHash", (Object)blockHash)};
        Map parameters = MapsKt.mapOf((Pair[])pairArray);
        Response response = service.getMnListDiff(new JsonRPCRequest<Map<String, String>>("getMnListDiff", parameters, null, null, 12, null)).execute();
        if (response.isSuccessful()) {
            Object object = response.body();
            Intrinsics.checkNotNull((Object)object);
            return (Map)((JsonRPCResponse)object).getResult();
        }
        throw new ResponseException(response.code(), String.valueOf(response.errorBody()));
    }

    private final DapiService getJRPCService() {
        if (this.initializedJRPC) {
            DapiService dapiService = this.dapiService;
            if (dapiService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dapiService");
                dapiService = null;
            }
            return dapiService;
        }
        String mnIP = this.dapiAddressListProvider.getLiveAddress().getHost();
        logger.info("Connecting to GRPC host: " + mnIP + ":1443");
        Retrofit retrofit = new Retrofit.Builder().addConverterFactory((Converter.Factory)GsonConverterFactory.create()).baseUrl("https://" + mnIP + ":1443/").client(this.debugJrpc ? this.debugOkHttpClient : new OkHttpClient()).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"Builder()\n            .a\u2026t())\n            .build()");
        this.retrofit = retrofit;
        Retrofit retrofit2 = this.retrofit;
        if (retrofit2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"retrofit");
            retrofit2 = null;
        }
        Object object = retrofit2.create(DapiService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"retrofit.create(DapiService::class.java)");
        this.dapiService = (DapiService)object;
        DapiService dapiService = this.dapiService;
        if (dapiService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dapiService");
            dapiService = null;
        }
        return dapiService;
    }

    public final void setSimplifiedMasternodeListManager(@NotNull SimplifiedMasternodeListManager masternodeListManager, @NotNull List<String> defaultList) {
        Intrinsics.checkNotNullParameter((Object)masternodeListManager, (String)"masternodeListManager");
        Intrinsics.checkNotNullParameter(defaultList, (String)"defaultList");
        this.masternodeListManager = masternodeListManager;
        this.dapiAddressListProvider = new SimplifiedMasternodeListDAPIAddressProvider(masternodeListManager, ListDAPIAddressProvider.Companion.fromList(defaultList, 60000));
    }

    @NotNull
    public final String reportNetworkStatus() {
        return "DapiClient Network Status\n---DAPI Call Statistics (" + this.stopWatch + ")\n   successful: " + this.successfulCalls + "\n   retried   : " + this.retriedCalls + "\n   failure   : " + this.failedCalls + "\n   total     : " + this.totalCalls + " (calls per minute: " + (double)this.totalCalls / (double)this.stopWatch.elapsed(TimeUnit.MINUTES) + "\n   retried % : " + (double)this.retriedCalls / (double)this.successfulCalls * (double)100 + "%\n   success % : " + (double)this.successfulCalls / (double)this.totalCalls * (double)100 + "%\n---Masternode Information\n" + this.dapiAddressListProvider.getStatistics();
    }

    @NotNull
    public final String reportErrorStatus() {
        return this.dapiAddressListProvider.getErrorStatistics();
    }

    public final long getIdentityBalance(@NotNull Identifier identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        logger.info("getIdentityBalance({})", (Object)identifier);
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        int retriesLeft = this.retries;
        while (true) {
            Result result = dashsdk.platformMobileFetchIdentityFetchIdentityBalanceWithSdk((SWIGTYPE_p_DashSdk)this.rustSdk, (org.dashj.platform.sdk.Identifier)identifier.toNative());
            try {
                Object object = result.unwrap();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.unwrap()");
                return ((Number)object).longValue();
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"context provider error: invalid quorum: quorum not found", (boolean)false, (int)2, null) : false)) {
                    throw e;
                }
                exceptionList.add(e);
                if (--retriesLeft > 0) continue;
                throw new MaxRetriesReachedException((List<? extends Exception>)exceptionList);
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final org.dashj.platform.dpp.voting.Contenders getVoteContenders(@NotNull Identifier dataContractId, @NotNull String documentType, @NotNull String indexName, @NotNull List<String> indexes) {
        Intrinsics.checkNotNullParameter((Object)dataContractId, (String)"dataContractId");
        Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
        Object[] objectArray = new Object[]{dataContractId, documentType, indexName, indexes};
        logger.info("getVoteContenders({}, {}, {}, {})", objectArray);
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        int retriesLeft = this.retries;
        while (true) {
            Collection<PlatformValue> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = indexes;
            String string = indexName;
            SWIGTYPE_p_DashSdk sWIGTYPE_p_DashSdk = this.rustSdk;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PlatformValue((String)it));
            }
            collection = (List)destination$iv$iv;
            Result result = dashsdk.platformMobileVotingGetVoteContenders((SWIGTYPE_p_DashSdk)sWIGTYPE_p_DashSdk, (String)string, (List)collection, (String)documentType, (org.dashj.platform.sdk.Identifier)dataContractId.toNative());
            try {
                Object object = result.unwrap();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.unwrap()");
                return new org.dashj.platform.dpp.voting.Contenders((Contenders)object);
            }
            catch (Exception e) {
                String string3 = e.getMessage();
                if (!(string3 != null ? StringsKt.contains$default((CharSequence)string3, (CharSequence)"context provider error: invalid quorum: quorum not found", (boolean)false, (int)2, null) : false)) {
                    throw e;
                }
                exceptionList.add(e);
                if (--retriesLeft > 0) continue;
                throw new MaxRetriesReachedException((List<? extends Exception>)exceptionList);
            }
            break;
        }
    }

    @NotNull
    public final org.dashj.platform.dpp.voting.ContestedResources getContestedResources(@NotNull Identifier dataContractId, @NotNull String documentType, int limit, @Nullable PlatformValue startAt, boolean startAtInclude) {
        Intrinsics.checkNotNullParameter((Object)dataContractId, (String)"dataContractId");
        Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
        Object[] objectArray = new Object[]{dataContractId, documentType, limit};
        logger.info("getContestedResources({}, {}, {}, ...)", objectArray);
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        int retriesLeft = this.retries;
        while (true) {
            Result result = dashsdk.platformMobileVotingGetContestedResources((SWIGTYPE_p_DashSdk)this.rustSdk, (String)documentType, (org.dashj.platform.sdk.Identifier)dataContractId.toNative(), (int)limit, (PlatformValue)startAt, (boolean)startAtInclude);
            try {
                Object object = result.unwrap();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.unwrap()");
                return new org.dashj.platform.dpp.voting.ContestedResources((ContestedResources)object);
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"context provider error: invalid quorum: quorum not found", (boolean)false, (int)2, null) : false)) {
                    throw e;
                }
                exceptionList.add(e);
                if (--retriesLeft > 0) continue;
                throw new MaxRetriesReachedException((List<? extends Exception>)exceptionList);
            }
            break;
        }
    }

    public static /* synthetic */ org.dashj.platform.dpp.voting.ContestedResources getContestedResources$default(DapiClient dapiClient, Identifier identifier, String string, int n, PlatformValue platformValue, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 100;
        }
        if ((n2 & 8) != 0) {
            platformValue = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        return dapiClient.getContestedResources(identifier, string, n, platformValue, bl);
    }

    @NotNull
    public final org.dashj.platform.dpp.document.Document deserializeDocument(@NotNull byte[] serializedDocument, @NotNull Identifier dataContractId, @NotNull String documentType) {
        Intrinsics.checkNotNullParameter((Object)serializedDocument, (String)"serializedDocument");
        Intrinsics.checkNotNullParameter((Object)dataContractId, (String)"dataContractId");
        Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
        Object object = dashsdk.platformMobileFetchDocumentDeserializeDocumentSdk((SWIGTYPE_p_DashSdk)this.rustSdk, (byte[])serializedDocument, (org.dashj.platform.sdk.Identifier)dataContractId.toNative(), (String)documentType).unwrap();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"platformMobileFetchDocum\u2026pe\n            ).unwrap()");
        return new org.dashj.platform.dpp.document.Document((Document)object, dataContractId);
    }

    @NotNull
    public final Vote broadcastVote(@NotNull Vote vote, @NotNull Sha256Hash voterProTxHash, @NotNull IdentityPublicKey identityPublicKey, @NotNull Signer signerCallback) {
        Intrinsics.checkNotNullParameter((Object)vote, (String)"vote");
        Intrinsics.checkNotNullParameter((Object)voterProTxHash, (String)"voterProTxHash");
        Intrinsics.checkNotNullParameter((Object)identityPublicKey, (String)"identityPublicKey");
        Intrinsics.checkNotNullParameter((Object)signerCallback, (String)"signerCallback");
        logger.info("broadcastVote(" + vote + ", " + voterProTxHash + ", " + identityPublicKey + ", ...)");
        org.dashj.platform.sdk.Vote vote2 = vote.toNative();
        byte[] byArray = voterProTxHash.getBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"voterProTxHash.bytes");
        Result result = dashsdk.platformMobileVotingPutVoteToPlatform((SWIGTYPE_p_DashSdk)this.rustSdk, (org.dashj.platform.sdk.Vote)vote2, (org.dashj.platform.sdk.Identifier)Identifier.Companion.from(byArray).toNative(), (org.dashj.platform.sdk.IdentityPublicKey)identityPublicKey.toNative(), (long)signerCallback.getNativeContext(), (BigInteger)BigInteger.valueOf(signerCallback.getSignerCallback()));
        Object object = result.unwrap();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.unwrap()");
        return new Vote((org.dashj.platform.sdk.Vote)object);
    }

    @NotNull
    public final VotePollsGroupedByTimestamp getVotePolls(long startTime, boolean startTimeIncluded, long endTime, boolean endTimeIncluded, int limit, boolean orderAscending) {
        logger.info("getVotePolls(" + startTime + ", " + endTime + ", " + limit + ", " + orderAscending + ')');
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        int retriesLeft = this.retries;
        while (true) {
            Result result = dashsdk.platformMobileVotingGetVotePolls((SWIGTYPE_p_DashSdk)this.rustSdk, (TimestampMillis)ExtensionsKt.toTimestampMillis(startTime), (boolean)startTimeIncluded, (TimestampMillis)ExtensionsKt.toTimestampMillis(endTime), (boolean)endTimeIncluded, (int)limit, (int)0, (boolean)orderAscending);
            try {
                Object object = result.unwrap();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.unwrap()");
                return new VotePollsGroupedByTimestamp((VotePollsGroupedByTimeStamp)object);
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"context provider error: invalid quorum: quorum not found", (boolean)false, (int)2, null) : false)) {
                    throw e;
                }
                exceptionList.add(e);
                if (--retriesLeft > 0) continue;
                throw new MaxRetriesReachedException((List<? extends Exception>)exceptionList);
            }
            break;
        }
    }

    public static /* synthetic */ VotePollsGroupedByTimestamp getVotePolls$default(DapiClient dapiClient, long l, boolean bl, long l2, boolean bl2, int n, boolean bl3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x10) != 0) {
            n = 100;
        }
        if ((n2 & 0x20) != 0) {
            bl3 = true;
        }
        return dapiClient.getVotePolls(l, bl, l2, bl2, n, bl3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ResourceVotesByIdentity getLastVoteFromMasternode(@NotNull Sha256Hash protxHash, @NotNull Identifier dataContractId, @NotNull String documentType, @NotNull String indexName, @NotNull List<String> indexes) {
        Intrinsics.checkNotNullParameter((Object)protxHash, (String)"protxHash");
        Intrinsics.checkNotNullParameter((Object)dataContractId, (String)"dataContractId");
        Intrinsics.checkNotNullParameter((Object)documentType, (String)"documentType");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter(indexes, (String)"indexes");
        Object[] objectArray = new Object[]{protxHash, dataContractId, documentType, indexName, indexes};
        logger.info("getLastVoteFromMasternode({}, {}, {}, {}, {})", objectArray);
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        int retriesLeft = this.retries;
        while (true) {
            Collection<PlatformValue> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = indexes;
            String string = indexName;
            org.dashj.platform.sdk.Identifier identifier = Identifier.Companion.from(protxHash).toNative();
            SWIGTYPE_p_DashSdk sWIGTYPE_p_DashSdk = this.rustSdk;
            boolean $i$f$map = false;
            void var11_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PlatformValue((String)it));
            }
            collection = (List)destination$iv$iv;
            Result result = dashsdk.platformMobileVotingGetLastVoteFromMasternode((SWIGTYPE_p_DashSdk)sWIGTYPE_p_DashSdk, (org.dashj.platform.sdk.Identifier)identifier, (String)string, (List)collection, (String)documentType, (org.dashj.platform.sdk.Identifier)dataContractId.toNative());
            try {
                Object object = result.unwrap();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result.unwrap()");
                return new ResourceVotesByIdentity((org.dashj.platform.sdk.ResourceVotesByIdentity)object);
            }
            catch (Exception e) {
                String string3 = e.getMessage();
                if (!(string3 != null ? StringsKt.contains$default((CharSequence)string3, (CharSequence)"context provider error: invalid quorum: quorum not found", (boolean)false, (int)2, null) : false)) {
                    throw e;
                }
                exceptionList.add(e);
                if (--retriesLeft > 0) continue;
                throw new MaxRetriesReachedException((List<? extends Exception>)exceptionList);
            }
            break;
        }
    }

    private static final void _init_$lambda$0(String msg) {
        logger.info(msg);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ SimplifiedMasternodeListManager access$getMasternodeListManager$p(DapiClient $this) {
        return $this.masternodeListManager;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/dashj/platform/dapiclient/DapiClient$Companion;", "", "()V", "BLOCK_HASH_LENGTH", "", "DEFAULT_BASE_BAN_TIME", "DEFAULT_BROADCAST_TIMEOUT", "", "DEFAULT_HTTP_TIMEOUT", "DEFAULT_LIMIT", "DEFAULT_RETRY_COUNT", "DEFAULT_TIMEOUT", "DEFAULT_WAIT_FOR_NODES", "REQUIRED_SUCCESS_RATE", "", "USE_DEFAULT_RETRY_COUNT", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

