/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dapiclient.model;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bitcoinj.core.Sha256Hash;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001d\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\t\u0010$\u001a\u00020\u000eH\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003JY\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\nH\u00c6\u0001J\u0013\u0010'\u001a\u00020\u000e2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u0005H\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018\u00a8\u0006+"}, d2={"Lorg/dashj/platform/dapiclient/model/Chain;", "", "name", "", "headerCount", "", "blockCount", "bestBlockHash", "Lorg/bitcoinj/core/Sha256Hash;", "difficulty", "", "chainWork", "", "isSynced", "", "syncProgress", "(Ljava/lang/String;IILorg/bitcoinj/core/Sha256Hash;D[BZD)V", "getBestBlockHash", "()Lorg/bitcoinj/core/Sha256Hash;", "getBlockCount", "()I", "getChainWork", "()[B", "getDifficulty", "()D", "getHeaderCount", "()Z", "getName", "()Ljava/lang/String;", "getSyncProgress", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "dpp"})
public final class Chain {
    @NotNull
    private final String name;
    private final int headerCount;
    private final int blockCount;
    @NotNull
    private final Sha256Hash bestBlockHash;
    private final double difficulty;
    @NotNull
    private final byte[] chainWork;
    private final boolean isSynced;
    private final double syncProgress;

    public Chain(@NotNull String name, int headerCount, int blockCount, @NotNull Sha256Hash bestBlockHash, double difficulty, @NotNull byte[] chainWork, boolean isSynced, double syncProgress) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bestBlockHash, (String)"bestBlockHash");
        Intrinsics.checkNotNullParameter((Object)chainWork, (String)"chainWork");
        this.name = name;
        this.headerCount = headerCount;
        this.blockCount = blockCount;
        this.bestBlockHash = bestBlockHash;
        this.difficulty = difficulty;
        this.chainWork = chainWork;
        this.isSynced = isSynced;
        this.syncProgress = syncProgress;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getHeaderCount() {
        return this.headerCount;
    }

    public final int getBlockCount() {
        return this.blockCount;
    }

    @NotNull
    public final Sha256Hash getBestBlockHash() {
        return this.bestBlockHash;
    }

    public final double getDifficulty() {
        return this.difficulty;
    }

    @NotNull
    public final byte[] getChainWork() {
        return this.chainWork;
    }

    public final boolean isSynced() {
        return this.isSynced;
    }

    public final double getSyncProgress() {
        return this.syncProgress;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final int component2() {
        return this.headerCount;
    }

    public final int component3() {
        return this.blockCount;
    }

    @NotNull
    public final Sha256Hash component4() {
        return this.bestBlockHash;
    }

    public final double component5() {
        return this.difficulty;
    }

    @NotNull
    public final byte[] component6() {
        return this.chainWork;
    }

    public final boolean component7() {
        return this.isSynced;
    }

    public final double component8() {
        return this.syncProgress;
    }

    @NotNull
    public final Chain copy(@NotNull String name, int headerCount, int blockCount, @NotNull Sha256Hash bestBlockHash, double difficulty, @NotNull byte[] chainWork, boolean isSynced, double syncProgress) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bestBlockHash, (String)"bestBlockHash");
        Intrinsics.checkNotNullParameter((Object)chainWork, (String)"chainWork");
        return new Chain(name, headerCount, blockCount, bestBlockHash, difficulty, chainWork, isSynced, syncProgress);
    }

    public static /* synthetic */ Chain copy$default(Chain chain, String string, int n, int n2, Sha256Hash sha256Hash, double d, byte[] byArray, boolean bl, double d2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = chain.name;
        }
        if ((n3 & 2) != 0) {
            n = chain.headerCount;
        }
        if ((n3 & 4) != 0) {
            n2 = chain.blockCount;
        }
        if ((n3 & 8) != 0) {
            sha256Hash = chain.bestBlockHash;
        }
        if ((n3 & 0x10) != 0) {
            d = chain.difficulty;
        }
        if ((n3 & 0x20) != 0) {
            byArray = chain.chainWork;
        }
        if ((n3 & 0x40) != 0) {
            bl = chain.isSynced;
        }
        if ((n3 & 0x80) != 0) {
            d2 = chain.syncProgress;
        }
        return chain.copy(string, n, n2, sha256Hash, d, byArray, bl, d2);
    }

    @NotNull
    public String toString() {
        return "Chain(name=" + this.name + ", headerCount=" + this.headerCount + ", blockCount=" + this.blockCount + ", bestBlockHash=" + this.bestBlockHash + ", difficulty=" + this.difficulty + ", chainWork=" + Arrays.toString(this.chainWork) + ", isSynced=" + this.isSynced + ", syncProgress=" + this.syncProgress + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + Integer.hashCode(this.headerCount);
        result = result * 31 + Integer.hashCode(this.blockCount);
        result = result * 31 + this.bestBlockHash.hashCode();
        result = result * 31 + Double.hashCode(this.difficulty);
        result = result * 31 + Arrays.hashCode(this.chainWork);
        int n = this.isSynced ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + Double.hashCode(this.syncProgress);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Chain)) {
            return false;
        }
        Chain chain = (Chain)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)chain.name)) {
            return false;
        }
        if (this.headerCount != chain.headerCount) {
            return false;
        }
        if (this.blockCount != chain.blockCount) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bestBlockHash, (Object)chain.bestBlockHash)) {
            return false;
        }
        if (Double.compare(this.difficulty, chain.difficulty) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.chainWork, (Object)chain.chainWork)) {
            return false;
        }
        if (this.isSynced != chain.isSynced) {
            return false;
        }
        return Double.compare(this.syncProgress, chain.syncProgress) == 0;
    }
}

