/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dapiclient.provider;

import io.grpc.Status;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bitcoinj.core.Sha256Hash;
import org.dashj.platform.dapiclient.model.GetStatusResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 52\u00020\u0001:\u00015B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rJ\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u001bJ\u0006\u00102\u001a\u000200J\u0006\u00103\u001a\u000200J\b\u00104\u001a\u00020\u0003H\u0016R\u001a\u0010\u000e\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R-\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000b0\u001aj\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000b`\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0010R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u00066"}, d2={"Lorg/dashj/platform/dapiclient/provider/DAPIAddress;", "", "host", "", "proRegTxHash", "Lorg/bitcoinj/core/Sha256Hash;", "(Ljava/lang/String;Lorg/bitcoinj/core/Sha256Hash;)V", "address", "(Lorg/dashj/platform/dapiclient/provider/DAPIAddress;)V", "(Ljava/lang/String;)V", "httpPort", "", "grpcPort", "(Ljava/lang/String;IILorg/bitcoinj/core/Sha256Hash;)V", "banCount", "getBanCount", "()I", "setBanCount", "(I)V", "banStartTime", "", "getBanStartTime", "()J", "setBanStartTime", "(J)V", "exception", "Ljava/util/HashMap;", "Lio/grpc/Status$Code;", "Lkotlin/collections/HashMap;", "getException", "()Ljava/util/HashMap;", "getGrpcPort", "getHost", "()Ljava/lang/String;", "setHost", "getHttpPort", "isBanned", "", "()Z", "lastStatus", "Lorg/dashj/platform/dapiclient/model/GetStatusResponse;", "getLastStatus", "()Lorg/dashj/platform/dapiclient/model/GetStatusResponse;", "setLastStatus", "(Lorg/dashj/platform/dapiclient/model/GetStatusResponse;)V", "getProRegTxHash", "()Lorg/bitcoinj/core/Sha256Hash;", "addException", "", "code", "markAsBanned", "markAsLive", "toString", "Companion", "dpp"})
public final class DAPIAddress {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String host;
    private final int httpPort;
    private final int grpcPort;
    @NotNull
    private final Sha256Hash proRegTxHash;
    private int banCount;
    private long banStartTime;
    @Nullable
    private GetStatusResponse lastStatus;
    @NotNull
    private final HashMap<Status.Code, Integer> exception;
    public static final int DEFAULT_JRPC_PORT = 1443;
    public static final int DEFAULT_GRPC_PORT = 1443;

    public DAPIAddress(@NotNull String host, int httpPort, int grpcPort, @NotNull Sha256Hash proRegTxHash) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)proRegTxHash, (String)"proRegTxHash");
        this.host = host;
        this.httpPort = httpPort;
        this.grpcPort = grpcPort;
        this.proRegTxHash = proRegTxHash;
        this.banStartTime = -1L;
        this.exception = new HashMap();
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getHttpPort() {
        return this.httpPort;
    }

    public final int getGrpcPort() {
        return this.grpcPort;
    }

    @NotNull
    public final Sha256Hash getProRegTxHash() {
        return this.proRegTxHash;
    }

    public final int getBanCount() {
        return this.banCount;
    }

    public final void setBanCount(int n) {
        this.banCount = n;
    }

    public final long getBanStartTime() {
        return this.banStartTime;
    }

    public final void setBanStartTime(long l) {
        this.banStartTime = l;
    }

    @Nullable
    public final GetStatusResponse getLastStatus() {
        return this.lastStatus;
    }

    public final void setLastStatus(@Nullable GetStatusResponse getStatusResponse) {
        this.lastStatus = getStatusResponse;
    }

    @NotNull
    public final HashMap<Status.Code, Integer> getException() {
        return this.exception;
    }

    public DAPIAddress(@NotNull String host, @NotNull Sha256Hash proRegTxHash) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)proRegTxHash, (String)"proRegTxHash");
        this(host, 1443, 1443, proRegTxHash);
    }

    public DAPIAddress(@NotNull DAPIAddress address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this(address.host, address.httpPort, address.grpcPort, address.proRegTxHash);
    }

    public DAPIAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Sha256Hash sha256Hash = Sha256Hash.ZERO_HASH;
        Intrinsics.checkNotNullExpressionValue((Object)sha256Hash, (String)"ZERO_HASH");
        this(address, 1443, 1443, sha256Hash);
    }

    public final void markAsBanned() {
        int n = this.banCount;
        this.banCount = n + 1;
        this.banStartTime = new Date().getTime();
    }

    public final void markAsLive() {
        this.banCount = 0;
        this.banStartTime = -1L;
    }

    public final boolean isBanned() {
        return this.banCount > 0;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("DAPIAddress(" + this.host + ':' + this.httpPort + '/' + this.grpcPort);
        if (!Intrinsics.areEqual((Object)this.proRegTxHash, (Object)Sha256Hash.ZERO_HASH)) {
            sb.append("proRegTxHash: " + this.proRegTxHash);
        }
        sb.append(")");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public final void addException(@NotNull Status.Code code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        if (this.exception.containsKey(code)) {
            Map map = this.exception;
            Integer n = this.exception.get(code);
            Intrinsics.checkNotNull((Object)n);
            map.put(code, ((Number)n).intValue() + 1);
        } else {
            ((Map)this.exception).put(code, 1);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/dashj/platform/dapiclient/provider/DAPIAddress$Companion;", "", "()V", "DEFAULT_GRPC_PORT", "", "DEFAULT_JRPC_PORT", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

