/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dapiclient.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dashj.platform.dapiclient.provider.DAPIAddress;
import org.dashj.platform.dapiclient.provider.DAPIAddressListProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0001&B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0006H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/dashj/platform/dapiclient/provider/ListDAPIAddressProvider;", "Lorg/dashj/platform/dapiclient/provider/DAPIAddressListProvider;", "addresses", "", "Lorg/dashj/platform/dapiclient/provider/DAPIAddress;", "baseBanTime", "", "(Ljava/util/List;I)V", "getAddresses", "()Ljava/util/List;", "setAddresses", "(Ljava/util/List;)V", "alwaysBanAddresses", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getBaseBanTime", "()I", "setBaseBanTime", "(I)V", "random", "Ljava/util/Random;", "whiteList", "addAcceptedAddress", "", "address", "addBannedAddress", "getAllAddresses", "getErrorStatistics", "getLiveAddress", "getLiveAddresses", "getStatistics", "hasLiveAddresses", "", "sample", "setBanBaseTime", "banBaseTime", "toList", "Companion", "dpp"})
@SourceDebugExtension(value={"SMAP\nListDAPIAddressProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListDAPIAddressProvider.kt\norg/dashj/platform/dapiclient/provider/ListDAPIAddressProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n766#2:97\n857#2,2:98\n766#2:100\n857#2,2:101\n1855#2,2:103\n766#2:105\n857#2,2:106\n1549#2:108\n1620#2,3:109\n*S KotlinDebug\n*F\n+ 1 ListDAPIAddressProvider.kt\norg/dashj/platform/dapiclient/provider/ListDAPIAddressProvider\n*L\n41#1:97\n41#1:98,2\n78#1:100\n78#1:101,2\n80#1:103,2\n89#1:105\n89#1:106,2\n89#1:108\n89#1:109,3\n*E\n"})
public final class ListDAPIAddressProvider
implements DAPIAddressListProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<DAPIAddress> addresses;
    private int baseBanTime;
    @NotNull
    private final Random random;
    @NotNull
    private final ArrayList<String> alwaysBanAddresses;
    @NotNull
    private final ArrayList<String> whiteList;

    public ListDAPIAddressProvider(@NotNull List<DAPIAddress> addresses, int baseBanTime) {
        Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
        this.addresses = addresses;
        this.baseBanTime = baseBanTime;
        this.random = new Random();
        this.alwaysBanAddresses = new ArrayList();
        this.whiteList = new ArrayList();
    }

    @NotNull
    public final List<DAPIAddress> getAddresses() {
        return this.addresses;
    }

    public final void setAddresses(@NotNull List<DAPIAddress> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.addresses = list;
    }

    public final int getBaseBanTime() {
        return this.baseBanTime;
    }

    public final void setBaseBanTime(int n) {
        this.baseBanTime = n;
    }

    @Override
    @NotNull
    public DAPIAddress getLiveAddress() {
        List<DAPIAddress> liveAddresses = this.getLiveAddresses();
        return this.sample(liveAddresses);
    }

    @Override
    public boolean hasLiveAddresses() {
        return !((Collection)this.getLiveAddresses()).isEmpty();
    }

    @NotNull
    public final List<DAPIAddress> getAllAddresses() {
        return this.addresses;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DAPIAddress> getLiveAddresses() {
        void $this$filterTo$iv$iv;
        long now = new Date().getTime();
        Iterable $this$filter$iv = this.addresses;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            DAPIAddress it = (DAPIAddress)element$iv$iv;
            boolean bl2 = false;
            if (this.alwaysBanAddresses.contains(it.getHost())) {
                bl = false;
            } else if (!((Collection)this.whiteList).isEmpty() && !this.whiteList.contains(it.getHost())) {
                bl = false;
            } else if (!it.isBanned()) {
                bl = true;
            } else {
                double coefficient = Math.exp((double)it.getBanCount() - 1.0);
                double banPeriod = Math.floor(coefficient) * (double)this.baseBanTime;
                bl = (double)now > (double)it.getBanStartTime() + banPeriod;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final DAPIAddress sample(List<DAPIAddress> addresses) {
        if (addresses.isEmpty()) {
            throw new IllegalStateException("There are no live addresses from which to get a node");
        }
        return addresses.get(this.random.nextInt(addresses.size()));
    }

    @Override
    public void addBannedAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.alwaysBanAddresses.add(address);
    }

    @Override
    public void addAcceptedAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.whiteList.add(address);
    }

    @Override
    public void setBanBaseTime(int banBaseTime) {
        this.baseBanTime = banBaseTime;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getStatistics() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.addresses;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DAPIAddress it = (DAPIAddress)element$iv$iv;
            boolean bl = false;
            if (!it.isBanned()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List currentlyBanned = (List)destination$iv$iv;
        StringBuffer sb = new StringBuffer();
        Iterable $this$forEach$iv = currentlyBanned;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DAPIAddress it = (DAPIAddress)element$iv;
            boolean bl = false;
            sb.append(it.getException());
        }
        return "  ---always banned addresses: " + this.alwaysBanAddresses + "\ntotal masternodes          : " + this.addresses.size() + "\ntotal banned nodes         : " + currentlyBanned.size() + "\n                             " + currentlyBanned + '\n' + sb;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getErrorStatistics() {
        void $this$mapTo$iv$iv;
        DAPIAddress it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.addresses;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DAPIAddress)element$iv$iv;
            boolean bl = false;
            if (!it.isBanned()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DAPIAddress)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getException());
        }
        return ((List)destination$iv$iv).toString();
    }

    @Override
    @NotNull
    public List<DAPIAddress> toList() {
        return this.addresses;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/dashj/platform/dapiclient/provider/ListDAPIAddressProvider$Companion;", "", "()V", "fromList", "Lorg/dashj/platform/dapiclient/provider/ListDAPIAddressProvider;", "addresses", "", "", "baseBanTime", "", "dpp"})
    @SourceDebugExtension(value={"SMAP\nListDAPIAddressProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListDAPIAddressProvider.kt\norg/dashj/platform/dapiclient/provider/ListDAPIAddressProvider$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1549#2:97\n1620#2,3:98\n*S KotlinDebug\n*F\n+ 1 ListDAPIAddressProvider.kt\norg/dashj/platform/dapiclient/provider/ListDAPIAddressProvider$Companion\n*L\n18#1:97\n18#1:98,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ListDAPIAddressProvider fromList(@NotNull List<String> addresses, int baseBanTime) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(addresses, (String)"addresses");
            Iterable $this$map$iv = addresses;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new DAPIAddress((String)it));
            }
            int n = baseBanTime;
            List list = (List)destination$iv$iv;
            return new ListDAPIAddressProvider(list, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

