/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dapiclient.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.evolution.Masternode;
import org.bitcoinj.evolution.SimplifiedMasternodeList;
import org.bitcoinj.evolution.SimplifiedMasternodeListEntry;
import org.bitcoinj.evolution.SimplifiedMasternodeListManager;
import org.dashj.platform.dapiclient.provider.DAPIAddress;
import org.dashj.platform.dapiclient.provider.DAPIAddressListProvider;
import org.dashj.platform.dapiclient.provider.ListDAPIAddressProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001dH\u0016R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/dashj/platform/dapiclient/provider/SimplifiedMasternodeListDAPIAddressProvider;", "Lorg/dashj/platform/dapiclient/provider/DAPIAddressListProvider;", "smlProvider", "Lorg/bitcoinj/evolution/SimplifiedMasternodeListManager;", "listProvider", "Lorg/dashj/platform/dapiclient/provider/ListDAPIAddressProvider;", "(Lorg/bitcoinj/evolution/SimplifiedMasternodeListManager;Lorg/dashj/platform/dapiclient/provider/ListDAPIAddressProvider;)V", "alwaysBanAddresses", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "backupListProvider", "getBackupListProvider", "()Lorg/dashj/platform/dapiclient/provider/ListDAPIAddressProvider;", "whiteList", "addAcceptedAddress", "", "address", "addBannedAddress", "getErrorStatistics", "getLiveAddress", "Lorg/dashj/platform/dapiclient/provider/DAPIAddress;", "getStatistics", "hasLiveAddresses", "", "setBanBaseTime", "banBaseTime", "", "toList", "", "dpp"})
@SourceDebugExtension(value={"SMAP\nSimplifiedMasternodeListDAPIAddressProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifiedMasternodeListDAPIAddressProvider.kt\norg/dashj/platform/dapiclient/provider/SimplifiedMasternodeListDAPIAddressProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1855#2,2:106\n766#2:108\n857#2,2:109\n1549#2:111\n1620#2,3:112\n*S KotlinDebug\n*F\n+ 1 SimplifiedMasternodeListDAPIAddressProvider.kt\norg/dashj/platform/dapiclient/provider/SimplifiedMasternodeListDAPIAddressProvider\n*L\n32#1:106,2\n84#1:108\n84#1:109,2\n102#1:111\n102#1:112,3\n*E\n"})
public final class SimplifiedMasternodeListDAPIAddressProvider
implements DAPIAddressListProvider {
    @NotNull
    private final SimplifiedMasternodeListManager smlProvider;
    @NotNull
    private final ListDAPIAddressProvider listProvider;
    @NotNull
    private final ListDAPIAddressProvider backupListProvider;
    @NotNull
    private final ArrayList<String> alwaysBanAddresses;
    @NotNull
    private final ArrayList<String> whiteList;

    public SimplifiedMasternodeListDAPIAddressProvider(@NotNull SimplifiedMasternodeListManager smlProvider, @NotNull ListDAPIAddressProvider listProvider) {
        Intrinsics.checkNotNullParameter((Object)smlProvider, (String)"smlProvider");
        Intrinsics.checkNotNullParameter((Object)listProvider, (String)"listProvider");
        this.smlProvider = smlProvider;
        this.listProvider = listProvider;
        this.alwaysBanAddresses = new ArrayList();
        this.whiteList = new ArrayList();
        this.backupListProvider = new ListDAPIAddressProvider(this.listProvider.getAllAddresses(), this.listProvider.getBaseBanTime());
    }

    @NotNull
    public final ListDAPIAddressProvider getBackupListProvider() {
        return this.backupListProvider;
    }

    @Override
    @NotNull
    public DAPIAddress getLiveAddress() {
        SimplifiedMasternodeList sml = this.smlProvider.getListAtChainTip();
        HashMap addressesByProRegTxHash = new HashMap();
        Iterable $this$forEach$iv = this.listProvider.getAllAddresses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DAPIAddress it = (DAPIAddress)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getProRegTxHash(), (Object)Sha256Hash.ZERO_HASH)) continue;
            ((Map)addressesByProRegTxHash).put(it.getProRegTxHash(), it);
        }
        ArrayList updatedAddresses = new ArrayList();
        if (sml.getValidMNsCount() > 0) {
            sml.forEachMN(true, arg_0 -> SimplifiedMasternodeListDAPIAddressProvider.getLiveAddress$lambda$1(addressesByProRegTxHash, this, updatedAddresses, arg_0));
            this.listProvider.setAddresses(updatedAddresses);
        }
        return this.listProvider.hasLiveAddresses() ? this.listProvider.getLiveAddress() : this.backupListProvider.getLiveAddress();
    }

    @Override
    public boolean hasLiveAddresses() {
        return this.listProvider.hasLiveAddresses();
    }

    @Override
    public void addBannedAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.alwaysBanAddresses.add(address);
    }

    @Override
    public void addAcceptedAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.whiteList.add(address);
    }

    @Override
    public void setBanBaseTime(int banBaseTime) {
        this.listProvider.setBanBaseTime(banBaseTime);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getStatistics() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.listProvider.getAddresses();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DAPIAddress it = (DAPIAddress)element$iv$iv;
            boolean bl = false;
            if (!it.isBanned()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List currentlyBanned = (List)destination$iv$iv;
        return "  ---always banned addresses: " + this.alwaysBanAddresses + "\ntotal masternodes          : " + this.listProvider.getAddresses().size() + "\ntotal banned nodes         : " + currentlyBanned.size() + "\n                             " + currentlyBanned;
    }

    @Override
    @NotNull
    public String getErrorStatistics() {
        return this.listProvider.getErrorStatistics();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DAPIAddress> toList() {
        void $this$mapTo$iv$iv;
        ArrayList evoNodeList = new ArrayList();
        this.smlProvider.getMasternodeList().forEachMN(true, arg_0 -> SimplifiedMasternodeListDAPIAddressProvider.toList$lambda$3(evoNodeList, arg_0));
        Iterable $this$map$iv = evoNodeList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Masternode masternode = (Masternode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getService().getSocketAddress().getHostString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.service.socketAddress.hostString");
            Sha256Hash sha256Hash = it.getProRegTxHash();
            Intrinsics.checkNotNullExpressionValue((Object)sha256Hash, (String)"it.proRegTxHash");
            collection.add(new DAPIAddress(string, sha256Hash));
        }
        return (List)destination$iv$iv;
    }

    private static final void getLiveAddress$lambda$1(HashMap $addressesByProRegTxHash, SimplifiedMasternodeListDAPIAddressProvider this$0, ArrayList $updatedAddresses, SimplifiedMasternodeListEntry it) {
        Intrinsics.checkNotNullParameter((Object)$addressesByProRegTxHash, (String)"$addressesByProRegTxHash");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$updatedAddresses, (String)"$updatedAddresses");
        DAPIAddress address = (DAPIAddress)$addressesByProRegTxHash.get(it.getProRegTxHash());
        if (address == null) {
            String string = it.getService().getSocketAddress().getHostString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.service.socketAddress.hostString");
            Sha256Hash sha256Hash = it.getProRegTxHash();
            Intrinsics.checkNotNullExpressionValue((Object)sha256Hash, (String)"it.proRegTxHash");
            address = new DAPIAddress(string, sha256Hash);
        } else {
            String string = it.getService().getSocketAddress().getHostString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.service.socketAddress.hostString");
            address.setHost(string);
        }
        if (!this$0.alwaysBanAddresses.contains(address.getHost()) && this$0.whiteList.contains(address.getHost())) {
            $updatedAddresses.add(address);
        }
    }

    private static final void toList$lambda$3(ArrayList $evoNodeList, SimplifiedMasternodeListEntry it) {
        Intrinsics.checkNotNullParameter((Object)$evoNodeList, (String)"$evoNodeList");
        if (it.isHPMN()) {
            $evoNodeList.add(it);
        }
    }
}

