/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dashpay;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.DelayKt;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.wallet.FriendKeyChain;
import org.bitcoinj.wallet.Wallet;
import org.bouncycastle.crypto.params.KeyParameter;
import org.dashj.platform.dapiclient.model.DocumentQuery;
import org.dashj.platform.dashpay.BlockchainIdentity;
import org.dashj.platform.dashpay.ContactRequest;
import org.dashj.platform.dashpay.ContactRequests;
import org.dashj.platform.dashpay.RetryDelayType;
import org.dashj.platform.dashpay.callback.SendContactRequestCallback;
import org.dashj.platform.dashpay.callback.WalletSignerCallback;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.Identity;
import org.dashj.platform.dpp.identity.IdentityPublicKey;
import org.dashj.platform.sdk.BlockHeight;
import org.dashj.platform.sdk.CoreBlockHeight;
import org.dashj.platform.sdk.Document;
import org.dashj.platform.sdk.Purpose;
import org.dashj.platform.sdk.SWIGTYPE_p_DashSdk;
import org.dashj.platform.sdk.SecurityLevel;
import org.dashj.platform.sdk.base.Result;
import org.dashj.platform.sdk.dashsdk;
import org.dashj.platform.sdk.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ<\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001a2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ<\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001a2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ;\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J6\u0010 \u001a\u00020(2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Lorg/dashj/platform/dashpay/ContactRequests;", "", "platform", "Lorg/dashj/platform/sdk/platform/Platform;", "(Lorg/dashj/platform/sdk/platform/Platform;)V", "getPlatform", "()Lorg/dashj/platform/sdk/platform/Platform;", "create", "Lorg/dashj/platform/dashpay/ContactRequest;", "fromUser", "Lorg/dashj/platform/dashpay/BlockchainIdentity;", "toUser", "Lorg/dashj/platform/dpp/identity/Identity;", "aesKey", "Lorg/bouncycastle/crypto/params/KeyParameter;", "createDocument", "Lorg/dashj/platform/dpp/document/Document;", "contactPub", "", "toUserPublicKey", "Lorg/dashj/platform/dpp/identity/IdentityPublicKey;", "get", "", "userId", "", "toUserId", "", "afterTime", "", "retrieveAll", "startAfter", "Lorg/dashj/platform/dpp/identifier/Identifier;", "watchContactRequest", "fromUserId", "retryCount", "", "delayMillis", "retryDelayType", "Lorg/dashj/platform/dashpay/RetryDelayType;", "(Lorg/dashj/platform/dpp/identifier/Identifier;Lorg/dashj/platform/dpp/identifier/Identifier;IJLorg/dashj/platform/dashpay/RetryDelayType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "callback", "Lorg/dashj/platform/dashpay/callback/SendContactRequestCallback;", "Companion", "dpp"})
public final class ContactRequests {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Platform platform;
    @NotNull
    public static final String CONTACTREQUEST_DOCUMENT = "dashpay.contactRequest";
    private static final Logger log = LoggerFactory.getLogger(ContactRequest.class);

    public ContactRequests(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    @NotNull
    public final ContactRequest create(@NotNull BlockchainIdentity fromUser, @NotNull Identity toUser, @Nullable KeyParameter aesKey) {
        IdentityPublicKey toUserPublicKey;
        Intrinsics.checkNotNullParameter((Object)fromUser, (String)"fromUser");
        Intrinsics.checkNotNullParameter((Object)toUser, (String)"toUser");
        fromUser.checkIdentity();
        FriendKeyChain contactKeyChain = fromUser.getReceiveFromContactChain(toUser, aesKey);
        DeterministicKey contactKey = contactKeyChain.getWatchingKey();
        byte[] contactPub = contactKey.serializeContactPub();
        IdentityPublicKey identityPublicKey = toUser.getFirstPublicKey(Purpose.ENCRYPTION);
        if (identityPublicKey == null) {
            identityPublicKey = toUser.getPublicKeys().get(BlockchainIdentity.KeyIndexPurpose.AUTHENTICATION.ordinal());
        }
        if ((toUserPublicKey = identityPublicKey) != null) {
            Intrinsics.checkNotNullExpressionValue((Object)contactPub, (String)"contactPub");
            org.dashj.platform.dpp.document.Document contactRequestDocument = this.createDocument(fromUser, contactPub, toUser, toUserPublicKey, aesKey);
            Wallet wallet = fromUser.getWallet();
            Intrinsics.checkNotNull((Object)wallet);
            WalletSignerCallback signer = new WalletSignerCallback(wallet, aesKey);
            Identity identity = fromUser.getIdentity();
            Intrinsics.checkNotNull((Object)identity);
            IdentityPublicKey identityPublicKey2 = identity.getFirstPublicKey(Purpose.AUTHENTICATION, SecurityLevel.HIGH);
            if (identityPublicKey2 == null) {
                throw new IllegalStateException("can't find a public key with HIGH security level".toString());
            }
            IdentityPublicKey highIdentityPublicKey = identityPublicKey2;
            SWIGTYPE_p_DashSdk sWIGTYPE_p_DashSdk = this.platform.getRustSdk();
            Identity identity2 = fromUser.getIdentity();
            Intrinsics.checkNotNull((Object)identity2);
            Long credits = (Long)dashsdk.platformMobileFetchIdentityFetchIdentityBalanceWithSdk((SWIGTYPE_p_DashSdk)sWIGTYPE_p_DashSdk, (org.dashj.platform.sdk.Identifier)identity2.getId().toNative()).unwrap();
            log.info("credit balance: {}", (Object)credits);
            SWIGTYPE_p_DashSdk sWIGTYPE_p_DashSdk2 = this.platform.getRustSdk();
            Document document = contactRequestDocument.toNative();
            Identifier identifier = contactRequestDocument.getDataContractId();
            Intrinsics.checkNotNull((Object)identifier);
            Result documentResult = dashsdk.platformMobilePutPutDocumentSdk((SWIGTYPE_p_DashSdk)sWIGTYPE_p_DashSdk2, (Document)document, (org.dashj.platform.sdk.Identifier)identifier.toNative(), (String)contactRequestDocument.getType(), (org.dashj.platform.sdk.IdentityPublicKey)highIdentityPublicKey.toNative(), (BlockHeight)new BlockHeight(10000), (CoreBlockHeight)new CoreBlockHeight(this.platform.getCoreBlockHeight()), (long)signer.getNativeContext(), (BigInteger)BigInteger.valueOf(signer.getSignerCallback()));
            Document publishedContactRequest = (Document)documentResult.unwrap();
            Intrinsics.checkNotNullExpressionValue((Object)publishedContactRequest, (String)"publishedContactRequest");
            Identifier identifier2 = contactRequestDocument.getDataContractId();
            Intrinsics.checkNotNull((Object)identifier2);
            return new ContactRequest(new org.dashj.platform.dpp.document.Document(publishedContactRequest, identifier2));
        }
        throw new IllegalArgumentException("No valid keys to use in toUser's identity");
    }

    @NotNull
    public final org.dashj.platform.dpp.document.Document createDocument(@NotNull BlockchainIdentity fromUser, @NotNull byte[] contactPub, @NotNull Identity toUser, @NotNull IdentityPublicKey toUserPublicKey, @Nullable KeyParameter aesKey) {
        Intrinsics.checkNotNullParameter((Object)fromUser, (String)"fromUser");
        Intrinsics.checkNotNullParameter((Object)contactPub, (String)"contactPub");
        Intrinsics.checkNotNullParameter((Object)toUser, (String)"toUser");
        Intrinsics.checkNotNullParameter((Object)toUserPublicKey, (String)"toUserPublicKey");
        Triple<byte[], byte[], Integer> triple = fromUser.encryptExtendedPublicKey(contactPub, toUser, toUserPublicKey.getId(), aesKey);
        byte[] encryptedContactPubKey = (byte[])triple.component1();
        byte[] encryptedAccountLabel = (byte[])triple.component2();
        int senderKeyIndex = ((Number)triple.component3()).intValue();
        log.info("encryptedPublicKey: {} for encryption", (Object)ExtensionsKt.toHex(encryptedContactPubKey));
        int accountReference = fromUser.getAccountReference(aesKey, toUser);
        org.dashj.platform.dpp.document.Document contactRequestDocument = ContactRequest.Companion.builder(this.platform).to(toUser.getId()).from(fromUser.getUniqueIdentifier()).encryptedPubKey(encryptedContactPubKey, senderKeyIndex, toUserPublicKey.getId()).accountReference(accountReference).encryptedAccountLabel(encryptedAccountLabel).build().getDocument();
        return contactRequestDocument;
    }

    @NotNull
    public final List<org.dashj.platform.dpp.document.Document> get(@NotNull String userId, boolean toUserId, long afterTime, boolean retrieveAll, @Nullable Identifier startAfter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.get(Identifier.Companion.from$default(Identifier.Companion, userId, null, 2, null), toUserId, afterTime, retrieveAll, startAfter);
    }

    public static /* synthetic */ List get$default(ContactRequests contactRequests, String string, boolean bl, long l, boolean bl2, Identifier identifier, int n, Object object) {
        if ((n & 4) != 0) {
            l = 0L;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            identifier = null;
        }
        return contactRequests.get(string, bl, l, bl2, identifier);
    }

    @NotNull
    public final List<org.dashj.platform.dpp.document.Document> get(@NotNull Identifier userId, boolean toUserId, long afterTime, boolean retrieveAll, @Nullable Identifier startAfter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        DocumentQuery.Builder documentQuery = new DocumentQuery.Builder(null, null, 0, null, null, 31, null);
        if (toUserId) {
            Object[] objectArray = new Object[]{"toUserId", "==", userId};
            documentQuery.where(CollectionsKt.listOf((Object[])objectArray));
        } else {
            Object[] objectArray = new Object[]{"$ownerId", "==", userId};
            documentQuery.where(CollectionsKt.listOf((Object[])objectArray));
        }
        if (afterTime >= 0L) {
            documentQuery.where("$createdAt", ">", afterTime);
            documentQuery.orderBy("$createdAt", true);
        }
        if (retrieveAll) {
            documentQuery.limit(-1);
        } else {
            documentQuery.limit(100);
        }
        return this.platform.getDocuments().getAll(CONTACTREQUEST_DOCUMENT, documentQuery.startAfter(startAfter).build());
    }

    public static /* synthetic */ List get$default(ContactRequests contactRequests, Identifier identifier, boolean bl, long l, boolean bl2, Identifier identifier2, int n, Object object) {
        if ((n & 4) != 0) {
            l = 0L;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            identifier2 = null;
        }
        return contactRequests.get(identifier, bl, l, bl2, identifier2);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object watchContactRequest(@NotNull Identifier var1_1, @NotNull Identifier var2_2, int var3_3, long var4_4, @NotNull RetryDelayType var6_5, @NotNull Continuation<? super org.dashj.platform.dpp.document.Document> var7_6) {
        if (!(var7_6 instanceof watchContactRequest.1)) ** GOTO lbl-1000
        var14_7 = var7_6;
        if ((var14_7.label & -2147483648) != 0) {
            var14_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var7_6){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ ContactRequests this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.watchContactRequest(null, null, 0, 0L, null, (Continuation<? super org.dashj.platform.dpp.document.Document>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                documentQuery = new DocumentQuery.Builder(null, null, 0, null, null, 31, null);
                documentQuery.where("$ownerId", "==", fromUserId).where("toUserId", "==", toUserId);
                result = this.platform.getDocuments().get("dashpay.contactRequest", documentQuery.build());
                if (((Collection)result).isEmpty() == false) {
                    return result.get(0);
                }
                if (retryCount <= 0) break;
                var12_12 = retryDelayType;
                switch (WhenMappings.$EnumSwitchMapping$0[var12_12.ordinal()]) {
                    case 1: {
                        v0 = 1;
                        break;
                    }
                    case 2: {
                        v0 = 1;
                        break;
                    }
                    default: {
                        v0 = 1;
                    }
                }
                nextDelay = delayMillis * (long)v0;
                $continuation.L$0 = this;
                $continuation.L$1 = fromUserId;
                $continuation.L$2 = toUserId;
                $continuation.L$3 = retryDelayType;
                $continuation.I$0 = retryCount;
                $continuation.J$0 = nextDelay;
                $continuation.label = 1;
                v1 = DelayKt.delay((long)nextDelay, (Continuation)$continuation);
                if (v1 == var15_9) {
                    return var15_9;
                }
                ** GOTO lbl50
            }
            case 1: {
                nextDelay = $continuation.J$0;
                retryCount = $continuation.I$0;
                retryDelayType = (RetryDelayType)$continuation.L$3;
                toUserId = (Identifier)$continuation.L$2;
                fromUserId = (Identifier)$continuation.L$1;
                this = (ContactRequests)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl50:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v2 = this.watchContactRequest(fromUserId, toUserId, retryCount - 1, nextDelay, retryDelayType, (Continuation<? super org.dashj.platform.dpp.document.Document>)$continuation);
                if (v2 == var15_9) {
                    return var15_9;
                }
                ** GOTO lbl62
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl62:
                // 2 sources

                return v2;
            }
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void watchContactRequest(@NotNull Identifier fromUserId, @NotNull Identifier toUserId, int retryCount, long delayMillis, @NotNull RetryDelayType retryDelayType, @NotNull SendContactRequestCallback callback) {
        Intrinsics.checkNotNullParameter((Object)fromUserId, (String)"fromUserId");
        Intrinsics.checkNotNullParameter((Object)toUserId, (String)"toUserId");
        Intrinsics.checkNotNullParameter((Object)((Object)retryDelayType), (String)"retryDelayType");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        DocumentQuery.Builder documentQuery = DocumentQuery.Companion.builder();
        documentQuery.where("$ownerId", "==", fromUserId).where("toUserId", "==", toUserId);
        List<org.dashj.platform.dpp.document.Document> result = this.platform.getDocuments().get(CONTACTREQUEST_DOCUMENT, documentQuery.build());
        if (!((Collection)result).isEmpty()) {
            callback.onComplete(fromUserId, toUserId);
        } else if (retryCount > 0) {
            new Timer("monitorSendContactRequestStatus", false).schedule(new TimerTask(delayMillis, retryDelayType, this, fromUserId, toUserId, retryCount, callback){
                final /* synthetic */ long $delayMillis$inlined;
                final /* synthetic */ RetryDelayType $retryDelayType$inlined;
                final /* synthetic */ ContactRequests this$0;
                final /* synthetic */ Identifier $fromUserId$inlined;
                final /* synthetic */ Identifier $toUserId$inlined;
                final /* synthetic */ int $retryCount$inlined;
                final /* synthetic */ SendContactRequestCallback $callback$inlined;
                {
                    this.$delayMillis$inlined = l;
                    this.$retryDelayType$inlined = retryDelayType;
                    this.this$0 = contactRequests;
                    this.$fromUserId$inlined = identifier;
                    this.$toUserId$inlined = identifier2;
                    this.$retryCount$inlined = n;
                    this.$callback$inlined = sendContactRequestCallback;
                }

                public void run() {
                    int n;
                    TimerTask $this$watchContactRequest_u24lambda_u240 = this;
                    boolean bl = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[this.$retryDelayType$inlined.ordinal()]) {
                        case 1: {
                            n = 1;
                            break;
                        }
                        case 2: {
                            n = 1;
                            break;
                        }
                        default: {
                            n = 1;
                        }
                    }
                    long nextDelay = this.$delayMillis$inlined * (long)n;
                    this.this$0.watchContactRequest(this.$fromUserId$inlined, this.$toUserId$inlined, this.$retryCount$inlined - 1, nextDelay, this.$retryDelayType$inlined, this.$callback$inlined);
                }
            }, delayMillis);
        } else {
            callback.onTimeout(fromUserId, toUserId);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/dashj/platform/dashpay/ContactRequests$Companion;", "", "()V", "CONTACTREQUEST_DOCUMENT", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RetryDelayType.values().length];
            try {
                nArray[RetryDelayType.SLOW20.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RetryDelayType.SLOW50.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

