/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dashpay;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.evolution.AssetLockTransaction;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.WalletExtension;
import org.bitcoinj.wallet.authentication.AuthenticationGroupExtension;
import org.dashj.platform.dashpay.BlockchainIdentity;
import org.dashj.platform.dashpay.Dashpay;
import org.dashj.platform.dashpay.IdentityStatus;
import org.dashj.platform.dpp.BaseObject;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.identity.Identity;
import org.dashj.platform.dpp.identity.IdentityPublicKey;
import org.dashj.platform.dpp.identity.IdentityPublicKeyKt;
import org.dashj.platform.sdk.KeyType;
import org.dashj.platform.sdk.Purpose;
import org.dashj.platform.sdk.SecurityLevel;
import org.dashj.platform.sdk.platform.Identities;
import org.dashj.platform.sdk.platform.Names;
import org.dashj.platform.sdk.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/dashj/platform/dashpay/DashPayWalletExtension;", "Lorg/bitcoinj/wallet/WalletExtension;", "platform", "Lorg/dashj/platform/sdk/platform/Platform;", "authenticationGroupExtension", "Lorg/bitcoinj/wallet/authentication/AuthenticationGroupExtension;", "(Lorg/dashj/platform/sdk/platform/Platform;Lorg/bitcoinj/wallet/authentication/AuthenticationGroupExtension;)V", "getAuthenticationGroupExtension", "()Lorg/bitcoinj/wallet/authentication/AuthenticationGroupExtension;", "blockchainIdentity", "Lorg/dashj/platform/dashpay/BlockchainIdentity;", "getBlockchainIdentity", "()Lorg/dashj/platform/dashpay/BlockchainIdentity;", "setBlockchainIdentity", "(Lorg/dashj/platform/dashpay/BlockchainIdentity;)V", "getPlatform", "()Lorg/dashj/platform/sdk/platform/Platform;", "deserializeWalletExtension", "", "containingWallet", "Lorg/bitcoinj/wallet/Wallet;", "data", "", "getWalletExtensionID", "", "isWalletExtensionMandatory", "", "serializeWalletExtension", "toString", "validate", "Companion", "dpp"})
@SourceDebugExtension(value={"SMAP\nDashPayWalletExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DashPayWalletExtension.kt\norg/dashj/platform/dashpay/DashPayWalletExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1549#2:171\n1620#2,3:172\n1549#2:175\n1620#2,3:176\n*S KotlinDebug\n*F\n+ 1 DashPayWalletExtension.kt\norg/dashj/platform/dashpay/DashPayWalletExtension\n*L\n48#1:171\n48#1:172,3\n128#1:175\n128#1:176,3\n*E\n"})
public final class DashPayWalletExtension
implements WalletExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Platform platform;
    @NotNull
    private final AuthenticationGroupExtension authenticationGroupExtension;
    @Nullable
    private BlockchainIdentity blockchainIdentity;
    @NotNull
    public static final String NAME = "org.dashj.dashpay.DashPayWalletExtension";
    @NotNull
    private static final Logger log;

    public DashPayWalletExtension(@NotNull Platform platform, @NotNull AuthenticationGroupExtension authenticationGroupExtension) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)authenticationGroupExtension, (String)"authenticationGroupExtension");
        this.platform = platform;
        this.authenticationGroupExtension = authenticationGroupExtension;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    @NotNull
    public final AuthenticationGroupExtension getAuthenticationGroupExtension() {
        return this.authenticationGroupExtension;
    }

    @Nullable
    public final BlockchainIdentity getBlockchainIdentity() {
        return this.blockchainIdentity;
    }

    public final void setBlockchainIdentity(@Nullable BlockchainIdentity blockchainIdentity) {
        this.blockchainIdentity = blockchainIdentity;
    }

    /*
     * WARNING - void declaration
     */
    public void deserializeWalletExtension(@Nullable Wallet containingWallet, @Nullable byte[] data) {
        block6: {
            Object object;
            Dashpay.DashPay dashpay = Dashpay.DashPay.parseFrom(data);
            Dashpay.Identity identityProto = dashpay.getIdentity();
            if (dashpay.hasIdentity()) {
                if (this.blockchainIdentity == null) {
                    Wallet wallet = containingWallet;
                    Intrinsics.checkNotNull((Object)wallet);
                    this.blockchainIdentity = new BlockchainIdentity(this.platform, 0, wallet, this.authenticationGroupExtension);
                }
                BlockchainIdentity blockchainIdentity = this.blockchainIdentity;
                if (blockchainIdentity != null) {
                    Collection<IdentityPublicKey> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    BlockchainIdentity it = blockchainIdentity;
                    boolean bl = false;
                    byte[] byArray = identityProto.getId().toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"identityProto.id.toByteArray()");
                    Identifier identifier = Identifier.Companion.from(byArray);
                    List<Dashpay.IdentityPublicKey> list = identityProto.getPublicKeysList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"identityProto.publicKeysList");
                    Iterable iterable = list;
                    Identifier identifier2 = identifier;
                    BlockchainIdentity blockchainIdentity2 = it;
                    boolean $i$f$map = false;
                    void var11_11 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        Dashpay.IdentityPublicKey identityPublicKey = (Dashpay.IdentityPublicKey)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        int n = it2.getId();
                        KeyType keyType = KeyType.swigToEnum((int)it2.getType());
                        Intrinsics.checkNotNullExpressionValue((Object)keyType, (String)"swigToEnum(it.type)");
                        Purpose purpose = Purpose.swigToEnum((int)it2.getPurpose());
                        Intrinsics.checkNotNullExpressionValue((Object)purpose, (String)"swigToEnum(it.purpose)");
                        SecurityLevel securityLevel = SecurityLevel.swigToEnum((int)it2.getSecurityLevel());
                        Intrinsics.checkNotNullExpressionValue((Object)securityLevel, (String)"swigToEnum(it.securityLevel)");
                        byte[] byArray2 = it2.getData().toByteArray();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"it.data.toByteArray()");
                        IdentityPublicKey ipk = new IdentityPublicKey(n, keyType, purpose, securityLevel, byArray2, it2.getReadOnly(), it2.getDisabledAt() == -1L ? null : Long.valueOf(it2.getDisabledAt()), it2.getSignature().size() != 0 ? it2.getSignature().toByteArray() : null);
                        collection.add(ipk);
                    }
                    collection = (List)destination$iv$iv;
                    int n = identityProto.getProtocolVersion();
                    int n2 = identityProto.getRevision();
                    long l = identityProto.getBalance();
                    List list2 = CollectionsKt.toMutableList((Collection)collection);
                    Identifier identifier3 = identifier2;
                    blockchainIdentity2.setIdentity(new Identity(identifier3, list2, l, n2, n));
                    it.setRegistrationStatus(IdentityStatus.REGISTERED);
                    Identity identity = it.getIdentity();
                    Intrinsics.checkNotNull((Object)identity);
                    it.setUniqueId(identity.getId().toSha256Hash());
                }
            }
            String string = dashpay.getUsername();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dashpay.username");
            if (!(((CharSequence)string).length() > 0)) break block6;
            BlockchainIdentity blockchainIdentity = this.blockchainIdentity;
            if (blockchainIdentity != null) {
                blockchainIdentity.setCurrentUsername(dashpay.getUsername());
            }
            if (!dashpay.getSalt().isEmpty() && (object = this.blockchainIdentity) != null && (object = ((BlockchainIdentity)object).getUsernameSalts()) != null) {
                String string2 = dashpay.getUsername();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dashpay.username");
                byte[] byArray = dashpay.getSalt().toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"dashpay.salt.toByteArray()");
                object.put(string2, byArray);
            }
        }
    }

    public final boolean validate(@NotNull Wallet containingWallet) {
        Intrinsics.checkNotNullParameter((Object)containingWallet, (String)"containingWallet");
        WalletExtension walletExtension = containingWallet.addOrGetExistingExtension((WalletExtension)new AuthenticationGroupExtension(containingWallet.getParams()));
        Intrinsics.checkNotNull((Object)walletExtension, (String)"null cannot be cast to non-null type org.bitcoinj.wallet.authentication.AuthenticationGroupExtension");
        AuthenticationGroupExtension authExtension = (AuthenticationGroupExtension)walletExtension;
        List list = authExtension.getAssetLockTransactions();
        for (AssetLockTransaction cftx : list) {
            AssetLockTransaction tx = authExtension.getAssetLockTransaction((Transaction)cftx);
            BlockchainIdentity blockchainIdentity = this.blockchainIdentity;
            if (Intrinsics.areEqual((Object)tx.getIdentityId().toString(), (Object)String.valueOf(blockchainIdentity != null ? blockchainIdentity.getUniqueId() : null))) continue;
            BlockchainIdentity blockchainIdentity2 = this.blockchainIdentity;
            log.error("Error: " + tx.getIdentityId() + " != " + (blockchainIdentity2 != null ? blockchainIdentity2.getUniqueId() : null));
            return false;
        }
        Identities identities = this.platform.getIdentities();
        BlockchainIdentity blockchainIdentity = this.blockchainIdentity;
        Intrinsics.checkNotNull((Object)blockchainIdentity);
        Identity identity = identities.get(blockchainIdentity.getUniqueIdentifier());
        if (identity == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Error: ");
            BlockchainIdentity blockchainIdentity3 = this.blockchainIdentity;
            Intrinsics.checkNotNull((Object)blockchainIdentity3);
            log.error(stringBuilder.append(blockchainIdentity3.getUniqueIdentifier()).append(" does not exist").toString());
            return false;
        }
        Names names = this.platform.getNames();
        BlockchainIdentity blockchainIdentity4 = this.blockchainIdentity;
        Intrinsics.checkNotNull((Object)blockchainIdentity4);
        String string = blockchainIdentity4.getCurrentUsername();
        Intrinsics.checkNotNull((Object)string);
        if (names.get(string) == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Error: DPNS domain ");
            BlockchainIdentity blockchainIdentity5 = this.blockchainIdentity;
            Intrinsics.checkNotNull((Object)blockchainIdentity5);
            log.error(stringBuilder.append(blockchainIdentity5.getCurrentUsername()).append(" does not exist").toString());
            return false;
        }
        return true;
    }

    @NotNull
    public String getWalletExtensionID() {
        return NAME;
    }

    public boolean isWalletExtensionMandatory() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public byte[] serializeWalletExtension() {
        Object object;
        Dashpay.DashPay.Builder builder = Dashpay.DashPay.newBuilder();
        Object object2 = this.blockchainIdentity;
        if (object2 != null && (object2 = ((BlockchainIdentity)object2).getIdentity()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Dashpay.Identity.Builder builder2;
            Object identity = object2;
            boolean bl = false;
            Dashpay.Identity.Builder $this$serializeWalletExtension_u24lambda_u244_u24lambda_u243 = builder2 = Dashpay.Identity.newBuilder();
            boolean bl2 = false;
            $this$serializeWalletExtension_u24lambda_u244_u24lambda_u243.setProtocolVersion(((BaseObject)identity).getProtocolVersion());
            Iterable iterable = ((Identity)identity).getPublicKeys();
            Dashpay.Identity.Builder builder3 = $this$serializeWalletExtension_u24lambda_u244_u24lambda_u243;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void identityPublicKey;
                IdentityPublicKey identityPublicKey2 = (IdentityPublicKey)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Long l = identityPublicKey.getDisabledAt();
                collection.add((Dashpay.IdentityPublicKey)Dashpay.IdentityPublicKey.newBuilder().setId(identityPublicKey.getId()).setData(ByteString.copyFrom((byte[])identityPublicKey.getData())).setPurpose(IdentityPublicKeyKt.getValue(identityPublicKey.getPurpose())).setReadOnly(identityPublicKey.getReadOnly()).setSecurityLevel(IdentityPublicKeyKt.getValue(identityPublicKey.getSecurityLevel())).setType(IdentityPublicKeyKt.getValue(identityPublicKey.getType())).setDisabledAt(l != null ? l : -1L).build());
            }
            builder3.addAllPublicKeys((List)destination$iv$iv);
            $this$serializeWalletExtension_u24lambda_u244_u24lambda_u243.setRevision(((Identity)identity).getRevision());
            $this$serializeWalletExtension_u24lambda_u244_u24lambda_u243.setBalance(((Identity)identity).getBalance());
            $this$serializeWalletExtension_u24lambda_u244_u24lambda_u243.setId(ByteString.copyFrom((byte[])((Identity)identity).getId().toBuffer()));
            Dashpay.Identity.Builder identityBuilder = builder2;
            builder.setIdentity(identityBuilder);
        }
        if ((object = this.blockchainIdentity) != null && (object = ((BlockchainIdentity)object).getCurrentUsername()) != null) {
            Object it = object;
            boolean bl = false;
            builder.setUsername((String)it);
            Object object3 = this.blockchainIdentity;
            if (object3 != null && (object3 = ((BlockchainIdentity)object3).getUsernameSalts()) != null) {
                byte[] byArray = (byte[])object3.get(it);
                object3 = byArray;
                if (byArray != null) {
                    Object salt = object3;
                    boolean bl4 = false;
                    builder.setSalt(ByteString.copyFrom((byte[])salt));
                }
            }
        }
        byte[] byArray = ((Dashpay.DashPay)builder.build()).toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"builder.build().toByteArray()");
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public String toString() {
        builder = new StringBuilder();
        builder.append("DASHPAY\n");
        if (this.blockchainIdentity == null) ** GOTO lbl-1000
        v0 = this.blockchainIdentity;
        Intrinsics.checkNotNull((Object)v0);
        if (v0.getIdentity() != null) {
            v1 = builder.append("  ").append("username:  ");
            v2 = this.blockchainIdentity;
            Intrinsics.checkNotNull((Object)v2);
            v3 = v1.append(v2.getCurrentUsername()).append("\n  identity: ");
            v4 = this.blockchainIdentity;
            Intrinsics.checkNotNull((Object)v4);
            v3.append(v4.getUniqueIdentifier());
        } else lbl-1000:
        // 2 sources

        {
            builder.append("  No username for this wallet.");
        }
        v5 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"builder.toString()");
        return v5;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DashPayWalletExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DashPayWalletExtension::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/dashj/platform/dashpay/DashPayWalletExtension$Companion;", "", "()V", "NAME", "", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

