/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dashpay.callback;

import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Utils;
import org.bouncycastle.crypto.params.KeyParameter;
import org.dashj.platform.dpp.identity.IdentityPublicKey;
import org.dashj.platform.sdk.callbacks.Signer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/dashj/platform/dashpay/callback/SimpleSignerCallback;", "Lorg/dashj/platform/sdk/callbacks/Signer;", "keyMap", "", "Lorg/dashj/platform/dpp/identity/IdentityPublicKey;", "Lorg/bitcoinj/core/ECKey;", "keyParameter", "Lorg/bouncycastle/crypto/params/KeyParameter;", "(Ljava/util/Map;Lorg/bouncycastle/crypto/params/KeyParameter;)V", "sign", "", "publicKey", "data", "dpp"})
@SourceDebugExtension(value={"SMAP\nSimpleSignerCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleSignerCallback.kt\norg/dashj/platform/dashpay/callback/SimpleSignerCallback\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1#2:26\n*E\n"})
public final class SimpleSignerCallback
extends Signer {
    @NotNull
    private final Map<IdentityPublicKey, ECKey> keyMap;
    @Nullable
    private final KeyParameter keyParameter;

    public SimpleSignerCallback(@NotNull Map<IdentityPublicKey, ? extends ECKey> keyMap, @Nullable KeyParameter keyParameter) {
        Intrinsics.checkNotNullParameter(keyMap, (String)"keyMap");
        this.keyMap = keyMap;
        this.keyParameter = keyParameter;
    }

    @NotNull
    public byte[] sign(@NotNull byte[] publicKey, @NotNull byte[] data) {
        IdentityPublicKey identityPublicKey;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Iterable iterable = this.keyMap.keySet();
            for (Object t : iterable) {
                IdentityPublicKey it = (IdentityPublicKey)t;
                boolean bl = false;
                if (!Arrays.equals(it.getData(), publicKey)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        IdentityPublicKey identityPublicKey2 = identityPublicKey = (IdentityPublicKey)v0;
        if (identityPublicKey2 != null) {
            IdentityPublicKey it = identityPublicKey2;
            boolean bl = false;
            ECKey key = this.keyMap.get(identityPublicKey);
            if (key != null) {
                byte[] byArray = key.signHash(Sha256Hash.twiceOf((byte[])data), this.keyParameter);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"key.signHash(Sha256Hash.\u2026ceOf(data), keyParameter)");
                return byArray;
            }
        }
        throw new IllegalStateException(("cannot find public key " + Utils.HEX.encode(publicKey)).toString());
    }
}

