/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dashpay.callback;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.IDeterministicKey;
import org.bitcoinj.wallet.AuthenticationKeyChain;
import org.bitcoinj.wallet.KeyChainGroupExtension;
import org.bitcoinj.wallet.Wallet;
import org.bitcoinj.wallet.authentication.AuthenticationGroupExtension;
import org.bouncycastle.crypto.params.KeyParameter;
import org.dashj.platform.sdk.callbacks.Signer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/dashj/platform/dashpay/callback/WalletSignerCallback;", "Lorg/dashj/platform/sdk/callbacks/Signer;", "wallet", "Lorg/bitcoinj/wallet/Wallet;", "keyParameter", "Lorg/bouncycastle/crypto/params/KeyParameter;", "(Lorg/bitcoinj/wallet/Wallet;Lorg/bouncycastle/crypto/params/KeyParameter;)V", "authenticationGroup", "Lorg/bitcoinj/wallet/authentication/AuthenticationGroupExtension;", "getKeyParameter", "()Lorg/bouncycastle/crypto/params/KeyParameter;", "sign", "", "publicKey", "data", "dpp"})
public final class WalletSignerCallback
extends Signer {
    @Nullable
    private final KeyParameter keyParameter;
    @NotNull
    private final AuthenticationGroupExtension authenticationGroup;

    public WalletSignerCallback(@NotNull Wallet wallet, @Nullable KeyParameter keyParameter) {
        Intrinsics.checkNotNullParameter((Object)wallet, (String)"wallet");
        this.keyParameter = keyParameter;
        KeyChainGroupExtension keyChainGroupExtension = wallet.getKeyChainExtension(AuthenticationGroupExtension.EXTENSION_ID);
        Intrinsics.checkNotNull((Object)keyChainGroupExtension, (String)"null cannot be cast to non-null type org.bitcoinj.wallet.authentication.AuthenticationGroupExtension");
        this.authenticationGroup = (AuthenticationGroupExtension)keyChainGroupExtension;
    }

    @Nullable
    public final KeyParameter getKeyParameter() {
        return this.keyParameter;
    }

    @NotNull
    public byte[] sign(@NotNull byte[] publicKey, @NotNull byte[] data) {
        IDeterministicKey key;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        AuthenticationKeyChain authenticationKeyChain = this.authenticationGroup.getIdentityKeyChain();
        Object object = key = authenticationKeyChain != null ? authenticationKeyChain.findKeyFromPubKey(publicKey) : null;
        if (key != null) {
            byte[] byArray = key.signHash(Sha256Hash.twiceOf((byte[])data), this.keyParameter);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"key.signHash(Sha256Hash.\u2026ceOf(data), keyParameter)");
            return byArray;
        }
        throw new IllegalStateException(("cannot find public key " + Utils.HEX.encode(publicKey)).toString());
    }
}

