/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp;

import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.VarInt;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.util.Cbor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0006\u0010\u0012\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\tJ\b\u0010\u0014\u001a\u00020\tH\u0016J\u0016\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bH&J\u0016\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bH&R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0017"}, d2={"Lorg/dashj/platform/dpp/BaseObject;", "", "protocolVersion", "", "(I)V", "getProtocolVersion", "()I", "setProtocolVersion", "encodeProtocolEntity", "", "payload", "", "", "equals", "", "other", "hash", "hashCode", "hashOnce", "hashTwice", "toBuffer", "toJSON", "toObject", "dpp"})
public abstract class BaseObject {
    private int protocolVersion;

    public BaseObject(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public /* synthetic */ BaseObject(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        this(n);
    }

    public final int getProtocolVersion() {
        return this.protocolVersion;
    }

    public final void setProtocolVersion(int n) {
        this.protocolVersion = n;
    }

    @NotNull
    public abstract Map<String, Object> toJSON();

    @NotNull
    public abstract Map<String, Object> toObject();

    @NotNull
    public byte[] toBuffer() {
        Map serializedData = MapsKt.toMutableMap(this.toObject());
        serializedData.remove("protocolVersion");
        return this.encodeProtocolEntity(serializedData);
    }

    @NotNull
    public final byte[] encodeProtocolEntity(@NotNull Map<String, ? extends Object> payload) {
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        byte[] encoded = Cbor.INSTANCE.encode(payload);
        VarInt protocolVersionCompact = new VarInt((long)this.protocolVersion);
        byte[] buffer = new byte[encoded.length + protocolVersionCompact.getSizeInBytes()];
        System.arraycopy(protocolVersionCompact.encode(), 0, buffer, 0, protocolVersionCompact.getSizeInBytes());
        System.arraycopy(encoded, 0, buffer, protocolVersionCompact.getSizeInBytes(), encoded.length);
        return buffer;
    }

    @NotNull
    public byte[] hash() {
        return ExtensionsKt.hashTwice(this.toBuffer());
    }

    @NotNull
    public final byte[] hashTwice() {
        return ExtensionsKt.hashTwice(this.toBuffer());
    }

    @NotNull
    public final byte[] hashOnce() {
        return ExtensionsKt.hashOnce(this.toBuffer());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.dashj.platform.dpp.BaseObject");
        BaseObject cfr_ignored_0 = (BaseObject)other;
        return Arrays.equals(this.hash(), ((BaseObject)other).hash());
    }

    public int hashCode() {
        return Sha256Hash.wrap((byte[])this.hash()).hashCode();
    }

    public BaseObject() {
        this(0, 1, null);
    }
}

