/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.params.TestNet3Params;
import org.dashj.platform.dpp.StateRepository;
import org.dashj.platform.dpp.contract.ContractFactory;
import org.dashj.platform.dpp.document.DocumentFactory;
import org.dashj.platform.dpp.identity.IdentityFactory;
import org.dashj.platform.dpp.validation.JsonSchemaValidator;
import org.dashj.platform.dpp.validation.Validator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010&\u001a\u00020\u0005J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\u00020(2\u0006\u0010\u0004\u001a\u00020\u0005R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006,"}, d2={"Lorg/dashj/platform/dpp/DashPlatformProtocol;", "", "stateRepository", "Lorg/dashj/platform/dpp/StateRepository;", "params", "Lorg/bitcoinj/core/NetworkParameters;", "(Lorg/dashj/platform/dpp/StateRepository;Lorg/bitcoinj/core/NetworkParameters;)V", "(Lorg/dashj/platform/dpp/StateRepository;)V", "dataContract", "Lorg/dashj/platform/dpp/contract/ContractFactory;", "getDataContract", "()Lorg/dashj/platform/dpp/contract/ContractFactory;", "setDataContract", "(Lorg/dashj/platform/dpp/contract/ContractFactory;)V", "document", "Lorg/dashj/platform/dpp/document/DocumentFactory;", "getDocument", "()Lorg/dashj/platform/dpp/document/DocumentFactory;", "setDocument", "(Lorg/dashj/platform/dpp/document/DocumentFactory;)V", "identity", "Lorg/dashj/platform/dpp/identity/IdentityFactory;", "getIdentity", "()Lorg/dashj/platform/dpp/identity/IdentityFactory;", "setIdentity", "(Lorg/dashj/platform/dpp/identity/IdentityFactory;)V", "getParams", "()Lorg/bitcoinj/core/NetworkParameters;", "setParams", "(Lorg/bitcoinj/core/NetworkParameters;)V", "protocolVersion", "", "getProtocolVersion", "()I", "setProtocolVersion", "(I)V", "getStateRepository", "()Lorg/dashj/platform/dpp/StateRepository;", "getNetworkParameters", "initialize", "", "validator", "Lorg/dashj/platform/dpp/validation/Validator;", "setNetworkParameters", "dpp"})
public final class DashPlatformProtocol {
    @NotNull
    private final StateRepository stateRepository;
    public DocumentFactory document;
    public ContractFactory dataContract;
    public IdentityFactory identity;
    private int protocolVersion;
    public NetworkParameters params;

    public DashPlatformProtocol(@NotNull StateRepository stateRepository) {
        Intrinsics.checkNotNullParameter((Object)stateRepository, (String)"stateRepository");
        this.stateRepository = stateRepository;
        this.protocolVersion = 1;
        this.initialize(new JsonSchemaValidator());
    }

    @NotNull
    public final StateRepository getStateRepository() {
        return this.stateRepository;
    }

    @NotNull
    public final DocumentFactory getDocument() {
        DocumentFactory documentFactory = this.document;
        if (documentFactory != null) {
            return documentFactory;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"document");
        return null;
    }

    public final void setDocument(@NotNull DocumentFactory documentFactory) {
        Intrinsics.checkNotNullParameter((Object)documentFactory, (String)"<set-?>");
        this.document = documentFactory;
    }

    @NotNull
    public final ContractFactory getDataContract() {
        ContractFactory contractFactory = this.dataContract;
        if (contractFactory != null) {
            return contractFactory;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dataContract");
        return null;
    }

    public final void setDataContract(@NotNull ContractFactory contractFactory) {
        Intrinsics.checkNotNullParameter((Object)contractFactory, (String)"<set-?>");
        this.dataContract = contractFactory;
    }

    @NotNull
    public final IdentityFactory getIdentity() {
        IdentityFactory identityFactory = this.identity;
        if (identityFactory != null) {
            return identityFactory;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"identity");
        return null;
    }

    public final void setIdentity(@NotNull IdentityFactory identityFactory) {
        Intrinsics.checkNotNullParameter((Object)identityFactory, (String)"<set-?>");
        this.identity = identityFactory;
    }

    public final int getProtocolVersion() {
        return this.protocolVersion;
    }

    public final void setProtocolVersion(int n) {
        this.protocolVersion = n;
    }

    @NotNull
    public final NetworkParameters getParams() {
        NetworkParameters networkParameters = this.params;
        if (networkParameters != null) {
            return networkParameters;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"params");
        return null;
    }

    public final void setParams(@NotNull NetworkParameters networkParameters) {
        Intrinsics.checkNotNullParameter((Object)networkParameters, (String)"<set-?>");
        this.params = networkParameters;
    }

    public DashPlatformProtocol(@NotNull StateRepository stateRepository, @NotNull NetworkParameters params) {
        Intrinsics.checkNotNullParameter((Object)stateRepository, (String)"stateRepository");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this(stateRepository);
        this.setNetworkParameters(params);
    }

    private final void initialize(Validator validator) {
        this.setDocument(new DocumentFactory(this, this.stateRepository));
        this.setDataContract(new ContractFactory(this, this.stateRepository));
        this.setIdentity(new IdentityFactory(this, this.stateRepository));
    }

    @NotNull
    public final NetworkParameters getNetworkParameters() {
        if (this.params == null) {
            try {
                Context context;
                Context context2 = context = Context.get();
                Object object = context2 != null ? context2.getParams() : null;
                if (object == null) {
                    TestNet3Params testNet3Params = TestNet3Params.get();
                    Intrinsics.checkNotNullExpressionValue((Object)testNet3Params, (String)"get()");
                    object = (NetworkParameters)testNet3Params;
                }
                this.setParams((NetworkParameters)object);
                Context.propagate((Context)context);
            }
            catch (IllegalStateException e) {
                TestNet3Params testNet3Params = TestNet3Params.get();
                Intrinsics.checkNotNullExpressionValue((Object)testNet3Params, (String)"get()");
                this.setParams((NetworkParameters)testNet3Params);
            }
        }
        return this.getParams();
    }

    public final void setNetworkParameters(@NotNull NetworkParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.setParams(params);
    }
}

