/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp;

import com.google.common.io.BaseEncoding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.Sha256Hash;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.util.Converters;
import org.dashj.platform.sdk.TimestampMillis;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001e\u0010\u0003\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a.\u0010\u0003\u001a\u00020\u0004*\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a&\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b*\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b\u001a\n\u0010\f\u001a\u00020\r*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\r*\u00020\r\u001a\n\u0010\u000f\u001a\u00020\t*\u00020\r\u001a\n\u0010\u0010\u001a\u00020\t*\u00020\r\u001a\n\u0010\u0011\u001a\u00020\t*\u00020\r\u001a\n\u0010\u0012\u001a\u00020\r*\u00020\t\u001a\n\u0010\u0013\u001a\u00020\t*\u00020\r\u001a\f\u0010\u0014\u001a\u00020\t*\u00020\rH\u0007\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\r\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019\u00a8\u0006\u001a"}, d2={"append", "Lorg/json/JSONObject;", "jsonObject", "deepCompare", "", "", "", "list", "", "", "map", "deepCopy", "hashOnce", "", "hashTwice", "toBase58", "toBase64", "toBase64Padded", "toByteArray", "toHex", "toHexString", "toSha256Hash", "Lorg/bitcoinj/core/Sha256Hash;", "toTimestampMillis", "Lorg/dashj/platform/sdk/TimestampMillis;", "", "dpp"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\norg/dashj/platform/dpp/ExtensionsKt\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,166:1\n32#2,2:167\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\norg/dashj/platform/dpp/ExtensionsKt\n*L\n19#1:167,2\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final JSONObject append(@NotNull JSONObject $this$append, @NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)$this$append, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Iterator iterator = jsonObject.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"jsonObject.keys()");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String it = (String)element$iv;
            boolean bl = false;
            $this$append.put(it, jsonObject.get(it));
        }
        return $this$append;
    }

    @NotNull
    public static final String toHex(@NotNull byte[] $this$toHex) {
        Intrinsics.checkNotNullParameter((Object)$this$toHex, (String)"<this>");
        return ArraysKt.joinToString$default((byte[])$this$toHex, (CharSequence)"", null, null, (int)0, null, (Function1)toHex.1.INSTANCE, (int)30, null);
    }

    @Deprecated(message="Use toHex", replaceWith=@ReplaceWith(expression="toHex()", imports={"org.dashj.platform.dpp.util"}))
    @NotNull
    public static final String toHexString(@NotNull byte[] $this$toHexString) {
        Intrinsics.checkNotNullParameter((Object)$this$toHexString, (String)"<this>");
        return ExtensionsKt.toHex($this$toHexString);
    }

    @NotNull
    public static final String toBase64(@NotNull byte[] $this$toBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$toBase64, (String)"<this>");
        String string = BaseEncoding.base64().omitPadding().encode($this$toBase64);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"base64().omitPadding().encode(this)");
        return string;
    }

    @NotNull
    public static final String toBase64Padded(@NotNull byte[] $this$toBase64Padded) {
        Intrinsics.checkNotNullParameter((Object)$this$toBase64Padded, (String)"<this>");
        String string = BaseEncoding.base64().encode($this$toBase64Padded);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"base64().encode(this)");
        return string;
    }

    @NotNull
    public static final String toBase58(@NotNull byte[] $this$toBase58) {
        Intrinsics.checkNotNullParameter((Object)$this$toBase58, (String)"<this>");
        String string = Base58.encode((byte[])$this$toBase58);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(this)");
        return string;
    }

    @NotNull
    public static final Sha256Hash toSha256Hash(@NotNull byte[] $this$toSha256Hash) {
        Intrinsics.checkNotNullParameter((Object)$this$toSha256Hash, (String)"<this>");
        Sha256Hash sha256Hash = Sha256Hash.twiceOf((byte[])$this$toSha256Hash);
        Intrinsics.checkNotNullExpressionValue((Object)sha256Hash, (String)"twiceOf(this)");
        return sha256Hash;
    }

    @NotNull
    public static final byte[] hashTwice(@NotNull byte[] $this$hashTwice) {
        Intrinsics.checkNotNullParameter((Object)$this$hashTwice, (String)"<this>");
        byte[] byArray = Sha256Hash.hashTwice((byte[])$this$hashTwice);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"hashTwice(this)");
        return byArray;
    }

    @NotNull
    public static final byte[] hashOnce(@NotNull byte[] $this$hashOnce) {
        Intrinsics.checkNotNullParameter((Object)$this$hashOnce, (String)"<this>");
        byte[] byArray = Sha256Hash.hash((byte[])$this$hashOnce);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"hash(this)");
        return byArray;
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull String $this$toByteArray) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
        try {
            byte[] byArray2 = Base58.decode((String)$this$toByteArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n        Base58.decode(this)\n    }");
            byArray = byArray2;
        }
        catch (AddressFormatException e) {
            byte[] byArray3;
            try {
                byArray3 = Converters.fromHex($this$toByteArray);
            }
            catch (IllegalArgumentException e2) {
                byte[] byArray4;
                try {
                    byArray4 = Converters.fromBase64($this$toByteArray);
                }
                catch (IllegalArgumentException e3) {
                    throw new IllegalArgumentException("string is not base58, base64 or hex: " + $this$toByteArray, e3);
                }
                byArray3 = byArray4;
            }
            byArray = byArray3;
        }
        return byArray;
    }

    @NotNull
    public static final List<Object> deepCopy(@NotNull List<? extends Object> $this$deepCopy) {
        Intrinsics.checkNotNullParameter($this$deepCopy, (String)"<this>");
        ArrayList copy = new ArrayList();
        copy.addAll($this$deepCopy);
        return copy;
    }

    @NotNull
    public static final Map<String, Object> deepCopy(@NotNull Map<String, ? extends Object> $this$deepCopy) {
        Intrinsics.checkNotNullParameter($this$deepCopy, (String)"<this>");
        HashMap copy = new HashMap($this$deepCopy.size());
        for (String key : $this$deepCopy.keySet()) {
            Object value = $this$deepCopy.get(key);
            if (value instanceof Map) {
                ((Map)copy).put(key, ExtensionsKt.deepCopy((Map)value));
                continue;
            }
            if (value instanceof List) {
                ((Map)copy).put(key, ExtensionsKt.deepCopy((List)value));
                continue;
            }
            ((Map)copy).put(key, value);
        }
        return copy;
    }

    public static final boolean deepCompare(@NotNull List<? extends Object> $this$deepCompare, @NotNull List<? extends Object> list) {
        Intrinsics.checkNotNullParameter($this$deepCompare, (String)"<this>");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (list.size() != $this$deepCompare.size()) {
            return false;
        }
        boolean equals = true;
        int n = $this$deepCompare.size();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            Object thisValue = $this$deepCompare.get(i);
            Object value = list.get(i);
            if (value instanceof byte[] && thisValue instanceof byte[]) {
                bl = Arrays.equals((byte[])thisValue, (byte[])value);
            } else if (thisValue instanceof Map && value instanceof Map) {
                bl = ExtensionsKt.deepCompare((Map)thisValue, (Map)value);
            } else if (thisValue instanceof List && value instanceof List) {
                bl = ExtensionsKt.deepCompare((List)thisValue, (List)value);
            } else if (thisValue instanceof Integer && value instanceof Long) {
                Object object = value;
                bl = object instanceof Long && (long)((Number)thisValue).intValue() == ((Number)object).longValue();
            } else {
                bl = equals = thisValue instanceof Long && value instanceof Integer ? Intrinsics.areEqual((Object)thisValue, (Object)((Number)value).intValue()) : Intrinsics.areEqual((Object)thisValue, (Object)value);
            }
            if (!equals) break;
        }
        return equals;
    }

    public static final boolean deepCompare(@NotNull Map<String, ? extends Object> $this$deepCompare, @NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter($this$deepCompare, (String)"<this>");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        if (map.size() != $this$deepCompare.size() || !Intrinsics.areEqual(map.keySet(), $this$deepCompare.keySet())) {
            return false;
        }
        boolean equals = true;
        for (String key : $this$deepCompare.keySet()) {
            boolean bl;
            Object thisValue = $this$deepCompare.get(key);
            Object value = map.get(key);
            if (thisValue == null) {
                bl = value == null;
            } else if (value == null) {
                bl = false;
            } else if (value instanceof byte[] && thisValue instanceof byte[]) {
                bl = Arrays.equals((byte[])thisValue, (byte[])value);
            } else if (thisValue instanceof Map && value instanceof Map) {
                bl = ExtensionsKt.deepCompare((Map)thisValue, (Map)value);
            } else if (thisValue instanceof List && value instanceof List) {
                bl = ExtensionsKt.deepCompare((List)thisValue, (List)value);
            } else if (thisValue instanceof Integer && value instanceof Long) {
                Object object = value;
                bl = object instanceof Long && (long)((Number)thisValue).intValue() == ((Number)object).longValue();
            } else {
                bl = thisValue instanceof Long && value instanceof Integer ? Intrinsics.areEqual((Object)thisValue, (Object)((Number)value).intValue()) : Intrinsics.areEqual((Object)thisValue, (Object)value);
            }
            if (equals = bl) continue;
            break;
        }
        return equals;
    }

    @NotNull
    public static final TimestampMillis toTimestampMillis(long $this$toTimestampMillis) {
        return new TimestampMillis($this$toTimestampMillis);
    }
}

