/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.contract;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.dashj.platform.dpp.DashPlatformProtocol;
import org.dashj.platform.dpp.Factory;
import org.dashj.platform.dpp.StateRepository;
import org.dashj.platform.dpp.contract.DataContract;
import org.dashj.platform.dpp.contract.DataContractCreateTransition;
import org.dashj.platform.dpp.contract.DataContractUpdateTransition;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.util.Entropy;
import org.dashj.platform.dpp.util.HashUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fJ$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000f2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\bJ\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\n2\b\b\u0002\u0010\u0017\u001a\u00020\u0018J&\u0010\u0019\u001a\u00020\b2\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0002"}, d2={"Lorg/dashj/platform/dpp/contract/ContractFactory;", "Lorg/dashj/platform/dpp/Factory;", "dpp", "Lorg/dashj/platform/dpp/DashPlatformProtocol;", "stateRepository", "Lorg/dashj/platform/dpp/StateRepository;", "(Lorg/dashj/platform/dpp/DashPlatformProtocol;Lorg/dashj/platform/dpp/StateRepository;)V", "create", "Lorg/dashj/platform/dpp/contract/DataContract;", "ownerId", "", "documents", "", "", "", "Lorg/dashj/platform/dpp/identifier/Identifier;", "createDataContractCreateTransition", "Lorg/dashj/platform/dpp/contract/DataContractCreateTransition;", "dataContract", "createDataContractUpdateTransition", "Lorg/dashj/platform/dpp/contract/DataContractUpdateTransition;", "createFromBuffer", "payload", "options", "Lorg/dashj/platform/dpp/Factory$Options;", "createFromObject", "rawContract"})
public final class ContractFactory
extends Factory {
    public ContractFactory(@NotNull DashPlatformProtocol dpp, @NotNull StateRepository stateRepository) {
        Intrinsics.checkNotNullParameter((Object)dpp, (String)"dpp");
        Intrinsics.checkNotNullParameter((Object)stateRepository, (String)"stateRepository");
        super(dpp, stateRepository);
    }

    @NotNull
    public final DataContract create(@NotNull byte[] ownerId, @NotNull Map<String, ? extends Object> documents) {
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        return this.create(Identifier.Companion.from(ownerId), documents);
    }

    @NotNull
    public final DataContract create(@NotNull Identifier ownerId, @NotNull Map<String, ? extends Object> documents) {
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        byte[] dataContractEntropy = Entropy.generate();
        byte[] dataContractId = HashUtils.INSTANCE.generateDataContractId(ownerId.toBuffer(), dataContractEntropy);
        DataContract dataContract = new DataContract(1, Identifier.Companion.from(dataContractId), ownerId, 1, "https://schema.dash.org/dpp-0-4-0/meta/data-contract", MapsKt.toMutableMap(documents), null, 64, null);
        dataContract.setEntropy(dataContractEntropy);
        return dataContract;
    }

    @NotNull
    public final DataContract createFromObject(@NotNull Map<String, ? extends Object> rawContract, @NotNull Factory.Options options) {
        Intrinsics.checkNotNullParameter(rawContract, (String)"rawContract");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return new DataContract(rawContract);
    }

    public static /* synthetic */ DataContract createFromObject$default(ContractFactory contractFactory, Map map, Factory.Options options, int n, Object object) {
        if ((n & 2) != 0) {
            options = new Factory.Options(false, 1, null);
        }
        return contractFactory.createFromObject(map, options);
    }

    @NotNull
    public final DataContract createFromBuffer(@NotNull byte[] payload, @NotNull Factory.Options options) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Pair<Integer, Map<String, Object>> pair = Factory.Companion.decodeProtocolEntity(payload);
        int protocolVersion = ((Number)pair.component1()).intValue();
        Map rawDataContract = (Map)pair.component2();
        Integer n = protocolVersion;
        rawDataContract.put("protocolVersion", n);
        return this.createFromObject(rawDataContract, options);
    }

    public static /* synthetic */ DataContract createFromBuffer$default(ContractFactory contractFactory, byte[] byArray, Factory.Options options, int n, Object object) {
        if ((n & 2) != 0) {
            options = new Factory.Options(false, 1, null);
        }
        return contractFactory.createFromBuffer(byArray, options);
    }

    @NotNull
    public final DataContractCreateTransition createDataContractCreateTransition(@NotNull DataContract dataContract) {
        Intrinsics.checkNotNullParameter((Object)dataContract, (String)"dataContract");
        return new DataContractCreateTransition(this.getDpp().getNetworkParameters(), dataContract);
    }

    @NotNull
    public final DataContractUpdateTransition createDataContractUpdateTransition(@NotNull DataContract dataContract) {
        Intrinsics.checkNotNullParameter((Object)dataContract, (String)"dataContract");
        return new DataContractUpdateTransition(this.getDpp().getNetworkParameters(), dataContract);
    }
}

