/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.document;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dashj.platform.dpp.DashPlatformProtocol;
import org.dashj.platform.dpp.Factory;
import org.dashj.platform.dpp.StateRepository;
import org.dashj.platform.dpp.contract.DataContract;
import org.dashj.platform.dpp.document.Document;
import org.dashj.platform.dpp.errors.InvalidDocumentTypeError;
import org.dashj.platform.dpp.identifier.Identifier;
import org.dashj.platform.dpp.util.Entropy;
import org.dashj.platform.dpp.util.HashUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J6\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J&\u0010\u0017\u001a\u00020\b2\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0002"}, d2={"Lorg/dashj/platform/dpp/document/DocumentFactory;", "Lorg/dashj/platform/dpp/Factory;", "dpp", "Lorg/dashj/platform/dpp/DashPlatformProtocol;", "stateRepository", "Lorg/dashj/platform/dpp/StateRepository;", "(Lorg/dashj/platform/dpp/DashPlatformProtocol;Lorg/dashj/platform/dpp/StateRepository;)V", "create", "Lorg/dashj/platform/dpp/document/Document;", "dataContract", "Lorg/dashj/platform/dpp/contract/DataContract;", "ownerId", "Lorg/dashj/platform/dpp/identifier/Identifier;", "type", "", "data", "", "", "createFromBuffer", "payload", "", "options", "Lorg/dashj/platform/dpp/Factory$Options;", "createFromObject", "rawDocument"})
@SourceDebugExtension(value={"SMAP\nDocumentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentFactory.kt\norg/dashj/platform/dpp/document/DocumentFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class DocumentFactory
extends Factory {
    public DocumentFactory(@NotNull DashPlatformProtocol dpp, @NotNull StateRepository stateRepository) {
        Intrinsics.checkNotNullParameter((Object)dpp, (String)"dpp");
        Intrinsics.checkNotNullParameter((Object)stateRepository, (String)"stateRepository");
        super(dpp, stateRepository);
    }

    @NotNull
    public final Document create(@NotNull DataContract dataContract, @NotNull Identifier ownerId, @NotNull String type, @NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter((Object)dataContract, (String)"dataContract");
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        if (!dataContract.isDocumentDefined(type)) {
            throw new InvalidDocumentTypeError(dataContract, type);
        }
        byte[] documentEntropy = Entropy.generate();
        Identifier dataContractId = dataContract.getId();
        byte[] id = HashUtils.INSTANCE.generateDocumentId(dataContractId.toBuffer(), ownerId.toBuffer(), type, documentEntropy);
        HashMap<String, Object> rawDocument = new HashMap<String, Object>();
        ((Map)rawDocument).put("$protocolVersion", 1);
        ((Map)rawDocument).put("$id", id);
        ((Map)rawDocument).put("$type", type);
        ((Map)rawDocument).put("$dataContractId", dataContract.getId());
        ((Map)rawDocument).put("$ownerId", ownerId);
        ((Map)rawDocument).put("$revision", 1L);
        for (String key : data.keySet()) {
            Object it;
            if (data.get(key) == null) continue;
            boolean bl = false;
            rawDocument.put(key, it);
        }
        Document document = new Document((Map<String, ? extends Object>)rawDocument, dataContract);
        document.setEntropy(documentEntropy);
        return document;
    }

    public static /* synthetic */ Document create$default(DocumentFactory documentFactory, DataContract dataContract, Identifier identifier, String string, Map map, int n, Object object) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        return documentFactory.create(dataContract, identifier, string, map);
    }

    @NotNull
    public final Document createFromObject(@NotNull Map<String, ? extends Object> rawDocument, @NotNull Factory.Options options) {
        DataContract dataContract;
        Intrinsics.checkNotNullParameter(rawDocument, (String)"rawDocument");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Identifier dataContractId = Identifier.Companion.from$default(Identifier.Companion, rawDocument.get("$dataContractId"), null, 2, null);
        DataContract dataContract2 = dataContract = this.getStateRepository().fetchDataContract(dataContractId);
        Intrinsics.checkNotNull((Object)dataContract2);
        return new Document(rawDocument, dataContract2);
    }

    public static /* synthetic */ Document createFromObject$default(DocumentFactory documentFactory, Map map, Factory.Options options, int n, Object object) {
        if ((n & 2) != 0) {
            options = new Factory.Options(false, 1, null);
        }
        return documentFactory.createFromObject(map, options);
    }

    @NotNull
    public final Document createFromBuffer(@NotNull byte[] payload, @NotNull Factory.Options options) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Pair<Integer, Map<String, Object>> pair = Factory.Companion.decodeProtocolEntity(payload);
        int protocolVersion = ((Number)pair.component1()).intValue();
        Map rawDocument = (Map)pair.component2();
        Integer n = protocolVersion;
        rawDocument.put("$protocolVersion", n);
        return this.createFromObject(rawDocument, options);
    }

    public static /* synthetic */ Document createFromBuffer$default(DocumentFactory documentFactory, byte[] byArray, Factory.Options options, int n, Object object) {
        if ((n & 2) != 0) {
            options = new Factory.Options(false, 1, null);
        }
        return documentFactory.createFromBuffer(byArray, options);
    }
}

