/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.errors;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.dashj.platform.dpp.errors.ErrorMetadata;
import org.dashj.platform.dpp.util.Cbor;
import org.dashj.platform.dpp.util.Converters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u0003J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/dashj/platform/dpp/errors/DriveErrorMetadata;", "Lorg/dashj/platform/dpp/errors/ErrorMetadata;", "metadata", "", "(Ljava/lang/String;)V", "data", "", "", "getData", "()Ljava/util/Map;", "getFirstError", "toString", "Companion", "dpp"})
public final class DriveErrorMetadata
extends ErrorMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Object> data;
    @NotNull
    private static final String metadataHeader = "Metadata(";
    @NotNull
    private static final String dataField = "drive-error-data-bin=";
    private static final int dataFieldSize = 21;

    public DriveErrorMetadata(@NotNull String metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        super(metadata);
        int cursor = 0;
        if (StringsKt.startsWith$default((String)metadata, (String)metadataHeader, (boolean)false, (int)2, null)) {
            Map<String, Object> map;
            int dataStart = StringsKt.indexOf$default((CharSequence)metadata, (String)dataField, (int)(cursor += 9), (boolean)false, (int)4, null) + 21;
            if (dataStart != -1) {
                int dataEnd = StringsKt.indexOf$default((CharSequence)metadata, (char)')', (int)dataStart, (boolean)false, (int)4, null);
                if (dataEnd != -1) {
                    String string = metadata.substring(dataStart, dataEnd);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String dataString = string;
                    byte[] dataBytes = Converters.fromBase64(dataString);
                    map = Cbor.INSTANCE.decode(dataBytes);
                } else {
                    map = MapsKt.emptyMap();
                }
            } else {
                map = MapsKt.emptyMap();
            }
            this.data = map;
        } else {
            this.data = MapsKt.emptyMap();
        }
    }

    @NotNull
    public final Map<String, Object> getData() {
        return this.data;
    }

    @NotNull
    public final String getFirstError() {
        String string;
        if (!this.data.isEmpty()) {
            Object object = this.data.get("errors");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any?>>");
            Object v = ((Map)CollectionsKt.first((List)((List)object))).get("name");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)v;
        } else {
            string = "No extra error information specified.";
        }
        return string;
    }

    @Override
    @NotNull
    public String toString() {
        return this.data.isEmpty() ? super.getMetadata() : metadataHeader + this.data + ')';
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/dashj/platform/dpp/errors/DriveErrorMetadata$Companion;", "", "()V", "dataField", "", "dataFieldSize", "", "metadataHeader", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

