/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.platform.dpp.errors.concensus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.dashj.platform.dpp.ExtensionsKt;
import org.dashj.platform.dpp.errors.ConcensusErrorMetadata;
import org.dashj.platform.dpp.errors.DPPException;
import org.dashj.platform.dpp.errors.concensus.Codes;
import org.dashj.platform.dpp.util.Cbor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fJ\b\u0010\u0010\u001a\u00020\u0003H\u0016R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/dashj/platform/dpp/errors/concensus/ConcensusException;", "Lorg/dashj/platform/dpp/errors/DPPException;", "message", "", "(Ljava/lang/String;)V", "arguments", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getArguments", "()Ljava/util/ArrayList;", "getCode", "", "setArguments", "", "", "toString", "Companion", "dpp"})
public abstract class ConcensusException
extends DPPException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<Object> arguments;

    public ConcensusException(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message);
        this.arguments = new ArrayList();
    }

    @NotNull
    public final ArrayList<Object> getArguments() {
        return this.arguments;
    }

    public final int getCode() {
        try {
            Codes code = Codes.Companion.getByName(this.getName());
            return code.getCode();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error is not defined: " + this.getName(), e);
        }
    }

    public final void setArguments(@NotNull List<? extends Object> arguments) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        this.arguments.addAll((Collection<Object>)arguments);
    }

    @Override
    @NotNull
    public String toString() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"arguments", this.arguments)};
        HashMap data = MapsKt.hashMapOf((Pair[])pairArray);
        return "Metadata(code=" + this.getCode() + ", drive-error-data-bin=" + ExtensionsKt.toBase64(Cbor.INSTANCE.encode(data));
    }

    @JvmStatic
    @NotNull
    public static final ConcensusException create(int code, @NotNull List<? extends Object> arguments) {
        return Companion.create(code, arguments);
    }

    @JvmStatic
    @NotNull
    public static final ConcensusException create(@NotNull Codes code, @NotNull List<? extends Object> arguments) {
        return Companion.create(code, arguments);
    }

    @JvmStatic
    @NotNull
    public static final ConcensusException create(@NotNull Codes code, @NotNull Map<String, ? extends Object> driveErrorData) {
        return Companion.create(code, driveErrorData);
    }

    @JvmStatic
    @NotNull
    public static final ConcensusException create(@NotNull ConcensusErrorMetadata errorMetadata) {
        return Companion.create(errorMetadata);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0007J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\rH\u0007J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0002J$\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\rH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/dashj/platform/dpp/errors/concensus/ConcensusException$Companion;", "", "()V", "create", "Lorg/dashj/platform/dpp/errors/concensus/ConcensusException;", "code", "", "arguments", "", "errorMetadata", "Lorg/dashj/platform/dpp/errors/ConcensusErrorMetadata;", "Lorg/dashj/platform/dpp/errors/concensus/Codes;", "driveErrorData", "", "", "createException", "dpp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ConcensusException create(int code, @NotNull List<? extends Object> arguments) {
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            try {
                Codes codeEnum = Codes.Companion.getByCode(code);
                return this.createException(codeEnum, arguments);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error is not defined: " + code, e);
            }
        }

        @JvmStatic
        @NotNull
        public final ConcensusException create(@NotNull Codes code, @NotNull List<? extends Object> arguments) {
            Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            try {
                return this.createException(code, arguments);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error is not defined: " + (Object)((Object)code), e);
            }
        }

        @JvmStatic
        @NotNull
        public final ConcensusException create(@NotNull Codes code, @NotNull Map<String, ? extends Object> driveErrorData) {
            Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
            Intrinsics.checkNotNullParameter(driveErrorData, (String)"driveErrorData");
            try {
                return this.createException(code, driveErrorData);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error is not defined: " + (Object)((Object)code), e);
            }
        }

        @JvmStatic
        @NotNull
        public final ConcensusException create(@NotNull ConcensusErrorMetadata errorMetadata) {
            Intrinsics.checkNotNullParameter((Object)errorMetadata, (String)"errorMetadata");
            return this.create(errorMetadata.getCode(), errorMetadata.getArguments());
        }

        private final ConcensusException createException(Codes code, Map<String, ? extends Object> driveErrorData) {
            Object object = driveErrorData.get("arguments");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any>");
            return this.createException(code, (List)object);
        }

        private final ConcensusException createException(Codes code, List<? extends Object> arguments) {
            String string = "error " + (Object)((Object)code) + ", " + arguments;
            return new ConcensusException(string){};
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

